/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger.breakpoints;

import com.intellij.DynamicBundle;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.ui.breakpoints.CallerFiltersField;
import com.intellij.debugger.ui.breakpoints.ClassFiltersField;
import com.intellij.debugger.ui.breakpoints.EditInstanceFiltersDialog;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public class JavaBreakpointFiltersPanel<T extends JavaBreakpointProperties, B extends XBreakpoint<T>>
extends XBreakpointCustomPropertiesPanel<B> {
    private JPanel myConditionsPanel;
    private JCheckBox myInstanceFiltersCheckBox;
    private JPanel myInstanceFiltersFieldPanel;
    private JCheckBox myClassFiltersCheckBox;
    private ClassFiltersField myClassFiltersField;
    private JCheckBox myPassCountCheckbox;
    private JTextField myPassCountField;
    private JCheckBox myCatchCheckBox;
    private ClassFiltersField myCatchClassFilters;
    private JPanel myCatchFiltersPanel;
    private JPanel myPassCountFieldPanel;
    private JCheckBox myCallerFiltersCheckBox;
    private CallerFiltersField myCallerFilters;
    private JPanel myCallerFiltersPanel;
    private final FieldPanel myInstanceFiltersField;
    private InstanceFilter[] myInstanceFilters = InstanceFilter.EMPTY_ARRAY;
    protected final Project myProject;
    private PsiClass myBreakpointPsiClass;

    public JavaBreakpointFiltersPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myInstanceFiltersField = new FieldPanel((JTextField)((Object)new MyTextField()), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaBreakpointFiltersPanel.this.reloadInstanceFilters();
                EditInstanceFiltersDialog _dialog = new EditInstanceFiltersDialog(JavaBreakpointFiltersPanel.this.myProject);
                _dialog.setFilters(JavaBreakpointFiltersPanel.this.myInstanceFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    JavaBreakpointFiltersPanel.access$102(JavaBreakpointFiltersPanel.this, _dialog.getFilters());
                    JavaBreakpointFiltersPanel.this.updateInstanceFilterEditor(true);
                }
            }
        }, null);
        ActionListener updateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaBreakpointFiltersPanel.this.updateCheckboxes();
            }
        };
        this.myPassCountCheckbox.addActionListener(updateListener);
        this.myInstanceFiltersCheckBox.addActionListener(updateListener);
        this.myClassFiltersCheckBox.addActionListener(updateListener);
        this.myCatchCheckBox.addActionListener(updateListener);
        this.myCallerFiltersCheckBox.addActionListener(updateListener);
        ToolTipManager.sharedInstance().registerComponent(this.myInstanceFiltersField.getTextField());
        JavaBreakpointFiltersPanel.insert(this.myInstanceFiltersFieldPanel, (JComponent)this.myInstanceFiltersField);
        this.myCatchClassFilters.setBorder((Border)JBUI.Borders.emptyLeft((int)this.myCatchCheckBox.getInsets().left));
        this.myInstanceFiltersField.setBorder((Border)JBUI.Borders.emptyLeft((int)this.myInstanceFiltersCheckBox.getInsets().left));
        this.myClassFiltersField.setBorder((Border)JBUI.Borders.emptyLeft((int)this.myClassFiltersCheckBox.getInsets().left));
        this.myPassCountFieldPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)this.myPassCountCheckbox.getInsets().left));
        this.myCallerFilters.setBorder((Border)JBUI.Borders.emptyLeft((int)this.myCallerFiltersCheckBox.getInsets().left));
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myPassCountCheckbox, (JComponent)this.myPassCountField);
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myInstanceFiltersCheckBox, (JComponent)this.myInstanceFiltersField.getTextField());
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myClassFiltersCheckBox, (JComponent)this.myClassFiltersField.getTextField());
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myCatchCheckBox, (JComponent)this.myCatchClassFilters.getTextField());
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myCallerFiltersCheckBox, (JComponent)((Object)this.myCallerFilters));
    }

    @NotNull
    public JComponent getComponent() {
        return this.myConditionsPanel;
    }

    public boolean isVisibleOnPopup(@NotNull B breakpoint) {
        JavaBreakpointProperties properties = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties != null) {
            return properties.isCOUNT_FILTER_ENABLED() || properties.isCLASS_FILTERS_ENABLED() || properties.isINSTANCE_FILTERS_ENABLED() || properties.isCALLER_FILTERS_ENABLED() || properties instanceof JavaExceptionBreakpointProperties && ((JavaExceptionBreakpointProperties)properties).isCatchFiltersEnabled();
        }
        return false;
    }

    public void saveTo(@NotNull B breakpoint) {
        JavaBreakpointProperties properties = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties == null) {
            return;
        }
        boolean changed = false;
        try {
            int filter;
            String text2 = this.myPassCountField.getText().trim();
            int n = filter = !text2.isEmpty() ? Integer.parseInt(text2) : 0;
            if (filter < 0) {
                filter = 0;
            }
            changed = properties.setCOUNT_FILTER(filter);
        }
        catch (Exception text2) {
            // empty catch block
        }
        changed = properties.setCOUNT_FILTER_ENABLED(properties.getCOUNT_FILTER() > 0 && this.myPassCountCheckbox.isSelected()) || changed;
        this.reloadInstanceFilters();
        this.updateInstanceFilterEditor(true);
        if (properties instanceof JavaExceptionBreakpointProperties) {
            JavaExceptionBreakpointProperties exceptionBreakpointProperties = (JavaExceptionBreakpointProperties)properties;
            changed = exceptionBreakpointProperties.setCatchFiltersEnabled(!this.myCatchClassFilters.getText().isEmpty() && this.myCatchCheckBox.isSelected()) || changed;
            changed = exceptionBreakpointProperties.setCatchClassFilters(this.myCatchClassFilters.getClassFilters()) || changed;
            changed = exceptionBreakpointProperties.setCatchClassExclusionFilters(this.myCatchClassFilters.getClassExclusionFilters()) || changed;
        }
        changed = properties.setCLASS_FILTERS_ENABLED(!this.myClassFiltersField.getText().isEmpty() && this.myClassFiltersCheckBox.isSelected()) || changed;
        changed = properties.setClassFilters(this.myClassFiltersField.getClassFilters()) || changed;
        changed = properties.setClassExclusionFilters(this.myClassFiltersField.getClassExclusionFilters()) || changed;
        changed = properties.setINSTANCE_FILTERS_ENABLED(!this.myInstanceFiltersField.getText().isEmpty() && this.myInstanceFiltersCheckBox.isSelected()) || changed;
        changed = properties.setInstanceFilters(this.myInstanceFilters) || changed;
        changed = properties.setCALLER_FILTERS_ENABLED(!this.myCallerFilters.getText().isEmpty() && this.myCallerFiltersCheckBox.isSelected()) || changed;
        changed = properties.setCallerFilters(this.myCallerFilters.getClassFilters()) || changed;
        boolean bl = changed = properties.setCallerExclusionFilters(this.myCallerFilters.getClassExclusionFilters()) || changed;
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    private static void insert(JPanel panel2, JComponent component) {
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)component, "Center");
    }

    public void loadFrom(@NotNull B breakpoint) {
        this.myCatchFiltersPanel.setVisible(false);
        this.myCallerFiltersPanel.setVisible(false);
        JavaBreakpointProperties properties = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties != null) {
            if (properties.getCOUNT_FILTER() > 0) {
                this.myPassCountField.setText(Integer.toString(properties.getCOUNT_FILTER()));
            } else {
                this.myPassCountField.setText("");
            }
            this.myPassCountCheckbox.setSelected(properties.isCOUNT_FILTER_ENABLED());
            this.myInstanceFiltersCheckBox.setSelected(properties.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFilters = properties.getInstanceFilters();
            this.updateInstanceFilterEditor(true);
            this.myClassFiltersCheckBox.setSelected(properties.isCLASS_FILTERS_ENABLED());
            this.myClassFiltersField.setClassFilters(properties.getClassFilters(), properties.getClassExclusionFilters());
            if (properties instanceof JavaExceptionBreakpointProperties) {
                this.myCatchFiltersPanel.setVisible(true);
                JavaExceptionBreakpointProperties exceptionBreakpointProperties = (JavaExceptionBreakpointProperties)properties;
                this.myCatchCheckBox.setSelected(exceptionBreakpointProperties.isCatchFiltersEnabled());
                this.myCatchClassFilters.setClassFilters(exceptionBreakpointProperties.getCatchClassFilters(), exceptionBreakpointProperties.getCatchClassExclusionFilters());
            }
            if (Registry.is((String)"debugger.breakpoints.caller.filter")) {
                this.myCallerFiltersPanel.setVisible(true);
                this.myCallerFiltersCheckBox.setSelected(properties.isCALLER_FILTERS_ENABLED());
                this.myCallerFilters.setClassFilters(properties.getCallerFilters(), properties.getCallerExclusionFilters());
            }
            XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        }
        this.updateCheckboxes();
    }

    private void updateInstanceFilterEditor(boolean updateText) {
        List filters = ((StreamEx)StreamEx.of((Object[])this.myInstanceFilters).filter(InstanceFilter::isEnabled)).map(f -> Long.toString(f.getId())).toList();
        if (updateText) {
            this.myInstanceFiltersField.setText(StringUtil.join((Collection)filters, (String)" "));
        }
        String tipText = JavaBreakpointFiltersPanel.concatWithEx(filters, " ", (int)Math.sqrt(this.myInstanceFilters.length) + 1, "\n");
        this.myInstanceFiltersField.getTextField().setToolTipText(tipText);
    }

    private void createUIComponents() {
        this.myClassFiltersField = new ClassFiltersField(this.myProject, (Disposable)this);
        this.myCatchClassFilters = new ClassFiltersField(this.myProject, (Disposable)this);
        this.myCallerFilters = new CallerFiltersField(this.myProject, (Disposable)this);
    }

    private void reloadInstanceFilters() {
        String filtersText = this.myInstanceFiltersField.getText();
        ArrayList<InstanceFilter> idxs = new ArrayList<InstanceFilter>();
        int startNumber = -1;
        for (int i = 0; i <= filtersText.length(); ++i) {
            if (i < filtersText.length() && Character.isDigit(filtersText.charAt(i))) {
                if (startNumber != -1) continue;
                startNumber = i;
                continue;
            }
            if (startNumber < 0) continue;
            idxs.add(InstanceFilter.create(filtersText.substring(startNumber, i)));
            startNumber = -1;
        }
        this.myInstanceFilters = (InstanceFilter[])((StreamEx)StreamEx.of((Object[])this.myInstanceFilters).remove(InstanceFilter::isEnabled)).prepend(idxs).toArray(InstanceFilter[]::new);
    }

    private static String concatWithEx(List<String> s, String concator, int N, String NthConcator) {
        StringBuilder result = new StringBuilder();
        int i = 1;
        Iterator<String> iterator = s.iterator();
        while (iterator.hasNext()) {
            String str = iterator.next();
            result.append(str);
            if (iterator.hasNext()) {
                if (i % N == 0) {
                    result.append(NthConcator);
                } else {
                    result.append(concator);
                }
            }
            ++i;
        }
        return result.toString();
    }

    protected ClassFilter createClassConditionFilter() {
        ClassFilter classFilter = this.myBreakpointPsiClass != null ? new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return JavaBreakpointFiltersPanel.this.myBreakpointPsiClass == aClass || aClass.isInheritor(JavaBreakpointFiltersPanel.this.myBreakpointPsiClass, true);
            }
        } : null;
        return classFilter;
    }

    protected void updateCheckboxes() {
        boolean passCountApplicable = true;
        if (this.myInstanceFiltersCheckBox.isSelected() || this.myClassFiltersCheckBox.isSelected()) {
            passCountApplicable = false;
        }
        this.myPassCountCheckbox.setEnabled(passCountApplicable);
        boolean passCountSelected = this.myPassCountCheckbox.isSelected();
        this.myInstanceFiltersCheckBox.setEnabled(!passCountSelected);
        this.myClassFiltersCheckBox.setEnabled(!passCountSelected);
        this.myPassCountField.setEditable(this.myPassCountCheckbox.isSelected());
        this.myPassCountField.setEnabled(this.myPassCountCheckbox.isSelected());
        this.myInstanceFiltersField.setEnabled(this.myInstanceFiltersCheckBox.isSelected());
        this.myInstanceFiltersField.getTextField().setEditable(this.myInstanceFiltersCheckBox.isSelected());
        this.myClassFiltersField.setEnabled(this.myClassFiltersCheckBox.isSelected());
        this.myClassFiltersField.setEditable(this.myClassFiltersCheckBox.isSelected());
        this.myCatchClassFilters.setEnabled(this.myCatchCheckBox.isSelected());
        this.myCatchClassFilters.setEditable(this.myCatchCheckBox.isSelected());
        this.myCallerFilters.setEnabled(this.myCallerFiltersCheckBox.isSelected());
        this.myCallerFilters.setEditable(this.myCallerFiltersCheckBox.isSelected());
    }

    static /* synthetic */ InstanceFilter[] access$102(JavaBreakpointFiltersPanel x0, InstanceFilter[] x1) {
        x0.myInstanceFilters = x1;
        return x1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JTextField jTextField;
        JPanel jPanel3;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel4;
        JCheckBox jCheckBox5;
        JPanel jPanel5;
        this.createUIComponents();
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConditionsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(2, 0, 5, 0), -1, 7, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myInstanceFiltersCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/JavaDebuggerBundle", JavaBreakpointFiltersPanel.class).getString("breakpoint.properties.panel.option.instance.filters"));
        jPanel7.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myInstanceFiltersFieldPanel = jPanel4 = new JPanel();
        jPanel8.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel5.add((Component)jPanel9, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/JavaDebuggerBundle", JavaBreakpointFiltersPanel.class).getString("breakpoint.properties.panel.option.class.filters"));
        jPanel9.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ClassFiltersField classFiltersField = this.myClassFiltersField;
        jPanel10.add((Component)((Object)classFiltersField), new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel5.add((Component)jPanel11, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        this.myPassCountCheckbox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/JavaDebuggerBundle", JavaBreakpointFiltersPanel.class).getString("breakpoint.properties.panel.option.pass.count"));
        jPanel11.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPassCountFieldPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPassCountField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jTextField.setHorizontalAlignment(10);
        jPanel3.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(15, -1), null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCatchFiltersPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myCatchCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/JavaDebuggerBundle", JavaBreakpointFiltersPanel.class).getString("breakpoint.properties.panel.option.catch.class.filters"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ClassFiltersField classFiltersField2 = this.myCatchClassFilters;
        jPanel12.add((Component)((Object)classFiltersField2), new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCallerFiltersPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        this.myCallerFiltersCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaDebuggerBundle", JavaBreakpointFiltersPanel.class).getString("breakpoint.properties.panel.option.caller.filter"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel13, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        CallerFiltersField callerFiltersField = this.myCallerFilters;
        jPanel13.add((Component)((Object)callerFiltersField), new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyTextField
    extends ExtendableTextField {
        MyTextField() {
        }

        public String getToolTipText(MouseEvent event) {
            JavaBreakpointFiltersPanel.this.reloadInstanceFilters();
            JavaBreakpointFiltersPanel.this.updateInstanceFilterEditor(false);
            String toolTipText = super.getToolTipText(event);
            return this.getToolTipText().length() == 0 ? null : toolTipText;
        }

        public JToolTip createToolTip() {
            JToolTip toolTip = new JToolTip(){
                {
                    this.setUI((ComponentUI)new MultiLineTooltipUI());
                }
            };
            toolTip.setComponent((JComponent)((Object)this));
            return toolTip;
        }
    }
}

