/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.varargs;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

class VarargArgumentsPredicate
implements PsiElementPredicate {
    VarargArgumentsPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        PsiCapturedWildcardType capturedWildcardType;
        PsiType lastParameterType;
        if (!(element instanceof PsiExpressionList)) {
            return false;
        }
        PsiExpressionList argumentList = (PsiExpressionList)element;
        PsiElement parent = argumentList.getParent();
        if (!(parent instanceof PsiCall)) {
            return false;
        }
        PsiCall call = (PsiCall)parent;
        JavaResolveResult resolveResult = call.resolveMethodGenerics();
        if (!resolveResult.isValidResult() || !(resolveResult instanceof MethodCandidateInfo) || ((MethodCandidateInfo)resolveResult).getApplicabilityLevel() != 2) {
            return false;
        }
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null || !method.isVarArgs()) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiType substitutedType = substitutor.substitute(lastParameterType = PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)(parameters2.length - 1), (boolean)true));
        if (substitutedType instanceof PsiCapturedWildcardType && !(capturedWildcardType = (PsiCapturedWildcardType)substitutedType).getWildcard().isSuper()) {
            return false;
        }
        if (arguments.length != parameters2.length) {
            return true;
        }
        PsiExpression lastExpression = arguments[arguments.length - 1];
        if (ExpressionUtils.isNullLiteral(lastExpression)) {
            return false;
        }
        PsiType lastArgumentType = lastExpression.getType();
        if (!(lastArgumentType instanceof PsiArrayType)) {
            return true;
        }
        PsiArrayType arrayType = (PsiArrayType)lastArgumentType;
        PsiType type2 = arrayType.getComponentType();
        return !substitutedType.isAssignableFrom(type2);
    }
}

