/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.switchbranches;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.magicConstant.MagicConstantUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.CreateSwitchBranchesUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMissingSwitchBranchesAction
extends PsiElementBaseIntentionAction {
    private static final int MAX_NUMBER_OF_BRANCHES = 100;
    private List<Value> myAllValues;

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiSwitchBlock block = (PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiSwitchBlock.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiStatement.class});
        if (block == null) {
            return;
        }
        if (block instanceof PsiSwitchExpression && !HighlightingFeature.SWITCH_EXPRESSION.isAvailable((PsiElement)block)) {
            return;
        }
        List<Value> allValues = this.myAllValues;
        List<Value> missingValues = CreateMissingSwitchBranchesAction.getMissingValues(block, allValues);
        if (missingValues.isEmpty()) {
            return;
        }
        List allValueNames = ContainerUtil.map(allValues, v -> v.myName);
        List missingValueNames = ContainerUtil.map(missingValues, v -> v.myName);
        List<PsiSwitchLabelStatementBase> addedLabels = CreateSwitchBranchesUtil.createMissingBranches(block, allValueNames, missingValueNames, label -> CreateMissingSwitchBranchesAction.extractConstantNames(allValues, label));
        CreateSwitchBranchesUtil.createTemplate(block, addedLabels);
    }

    private static List<String> extractConstantNames(List<Value> allValues, PsiSwitchLabelStatementBase label) {
        Set<Object> constants = CreateMissingSwitchBranchesAction.getLabelConstants(label);
        return ((StreamEx)StreamEx.of(allValues).filter(v -> constants.contains(v.myValue))).map(v -> v.myName).toList();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        List<Value> missingValues;
        PsiSwitchBlock block = (PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiSwitchBlock.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiStatement.class});
        if (block == null) {
            return false;
        }
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)block.getExpression());
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        if (type2 == null) {
            return false;
        }
        boolean isString = TypeUtils.isJavaLangString(type2);
        if (type2 instanceof PsiClassType && !isString) {
            return false;
        }
        List<Value> values = CreateMissingSwitchBranchesAction.getPossibleValues(expression2);
        if (!values.isEmpty() && !(missingValues = CreateMissingSwitchBranchesAction.getMissingValues(block, values)).isEmpty()) {
            this.myAllValues = values;
            this.setText(CreateSwitchBranchesUtil.getActionName(ContainerUtil.map(missingValues, v -> v.myPresentationName)));
            return true;
        }
        return false;
    }

    @NotNull
    private static List<Value> getPossibleValues(PsiExpression expression2) {
        PsiModifierListOwner target;
        Set<Object> values;
        CommonDataflow.DataflowResult dfr = CommonDataflow.getDataflowResult(expression2);
        PsiType type2 = expression2.getType();
        if (dfr != null) {
            LongRangeSet range = DfIntType.extractRange(dfr.getDfType(expression2));
            if (type2 != null && PsiType.INT.isAssignableFrom(type2) && !range.isCardinalityBigger(100L)) {
                return range.stream().mapToObj(c -> Value.fromConstant(TypeConversionUtil.computeCastTo((Object)c, (PsiType)type2))).collect(Collectors.toList());
            }
            values = dfr.getExpressionValues(expression2);
            if (!values.isEmpty() && values.size() <= 100 && values.stream().allMatch(v -> v instanceof String)) {
                return values.stream().map(Value::fromConstant).sorted(Comparator.comparing(v -> (String)v.myValue)).collect(Collectors.toList());
            }
        }
        if (expression2 instanceof PsiReferenceExpression && (target = (PsiModifierListOwner)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression2).resolve(), PsiModifierListOwner.class)) != null && (values = MagicConstantUtils.getAllowedValues(target, type2)) != null && !((MagicConstantUtils.AllowedValues)((Object)values)).isFlagSet() && ((MagicConstantUtils.AllowedValues)((Object)values)).getValues().length <= 100) {
            ArrayList<Value> result = new ArrayList<Value>();
            for (PsiAnnotationMemberValue value2 : ((MagicConstantUtils.AllowedValues)((Object)values)).getValues()) {
                PsiField field;
                Value val = null;
                if (value2 instanceof PsiReferenceExpression && (field = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)value2).resolve(), PsiField.class)) != null) {
                    val = Value.fromField(field);
                }
                if (val == null) {
                    return Collections.emptyList();
                }
                result.add(val);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<Value> getMissingValues(PsiSwitchBlock block, List<Value> allValues) {
        ArrayList<Value> missingValues = new ArrayList<Value>(allValues);
        PsiCodeBlock body2 = block.getBody();
        if (body2 != null) {
            Collection labels2 = PsiTreeUtil.findChildrenOfType((PsiElement)body2, PsiSwitchLabelStatementBase.class);
            Set existingBranches = (Set)StreamEx.of((Collection)labels2).toFlatCollection(CreateMissingSwitchBranchesAction::getLabelConstants, HashSet::new);
            missingValues.removeIf(v -> existingBranches.contains(v.myValue));
        }
        return missingValues;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return IntentionPowerPackBundle.message("create.missing.switch.branches.family.name", new Object[0]);
    }

    @NotNull
    private static Set<Object> getLabelConstants(@NotNull PsiSwitchLabelStatementBase label) {
        PsiExpressionList list = label.getCaseValues();
        if (list == null) {
            return Collections.emptySet();
        }
        HashSet<Object> constants = new HashSet<Object>();
        for (PsiExpression value2 : list.getExpressions()) {
            Object constant = ExpressionUtils.computeConstantExpression(value2);
            if (constant instanceof Byte || constant instanceof Short) {
                constants.add(((Number)constant).intValue());
                continue;
            }
            if (constant instanceof String || constant instanceof Integer) {
                constants.add(constant);
                continue;
            }
            if (constant instanceof Character) {
                constants.add(((Character)constant).charValue());
                continue;
            }
            return Collections.emptySet();
        }
        return constants;
    }

    private static class Value {
        @NotNull
        final String myName;
        @NotNull
        final String myPresentationName;
        @NotNull
        final Object myValue;

        Value(@NotNull String name2, @NotNull String presentationName, @NotNull Object value2) {
            this.myName = name2;
            this.myPresentationName = presentationName;
            this.myValue = value2;
        }

        @NotNull
        static Value fromConstant(Object value2) {
            String presentation;
            Object normalized = value2;
            if (value2 instanceof Byte || value2 instanceof Short) {
                normalized = ((Number)value2).intValue();
            } else if (value2 instanceof Character) {
                normalized = (int)((Character)value2).charValue();
            }
            if ((normalized instanceof Integer || normalized instanceof String) && (presentation = Value.getPresentation(value2)) != null) {
                return new Value(presentation, presentation, normalized);
            }
            throw new IllegalArgumentException("Unexpected constant supplied: " + value2);
        }

        @Nullable
        static Value fromField(@NotNull PsiField field) {
            String name2 = field.getName();
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            String className2 = aClass.getQualifiedName();
            if (className2 == null) {
                return null;
            }
            Object value2 = field.computeConstantValue();
            if (value2 == null) {
                return null;
            }
            return new Value(className2 + "." + field.getName(), name2, value2);
        }

        @Nullable
        static String getPresentation(Object constant) {
            if (constant instanceof Integer || constant instanceof Byte || constant instanceof Short) {
                return constant.toString();
            }
            if (constant instanceof String) {
                return '\"' + StringUtil.escapeStringCharacters((String)((String)constant)) + '\"';
            }
            if (constant instanceof Character) {
                return "'" + StringUtil.escapeCharCharacters((String)constant.toString()) + "'";
            }
            return null;
        }
    }
}

