/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.modifiers;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.AccessModifier;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.JavaThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.suggested.SuggestedRefactoringProvider;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.IntentionPowerPackBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeModifierIntention
extends BaseElementAtCaretIntentionAction {
    private final boolean myErrorFix;
    private AccessModifier myTarget;

    public ChangeModifierIntention() {
        this(false);
    }

    public ChangeModifierIntention(boolean errorFix) {
        this.myErrorFix = errorFix;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (!JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            return false;
        }
        PsiMember member = ChangeModifierIntention.findMember(element);
        if (!(member instanceof PsiNameIdentifierOwner)) {
            return false;
        }
        PsiElement identifier = ((PsiNameIdentifierOwner)member).getNameIdentifier();
        if (identifier == null || identifier.getTextRange().getEndOffset() <= element.getTextRange().getStartOffset()) {
            return false;
        }
        ArrayList<AccessModifier> modifiers = new ArrayList<AccessModifier>(AccessModifier.getAvailableModifiers(member));
        if (modifiers.isEmpty()) {
            return false;
        }
        if (!this.myErrorFix && modifiers.stream().noneMatch(mod -> mod.hasModifier((PsiModifierListOwner)member))) {
            return false;
        }
        modifiers.removeIf(mod -> mod.hasModifier((PsiModifierListOwner)member));
        AccessModifier target = null;
        if (modifiers.isEmpty()) {
            return false;
        }
        if (modifiers.size() == 1) {
            target = (AccessModifier)((Object)modifiers.get(0));
            this.setText(IntentionPowerPackBundle.message("change.modifier.text", new Object[]{identifier.getText(), target}));
        } else {
            this.setText(this.getFamilyName());
        }
        this.myTarget = target;
        return true;
    }

    private static PsiMember findMember(@NotNull PsiElement element) {
        PsiMember member;
        while ((member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiStatement.class, PsiExpression.class})) instanceof PsiTypeParameter) {
            element = member.getParent();
        }
        return member;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return currentFile;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(final @NotNull Project project, final Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        StartMarkAction markAction;
        PsiMember member = ChangeModifierIntention.findMember(element);
        if (member == null) {
            return;
        }
        PsiFile file = member.getContainingFile();
        if (file == null) {
            return;
        }
        List<AccessModifier> modifiers = AccessModifier.getAvailableModifiers(member);
        if (modifiers.isEmpty()) {
            return;
        }
        AccessModifier target = this.myTarget;
        if (modifiers.contains((Object)target)) {
            ChangeModifierIntention.setModifier(member, target);
            return;
        }
        TextRange range = ChangeModifierIntention.getRange(member);
        Document document = editor.getDocument();
        CharSequence sequence = document.getCharsSequence();
        if (range.getLength() == 0) {
            int pos;
            for (pos = range.getStartOffset(); pos < sequence.length() && StringUtil.isWhiteSpace((char)sequence.charAt(pos)); ++pos) {
            }
            range = TextRange.from((int)pos, (int)0);
        }
        final CaretModel model = editor.getCaretModel();
        final RangeMarker cursorMarker = document.createRangeMarker(model.getOffset(), model.getOffset());
        model.moveToOffset(range.getStartOffset());
        try {
            markAction = StartMarkAction.start((Editor)editor, (Project)project, (String)this.getFamilyName());
        }
        catch (StartMarkAction.AlreadyStartedException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)StringUtil.toTitleCase((String)this.getFamilyName()));
            return;
        }
        final RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(EditorColors.LIVE_TEMPLATE_ATTRIBUTES, range.getStartOffset(), range.getEndOffset(), 6001, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setGreedyToRight(true);
        highlighter.setGreedyToLeft(true);
        final ModifierUpdater updater = new ModifierUpdater(file, document, range, this.getFamilyName());
        AccessModifier current = (AccessModifier)((Object)ContainerUtil.find(modifiers, m -> m.hasModifier((PsiModifierListOwner)member)));
        SmartPsiElementPointer memberPointer = SmartPointerManager.createPointer((PsiElement)member);
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(modifiers).setSelectionMode(0).setSelectedValue((Object)current, true).setAccessibleName("Change Modifier").setMovable(false).setResizable(false).setRequestFocus(true).setFont(editor.getColorsScheme().getFont(EditorFontType.PLAIN)).setItemSelectedCallback(updater::setModifier).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                highlighter.dispose();
                model.moveToOffset(cursorMarker.getStartOffset());
                FinishMarkAction.finish((Project)project, (Editor)editor, (StartMarkAction)markAction);
                if (!event.isOk()) {
                    updater.undoChange();
                }
            }
        }).setNamerForFiltering(AccessModifier::toString).setItemChosenCallback(t -> {
            MultiMap<PsiElement, String> conflicts;
            PsiModifierList modifierList;
            if (editor instanceof EditorImpl) {
                ((EditorImpl)editor).startDumb();
            }
            try {
                updater.undoChange();
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                if (t == current) {
                    return;
                }
                PsiMember m = (PsiMember)memberPointer.getElement();
                if (m == null) {
                    return;
                }
                modifierList = m.getModifierList();
                if (modifierList == null) {
                    return;
                }
                conflicts = ChangeModifierIntention.checkForConflicts(m, t);
            }
            finally {
                if (editor instanceof EditorImpl) {
                    ((EditorImpl)editor).stopDumbLater();
                }
            }
            if (conflicts == null) {
                return;
            }
            if (!conflicts.isEmpty()) {
                ChangeModifierIntention.processWithConflicts(modifierList, t, conflicts);
            } else {
                ChangeModifierIntention.changeModifier(modifierList, t, false);
            }
        }).createPopup();
        popup.showInBestPositionFor(editor);
    }

    private static TextRange getRange(PsiMember member) {
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null) {
            return TextRange.from((int)member.getTextRange().getStartOffset(), (int)0);
        }
        PsiKeyword anchor = ChangeModifierIntention.getAnchorKeyword(modifierList);
        if (anchor != null) {
            return anchor.getTextRange();
        }
        anchor = PsiTreeUtil.getChildOfType((PsiElement)modifierList, PsiKeyword.class);
        if (anchor != null) {
            return TextRange.from((int)anchor.getTextRange().getStartOffset(), (int)0);
        }
        return TextRange.from((int)modifierList.getTextRange().getEndOffset(), (int)0);
    }

    @Nullable
    private static PsiKeyword getAnchorKeyword(PsiModifierList modifierList) {
        for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!AccessModifier.ALL_MODIFIERS.contains((Object)AccessModifier.fromKeyword((PsiKeyword)ObjectUtils.tryCast((Object)child, PsiKeyword.class)))) continue;
            return (PsiKeyword)child;
        }
        return null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return IntentionPowerPackBundle.message("change.modifier.intention.name", new Object[0]);
    }

    private static void setModifier(PsiMember member, AccessModifier modifier) {
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null) {
            return;
        }
        MultiMap<PsiElement, String> conflicts = ChangeModifierIntention.checkForConflicts(member, modifier);
        if (conflicts == null) {
            return;
        }
        ChangeModifierIntention.processWithConflicts(modifierList, modifier, conflicts);
    }

    private static void processWithConflicts(@NotNull PsiModifierList modifierList, @NotNull AccessModifier modifier, @NotNull MultiMap<PsiElement, String> conflicts) {
        boolean shouldProcess;
        if (conflicts.isEmpty()) {
            shouldProcess = true;
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            shouldProcess = true;
        } else {
            ConflictsDialog dialog = new ConflictsDialog(modifierList.getProject(), conflicts, () -> ChangeModifierIntention.changeModifier(modifierList, modifier, true));
            shouldProcess = dialog.showAndGet();
        }
        if (shouldProcess) {
            ChangeModifierIntention.changeModifier(modifierList, modifier, !conflicts.isEmpty());
        }
    }

    private static void changeModifier(PsiModifierList modifierList, AccessModifier modifier, boolean hasConflicts) {
        Project project = modifierList.getProject();
        PsiElement parent = modifierList.getParent();
        if (parent instanceof PsiMethod && hasConflicts) {
            PsiMethod method = (PsiMethod)parent;
            new ChangeSignatureProcessor(project, method, false, modifier.toPsiModifier(), method.getName(), method.getReturnType(), ParameterInfoImpl.fromMethod(method), JavaThrownExceptionInfo.extractExceptions(method)).run();
            return;
        }
        PsiFile file = modifierList.getContainingFile();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).withName(IntentionPowerPackBundle.message("change.modifier.intention.name", new Object[0])).run(() -> {
            VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)modifier.toPsiModifier());
            if (modifier != AccessModifier.PACKAGE_LOCAL) {
                PsiElement whitespace = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText(" ");
                PsiElement sibling = modifierList.getNextSibling();
                if (sibling instanceof PsiWhiteSpace) {
                    sibling.replace(whitespace);
                    CodeStyleManager.getInstance((Project)project).reformatRange(parent, modifierList.getTextOffset(), modifierList.getNextSibling().getTextOffset());
                }
            }
            SuggestedRefactoringProvider.getInstance((Project)project).reset();
        });
    }

    @Nullable
    private static MultiMap<PsiElement, String> checkForConflicts(@NotNull PsiMember member, AccessModifier modifier) {
        if (member instanceof PsiClass && modifier == AccessModifier.PUBLIC) {
            String className2;
            PsiClass aClass = (PsiClass)member;
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiJavaFile)) {
                return MultiMap.empty();
            }
            PsiJavaFile javaFile = (PsiJavaFile)parent;
            String name2 = FileUtilRt.getNameWithoutExtension((String)javaFile.getName());
            if (name2.equals(className2 = aClass.getName())) {
                return MultiMap.empty();
            }
            MultiMap conflicts = new MultiMap();
            conflicts.putValue((Object)aClass, (Object)IntentionPowerPackBundle.message("0.is.declared.in.1.but.when.public.should.be.declared.in.a.file.named.2", RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)javaFile, (boolean)false), CommonRefactoringUtil.htmlEmphasize((String)(className2 + ".java"))));
            return conflicts;
        }
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null || modifierList.hasModifierProperty("private")) {
            return MultiMap.empty();
        }
        PsiModifierList copy = (PsiModifierList)modifierList.copy();
        copy.setModifierProperty(modifier.toPsiModifier(), true);
        SearchScope useScope = member.getUseScope();
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
            if (member instanceof PsiMethod) {
                JavaChangeSignatureUsageProcessor.ConflictSearcher.searchForHierarchyConflicts((PsiMethod)member, (MultiMap<PsiElement, String>)conflicts, modifier.toPsiModifier());
            }
            Query search = ReferencesSearch.search((PsiElement)member, (SearchScope)useScope);
            search.forEach(reference -> {
                PsiElement element = reference.getElement();
                if (JavaResolveUtil.isAccessible(member, member.getContainingClass(), copy, element, null, null)) {
                    return true;
                }
                PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClass.class, PsiFile.class});
                if (context == null) {
                    return true;
                }
                conflicts.putValue((Object)element, (Object)RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), JavaPsiBundle.visibilityPresentation((String)modifier.toPsiModifier()), RefactoringUIUtil.getDescription((PsiElement)context, (boolean)true)}));
                return true;
            });
        }), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, member.getProject())) {
            return null;
        }
        return conflicts;
    }

    private static class ModifierUpdater {
        private final Document myDocument;
        private final boolean myExtendLeft;
        private final boolean myExtendRight;
        private final String myOriginalText;
        private final RangeMarker myMarker;
        private final String myActionName;
        private final PsiFile myFile;

        ModifierUpdater(@NotNull PsiFile file, @NotNull Document document, @NotNull TextRange range, @NotNull String actionName) {
            this.myDocument = document;
            this.myFile = file;
            this.myActionName = actionName;
            CharSequence sequence = document.getCharsSequence();
            this.myExtendLeft = range.getStartOffset() > 0 && !StringUtil.isWhiteSpace((char)sequence.charAt(range.getStartOffset() - 1));
            this.myExtendRight = range.getEndOffset() < sequence.length() && !StringUtil.isWhiteSpace((char)sequence.charAt(range.getEndOffset()));
            this.myOriginalText = sequence.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
            this.myMarker = document.createRangeMarker(range);
            this.myMarker.setGreedyToRight(true);
            this.myMarker.setGreedyToLeft(true);
        }

        void undoChange() {
            Project project = this.myFile.getProject();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            FileEditor fileEditor = fileEditorManager.getSelectedEditor(this.myFile.getVirtualFile());
            UndoManager manager = UndoManager.getInstance((Project)project);
            if (manager.isUndoAvailable(fileEditor)) {
                manager.undo(fileEditor);
            } else {
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{this.myFile}).withName(this.myActionName).run(() -> this.myDocument.replaceString(this.myMarker.getStartOffset(), this.myMarker.getEndOffset(), (CharSequence)this.myOriginalText));
            }
        }

        void setModifier(@Nullable AccessModifier target) {
            if (target == null) {
                return;
            }
            String updatedText = target == AccessModifier.PACKAGE_LOCAL ? " " : (this.myExtendLeft ? (this.myExtendRight ? " " + (Object)((Object)target) + " " : " " + (Object)((Object)target)) : (this.myExtendRight ? (Object)((Object)target) + " " : target.toString()));
            WriteCommandAction.writeCommandAction((Project)this.myFile.getProject(), (PsiFile[])new PsiFile[]{this.myFile}).withName(this.myActionName).run(() -> this.myDocument.replaceString(this.myMarker.getStartOffset(), this.myMarker.getEndOffset(), (CharSequence)updatedText));
        }
    }
}

