/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.AssertTrueOrFalsePredicate;
import org.jetbrains.annotations.NotNull;

public class FlipAssertLiteralIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String fromMethodName = methodExpression.getReferenceName();
        String toMethodName = FlipAssertLiteralIntention.getOppositeAssertMethodName(fromMethodName);
        return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{fromMethodName + "()", toMethodName + "()"});
    }

    @NotNull
    private static String getOppositeAssertMethodName(String fromMethodName) {
        return "assertTrue".equals(fromMethodName) ? "assertFalse" : "assertTrue";
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new AssertTrueOrFalsePredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String fromMethodName = methodExpression.getReferenceName();
        String toMethodName = FlipAssertLiteralIntention.getOppositeAssertMethodName(fromMethodName);
        CommentTracker tracker = new CommentTracker();
        StringBuilder newCall = new StringBuilder();
        PsiElement qualifier = methodExpression.getQualifier();
        if (qualifier == null) {
            PsiMethod method = call.resolveMethod();
            assert (method != null);
            PsiClass aClass = method.getContainingClass();
            assert (aClass != null);
            String qualifiedName = aClass.getQualifiedName();
            assert (qualifiedName != null);
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.Assert") && !ImportUtils.addStaticImport(qualifiedName, toMethodName, element)) {
                newCall.append(qualifiedName).append('.');
            }
        } else {
            newCall.append(tracker.text(qualifier)).append('.');
        }
        newCall.append(toMethodName).append('(');
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 1) {
            newCall.append(BoolUtils.getNegatedExpressionText(arguments[0], tracker));
        } else {
            newCall.append(tracker.text((PsiElement)arguments[0])).append(',');
            newCall.append(BoolUtils.getNegatedExpressionText(arguments[1], tracker));
        }
        newCall.append(')');
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, newCall.toString(), tracker);
    }
}

