/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReverseForLoopDirectionPredicate
implements PsiElementPredicate {
    ReverseForLoopDirectionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken keyword = (PsiJavaToken)element;
        IElementType tokenType = keyword.getTokenType();
        if (!JavaTokenType.FOR_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = keyword.getParent();
        if (!(parent instanceof PsiForStatement)) {
            return false;
        }
        PsiForStatement forStatement = (PsiForStatement)parent;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiLocalVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        PsiType type2 = variable.getType();
        if (!PsiType.INT.equals((Object)type2) && !PsiType.LONG.equals((Object)type2)) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (!ReverseForLoopDirectionPredicate.isVariableCompared(variable, condition2)) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        return ReverseForLoopDirectionPredicate.isVariableIncrementOrDecremented(variable, update2);
    }

    public static boolean isVariableCompared(@NotNull PsiVariable variable, @Nullable PsiExpression expression2) {
        if (!(expression2 instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!ComparisonUtils.isComparisonOperation(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        if (ExpressionUtils.isReferenceTo(lhs, variable)) {
            return true;
        }
        return ExpressionUtils.isReferenceTo(rhs, variable);
    }

    public static boolean isVariableIncrementOrDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression2 = expressionStatement.getExpression();
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand2 = prefixExpression.getOperand();
            return ExpressionUtils.isReferenceTo(operand2, variable);
        }
        if (expression2 instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression2;
            IElementType tokenType = postfixExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand3 = postfixExpression.getOperand();
            return ExpressionUtils.isReferenceTo(operand3, variable);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!ExpressionUtils.isReferenceTo(lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)lhs), variable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)rhs);
            if (tokenType == JavaTokenType.EQ) {
                if (!(rhs instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
                IElementType token = binaryExpression.getOperationTokenType();
                if (!token.equals(JavaTokenType.PLUS) && !token.equals(JavaTokenType.MINUS)) {
                    return false;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                lOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)lOperand);
                PsiExpression rOperand = binaryExpression.getROperand();
                return ExpressionUtils.isReferenceTo(rOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)rOperand), variable) || ExpressionUtils.isReferenceTo(lOperand, variable);
            }
            if (tokenType == JavaTokenType.PLUSEQ || tokenType == JavaTokenType.MINUSEQ) {
                return true;
            }
        }
        return false;
    }
}

