/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression.eliminate;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ipp.expression.eliminate.EliminableExpression;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EliminateUtils {
    private static final IElementType[] PREFIXES = new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS};
    private static final Map<IElementType, String> OPS = new HashMap<IElementType, String>();
    private static final Map<IElementType, IElementType> INVERTED_OPS = new HashMap<IElementType, IElementType>();

    EliminateUtils() {
    }

    static <T extends EliminableExpression> T createExpression(@NotNull PsiParenthesizedExpression parenthesized, @NotNull BiFunction<? super PsiPolyadicExpression, ? super PsiExpression, T> ctor, @NotNull Map<IElementType, IElementType[]> outerOperators) {
        PsiPolyadicExpression innerExpr = EliminateUtils.getInnerExpression(parenthesized, outerOperators.keySet());
        if (innerExpr == null) {
            return null;
        }
        PsiExpression operand2 = EliminateUtils.skipPrefixedExprUp((PsiExpression)parenthesized);
        if (operand2 == null) {
            return null;
        }
        PsiPolyadicExpression outerExpr = EliminateUtils.getOuterExpression(innerExpr, operand2, outerOperators);
        if (outerExpr == null && !(operand2 instanceof PsiPrefixExpression)) {
            return null;
        }
        if (SideEffectChecker.mayHaveSideEffects((PsiExpression)(outerExpr == null ? operand2 : outerExpr))) {
            return null;
        }
        return (T)((EliminableExpression)ctor.apply((PsiPolyadicExpression)outerExpr, (PsiExpression)operand2));
    }

    @Nullable
    private static PsiPolyadicExpression getInnerExpression(@NotNull PsiParenthesizedExpression parenthesized, @NotNull Set<IElementType> innerOperators) {
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)parenthesized), PsiPolyadicExpression.class);
        if (expression2 == null) {
            return null;
        }
        if (!innerOperators.contains(expression2.getOperationTokenType()) || expression2.getOperands().length < 2) {
            return null;
        }
        return expression2;
    }

    @Nullable
    private static PsiPolyadicExpression getOuterExpression(@NotNull PsiPolyadicExpression innerExpression, @NotNull PsiExpression operand2, @NotNull Map<IElementType, IElementType[]> outerOperators) {
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)operand2.getParent(), PsiPolyadicExpression.class);
        if (expression2 == null) {
            return null;
        }
        IElementType innerOperator = innerExpression.getOperationTokenType();
        Object[] operators = outerOperators.get(innerOperator);
        if (operators == null) {
            return null;
        }
        IElementType outerOperator = expression2.getOperationTokenType();
        if (!ArrayUtil.contains((Object)outerOperator, (Object[])operators) || expression2.getOperands().length < 2) {
            return null;
        }
        if (EliminateUtils.isSamePrecedence(innerOperator, outerOperator) && expression2.getTokenBeforeOperand(operand2) == null) {
            return null;
        }
        return expression2;
    }

    private static boolean isSamePrecedence(@NotNull IElementType innerOperator, @NotNull IElementType outerOperator) {
        return PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)outerOperator) == PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)innerOperator);
    }

    @Nullable
    private static PsiExpression skipPrefixedExprUp(@NotNull PsiExpression expression2) {
        while (expression2.getParent() instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2.getParent();
            if (!ArrayUtil.contains((Object)prefixExpression.getOperationTokenType(), (Object[])PREFIXES)) {
                return null;
            }
            expression2 = prefixExpression;
        }
        return expression2;
    }

    static <T> T processPrefixed(@NotNull PsiExpression expression2, boolean isNegated, @NotNull BiFunction<? super PsiExpression, ? super Boolean, T> handler) {
        PsiPrefixExpression prefixExpr;
        IElementType tokenType;
        while (expression2 instanceof PsiPrefixExpression && ArrayUtil.contains((Object)(tokenType = (prefixExpr = (PsiPrefixExpression)expression2).getOperationTokenType()), (Object[])PREFIXES)) {
            isNegated ^= JavaTokenType.MINUS.equals(tokenType);
            expression2 = prefixExpr.getOperand();
        }
        return handler.apply((PsiExpression)expression2, isNegated);
    }

    @Nullable
    private static IElementType invert(@NotNull IElementType tokenType) {
        return INVERTED_OPS.get(tokenType);
    }

    @Contract(value="null -> null")
    static String getOperator(@Nullable IElementType type2) {
        return type2 == null ? null : OPS.get(type2);
    }

    static boolean isAdditive(@Nullable IElementType type2) {
        return JavaTokenType.PLUS.equals(type2) || JavaTokenType.MINUS.equals(type2);
    }

    static boolean isMultiplicative(IElementType type2) {
        return JavaTokenType.ASTERISK.equals(type2) || JavaTokenType.DIV.equals(type2) || JavaTokenType.PERC.equals(type2) || JavaTokenType.ANDAND.equals(type2) || JavaTokenType.AND.equals(type2);
    }

    private static boolean isInversion(IElementType type2) {
        return JavaTokenType.MINUS.equals(type2) || JavaTokenType.DIV.equals(type2);
    }

    private static boolean isPolyadicNegated(@NotNull PsiPolyadicExpression expression2, boolean isNegated, PsiExpression ... toEliminate) {
        if (!EliminateUtils.isMultiplicative(expression2.getOperationTokenType())) {
            return false;
        }
        return (Boolean)StreamEx.of((Object[])expression2.getOperands()).foldLeft((Object)isNegated, (result, op) -> EliminateUtils.isNegated(op, result, toEliminate));
    }

    static boolean isNegated(@NotNull PsiExpression operand2, boolean isNegated, PsiExpression ... toEliminate) {
        if (operand2 instanceof PsiPolyadicExpression) {
            return EliminateUtils.isPolyadicNegated((PsiPolyadicExpression)operand2, isNegated, toEliminate);
        }
        return EliminateUtils.processPrefixed(operand2, isNegated, (op, isOpNegated) -> {
            if (!ArrayUtil.contains((Object)operand2, (Object[])toEliminate)) {
                return isOpNegated;
            }
            PsiPolyadicExpression innerExpr = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)op), PsiPolyadicExpression.class);
            if (innerExpr == null) {
                return isOpNegated;
            }
            return EliminateUtils.isPolyadicNegated(innerExpr, isOpNegated, toEliminate);
        });
    }

    @Nullable
    static IElementType getOperandTokenType(@NotNull PsiPolyadicExpression expression2, @NotNull PsiExpression operand2, @Nullable IElementType outerTokenType) {
        PsiJavaToken operandToken = expression2.getTokenBeforeOperand(operand2);
        if (operandToken == null) {
            return outerTokenType;
        }
        IElementType innerTokenType = operandToken.getTokenType();
        if (outerTokenType == null) {
            return innerTokenType;
        }
        if (!EliminateUtils.isSamePrecedence(innerTokenType, outerTokenType)) {
            return innerTokenType;
        }
        if (EliminateUtils.isInversion(outerTokenType)) {
            return EliminateUtils.invert(innerTokenType);
        }
        return innerTokenType;
    }

    static boolean addPrefix(@Nullable IElementType tokenType, boolean isNegated, @NotNull StringBuilder sb) {
        if (tokenType == null) {
            if (isNegated) {
                sb.append("-");
            }
        } else if (isNegated && EliminateUtils.isAdditive(tokenType)) {
            IElementType inverted = EliminateUtils.invert(tokenType);
            if (inverted == null) {
                return false;
            }
            sb.append(EliminateUtils.getOperator(inverted));
        } else {
            String operator2 = EliminateUtils.getOperator(tokenType);
            if (operator2 == null) {
                return false;
            }
            sb.append(isNegated ? operator2 + "-" : operator2);
        }
        return true;
    }

    static {
        OPS.put(JavaTokenType.MINUS, "-");
        OPS.put(JavaTokenType.PLUS, "+");
        OPS.put(JavaTokenType.ASTERISK, "*");
        OPS.put(JavaTokenType.DIV, "/");
        OPS.put(JavaTokenType.OR, "|");
        OPS.put(JavaTokenType.AND, "&");
        OPS.put(JavaTokenType.OROR, "||");
        OPS.put(JavaTokenType.ANDAND, "&&");
        OPS.put(JavaTokenType.EQEQ, "==");
        OPS.put(JavaTokenType.NE, "!=");
        OPS.put(JavaTokenType.GT, ">");
        OPS.put(JavaTokenType.LT, "<");
        OPS.put(JavaTokenType.GE, ">=");
        OPS.put(JavaTokenType.LE, "<=");
        INVERTED_OPS.put(JavaTokenType.MINUS, JavaTokenType.PLUS);
        INVERTED_OPS.put(JavaTokenType.PLUS, JavaTokenType.MINUS);
        INVERTED_OPS.put(JavaTokenType.ASTERISK, JavaTokenType.DIV);
        INVERTED_OPS.put(JavaTokenType.DIV, JavaTokenType.ASTERISK);
    }
}

