/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiConcatenationUtil;
import com.intellij.psi.util.PsiLiteralUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.Jdk5StringConcatenationPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class ReplaceConcatenationWithFormatStringIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new Jdk5StringConcatenationPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element;
        PsiElement parent = expression2.getParent();
        while (ExpressionUtils.isStringConcatenation(parent)) {
            expression2 = (PsiPolyadicExpression)parent;
            parent = expression2.getParent();
        }
        ArrayList<PsiExpression> formatParameters = new ArrayList<PsiExpression>();
        String formatString = PsiConcatenationUtil.buildUnescapedFormatString((PsiExpression)expression2, (boolean)true, formatParameters);
        if (ReplaceConcatenationWithFormatStringIntention.replaceWithPrintfExpression(expression2, formatString, formatParameters)) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        StringBuilder newExpression = new StringBuilder();
        if (HighlightingFeature.TEXT_BLOCKS.isAvailable(element)) {
            ReplaceConcatenationWithFormatStringIntention.appendFormatString(expression2, formatString, false, newExpression);
            newExpression.append(".formatted(");
        } else {
            newExpression.append("java.lang.String.format(");
            ReplaceConcatenationWithFormatStringIntention.appendFormatString(expression2, formatString, false, newExpression);
            if (!formatParameters.isEmpty()) {
                newExpression.append(", ");
            }
        }
        newExpression.append(StreamEx.of(formatParameters).map(commentTracker::text).joining((CharSequence)", "));
        newExpression.append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression.toString(), commentTracker);
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        return IntentionPowerPackBundle.message(HighlightingFeature.TEXT_BLOCKS.isAvailable(element) ? "replace.concatenation.with.format.string.intention.name.formatted" : "replace.concatenation.with.format.string.intention.name", new Object[0]);
    }

    private static boolean replaceWithPrintfExpression(PsiPolyadicExpression expression2, String formatString, List<PsiExpression> formatParameters) {
        boolean insertNewline;
        PsiElement expressionParent = expression2.getParent();
        if (!(expressionParent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandParent = expressionParent.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String name2 = methodExpression.getReferenceName();
        if ("println".equals(name2)) {
            insertNewline = true;
        } else if ("print".equals(name2)) {
            insertNewline = false;
        } else {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (!"java.io.PrintStream".equals(qualifiedName) && !"java.io.PrintWriter".equals(qualifiedName)) {
            return false;
        }
        CommentTracker commentTracker = new CommentTracker();
        StringBuilder newExpression = new StringBuilder();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null) {
            newExpression.append(commentTracker.text((PsiElement)qualifier)).append('.');
        }
        newExpression.append("printf(");
        ReplaceConcatenationWithFormatStringIntention.appendFormatString(expression2, formatString, insertNewline, newExpression);
        for (PsiExpression formatParameter : formatParameters) {
            newExpression.append(",").append(commentTracker.text((PsiElement)formatParameter));
        }
        newExpression.append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString(), commentTracker);
        return true;
    }

    private static void appendFormatString(PsiPolyadicExpression expression2, String formatString, boolean insertNewline, StringBuilder newExpression) {
        boolean textBlocks = Arrays.stream(expression2.getOperands()).anyMatch(operand2 -> operand2 instanceof PsiLiteralExpression && ((PsiLiteralExpression)operand2).isTextBlock());
        if (textBlocks) {
            newExpression.append("\"\"\"\n");
            formatString = Arrays.stream(formatString.split("\n")).map(s -> PsiLiteralUtil.escapeTextBlockCharacters((String)s)).collect(Collectors.joining("\n"));
            newExpression.append(formatString);
            if (insertNewline) {
                newExpression.append('\n');
            }
            newExpression.append("\"\"\"");
        } else {
            newExpression.append('\"');
            newExpression.append(StringUtil.escapeStringCharacters((String)formatString));
            if (insertNewline) {
                newExpression.append("%n");
            }
            newExpression.append('\"');
        }
    }
}

