/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.Nullable;

class MethodCallChainPredicate
implements PsiElementPredicate {
    MethodCallChainPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (MethodCallChainPredicate.getCallChainRoot(element) == null) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent());
        return (parent instanceof PsiStatement || parent instanceof PsiVariable || parent instanceof PsiAssignmentExpression || parent instanceof PsiLambdaExpression) && element instanceof PsiExpression && CodeBlockSurrounder.canSurround((PsiExpression)element);
    }

    static PsiExpression getCallChainRoot(PsiElement element) {
        PsiClassType classType = MethodCallChainPredicate.getQualifierExpressionType(element);
        if (classType == null) {
            return null;
        }
        if (InheritanceUtil.isInheritor((PsiType)classType, (String)"java.util.stream.BaseStream")) {
            return null;
        }
        boolean first = true;
        while (true) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpression.getQualifierExpression());
            PsiClassType expressionType = MethodCallChainPredicate.getQualifierExpressionType((PsiElement)qualifierExpression2);
            if (!first) {
                if (expressionType == null) {
                    PsiMethod method;
                    PsiMethodCallExpression call;
                    if (qualifierExpression2 instanceof PsiMethodCallExpression && (call = (PsiMethodCallExpression)qualifierExpression2).getMethodExpression().getQualifierExpression() == null && ((method = call.resolveMethod()) == null || !method.hasModifierProperty("static"))) {
                        return null;
                    }
                    return qualifierExpression2;
                }
            } else {
                first = false;
            }
            if (!classType.equals((Object)expressionType)) {
                return null;
            }
            element = qualifierExpression2;
        }
    }

    @Nullable
    private static PsiClassType getQualifierExpressionType(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
        PsiType type2 = qualifierExpression2 != null ? qualifierExpression2.getType() : null;
        return type2 instanceof PsiClassType ? (PsiClassType)type2 : null;
    }
}

