/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class CopyConcatenatedStringToClipboardIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return element -> {
            boolean isStringLiteral = element instanceof PsiLiteralExpression && ExpressionUtils.hasStringType((PsiExpression)((PsiLiteralExpression)element)) && !(PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{PsiParenthesizedExpression.class}) instanceof PsiPolyadicExpression);
            return isStringLiteral || ExpressionUtils.isStringConcatenation(element);
        };
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        return element instanceof PsiLiteralExpression ? IntentionPowerPackBundle.message("copy.string.literal.to.clipboard.intention.name", new Object[0]) : IntentionPowerPackBundle.message("copy.concatenated.string.to.clipboard.intention.name", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        String text2;
        if (element instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            Object value2 = literalExpression.getValue();
            if (!(value2 instanceof String)) {
                return;
            }
            text2 = (String)value2;
        } else {
            if (!ExpressionUtils.isStringConcatenation(element)) {
                return;
            }
            text2 = CopyConcatenatedStringToClipboardIntention.buildConcatenationText((PsiPolyadicExpression)element);
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
    }

    public static String buildConcatenationText(PsiPolyadicExpression polyadicExpression) {
        StringBuilder out = new StringBuilder();
        for (PsiElement element = polyadicExpression.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (element instanceof PsiExpression) {
                PsiExpression expression2 = (PsiExpression)element;
                Object value2 = ExpressionUtils.computeConstantExpression(expression2);
                out.append(value2 == null ? "?" : value2.toString());
                continue;
            }
            if (!(element instanceof PsiWhiteSpace) || !element.getText().contains("\n") || out.length() != 0 && out.charAt(out.length() - 1) == '\n') continue;
            out.append('\n');
        }
        return out.toString();
    }
}

