/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.commutative;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class FlipCommutativeMethodCallPredicate
implements PsiElementPredicate {
    FlipCommutativeMethodCallPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiMethod[] methods;
        PsiType qualifierType;
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        PsiMethodCallExpression expression2 = (PsiMethodCallExpression)element;
        PsiExpression[] arguments = expression2.getArgumentList().getExpressions();
        if (arguments.length != 1) {
            return false;
        }
        PsiExpression argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
        if (argument == null) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpression.getQualifierExpression());
        if (qualifier == null) {
            if (argument instanceof PsiThisExpression) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null || method.hasModifierProperty("static")) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            qualifierType = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass);
        } else {
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(argument, qualifier)) {
                return false;
            }
            qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiClassType)) {
                return false;
            }
        }
        String methodName = methodExpression.getReferenceName();
        PsiType argumentType = argument.getType();
        if (!(argumentType instanceof PsiClassType)) {
            return false;
        }
        if (qualifierType.equals(argumentType)) {
            return true;
        }
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)argumentType).resolveGenerics();
        PsiClass argumentClass = resolveResult.getElement();
        if (argumentClass == null) {
            return false;
        }
        for (PsiMethod testMethod : methods = argumentClass.findMethodsByName(methodName, true)) {
            PsiType type2;
            PsiSubstitutor substitutor;
            PsiParameterList parameterList = testMethod.getParameterList();
            if (parameterList.getParametersCount() != 1) continue;
            PsiParameter parameter2 = parameterList.getParameters()[0];
            PsiClass containingClass = testMethod.getContainingClass();
            if (containingClass == null || (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)containingClass, (PsiClass)argumentClass, (PsiSubstitutor)resolveResult.getSubstitutor())) == null || (type2 = substitutor.substitute(parameter2.getType())) == null || !type2.isAssignableFrom(qualifierType)) continue;
            return true;
        }
        return false;
    }
}

