/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.commutative;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.commutative.FlipCommutativeMethodCallPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipCommutativeMethodCallIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        assert (methodName != null);
        if ("equals".equals(methodName) || "equalsIgnoreCase".equals(methodName)) {
            return IntentionPowerPackBundle.message("flip.commutative.method.call.intention.name", methodName);
        }
        return IntentionPowerPackBundle.message("flip.commutative.method.call.intention.name1", methodName);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new FlipCommutativeMethodCallPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiMethodCallExpression expression2 = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression argument = argumentList.getExpressions()[0];
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(methodExpression);
        PsiExpression strippedQualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier);
        PsiExpression strippedArgument = PsiUtil.skipParenthesizedExprDown((PsiExpression)argument);
        if (strippedQualifier == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        tracker.grabComments((PsiElement)qualifier);
        tracker.markUnchanged(strippedQualifier);
        tracker.grabComments((PsiElement)argument);
        tracker.markUnchanged(strippedArgument);
        PsiElement newArgument = strippedQualifier.copy();
        methodExpression.setQualifierExpression(strippedArgument);
        argument.replace(newArgument);
        tracker.insertCommentsBefore((PsiElement)expression2);
    }
}

