/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.CommentOnLineWithSourcePredicate;
import org.jetbrains.annotations.NotNull;

public class MoveCommentToSeparateLineIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new CommentOnLineWithSourcePredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        String newline;
        PsiElement prevLeaf;
        PsiComment comment = (PsiComment)element;
        while (true) {
            if ((prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element)) == null || prevLeaf instanceof PsiWhiteSpace && prevLeaf.getText().indexOf(10) >= 0) break;
            element = prevLeaf;
        }
        PsiWhiteSpace whitespace = (PsiWhiteSpace)prevLeaf;
        PsiElement anchor = element;
        Project project = comment.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(comment.getContainingFile());
        if (document == null) {
            return;
        }
        if (whitespace == null) {
            newline = "\n";
        } else {
            String text2 = whitespace.getText();
            newline = text2.substring(text2.lastIndexOf(10));
        }
        PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)comment);
        TextRange commentRange = comment.getTextRange();
        int deleteOffset = prev instanceof PsiWhiteSpace ? prev.getTextRange().getStartOffset() : commentRange.getStartOffset();
        document.deleteString(deleteOffset, commentRange.getEndOffset());
        int offset = anchor.getTextRange().getStartOffset();
        document.insertString(offset, (CharSequence)newline);
        document.insertString(offset, (CharSequence)comment.getText());
        MoveCommentToSeparateLineIntention.scrollToVisible(project, offset);
    }

    private static void scrollToVisible(Project project, int offset) {
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        LogicalPosition position = editor.offsetToLogicalPosition(offset);
        editor.getScrollingModel().scrollTo(position, ScrollType.MAKE_VISIBLE);
    }
}

