/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.HashSet;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FieldHidesSuperclassFieldInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean ignoreStaticFields = true;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.defaultWriteSettings(node, "ignoreStaticFields");
        this.writeBooleanOption(node, "ignoreStaticFields", true);
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "FieldNameHidesFieldInSuperclass";
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("field.name.hides.in.superclass.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.option", new Object[0]), "m_ignoreInvisibleFields");
        panel2.addCheckbox(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.static.field.option", new Object[0]), "ignoreStaticFields");
        return panel2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldHidesSuperclassFieldVisitor();
    }

    private class FieldHidesSuperclassFieldVisitor
    extends BaseInspectionVisitor {
        private FieldHidesSuperclassFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName)) {
                return;
            }
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                PsiField ancestorField = ancestorClass.findFieldByName(fieldName, false);
                if (ancestorField == null || FieldHidesSuperclassFieldInspection.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(ancestorField, aClass) || FieldHidesSuperclassFieldInspection.this.ignoreStaticFields && field.hasModifierProperty("static") && ancestorField.hasModifierProperty("static")) continue;
                this.registerFieldError(field, new Object[0]);
                return;
            }
        }
    }
}

