/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class WaitWhileHoldingTwoLocksInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("wait.while.holding.two.locks.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitWhileHoldingTwoLocksVisitor();
    }

    private static class WaitWhileHoldingTwoLocksVisitor
    extends BaseInspectionVisitor {
        private WaitWhileHoldingTwoLocksVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            this.checkErrorsIn((PsiElement)method);
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            this.checkErrorsIn((PsiElement)initializer);
        }

        private void checkErrorsIn(PsiElement context) {
            context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
                private int m_numLocksHeld;

                public void visitClass(PsiClass aClass) {
                }

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
                    PsiType parameterType;
                    super.visitMethodCallExpression(expression2);
                    if (this.m_numLocksHeld < 2) {
                        return;
                    }
                    PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                    String methodName = methodExpression.getReferenceName();
                    if (!"wait".equals(methodName)) {
                        return;
                    }
                    PsiMethod method = expression2.resolveMethod();
                    if (method == null) {
                        return;
                    }
                    PsiParameterList parameterList = method.getParameterList();
                    int numParams = parameterList.getParametersCount();
                    if (numParams > 2) {
                        return;
                    }
                    PsiParameter[] parameters2 = parameterList.getParameters();
                    if (numParams > 0 && !(parameterType = parameters2[0].getType()).equals(PsiType.LONG)) {
                        return;
                    }
                    if (numParams > 1 && !(parameterType = parameters2[1].getType()).equals(PsiType.INT)) {
                        return;
                    }
                    this.registerMethodCallError(expression2, new Object[0]);
                }

                public void visitMethod(@NotNull PsiMethod method) {
                    if (method.hasModifierProperty("synchronized")) {
                        ++this.m_numLocksHeld;
                    }
                    super.visitMethod(method);
                }

                public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement synchronizedStatement) {
                    ++this.m_numLocksHeld;
                    super.visitSynchronizedStatement(synchronizedStatement);
                }

                protected void elementFinished(@NotNull PsiElement element) {
                    super.elementFinished(element);
                    if (element instanceof PsiMethod && ((PsiMethod)element).hasModifierProperty("synchronized") || element instanceof PsiSynchronizedStatement) {
                        --this.m_numLocksHeld;
                    }
                }
            });
        }
    }
}

