/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class ThreadStartInConstructionInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToThreadStartDuringObjectConstruction";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("thread.start.in.construction.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadStartInConstructionVisitor();
    }

    private static class ThreadStartInConstructionVisitor
    extends BaseInspectionVisitor {
        private ThreadStartInConstructionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method.isConstructor()) {
                method.accept((PsiElementVisitor)new ThreadStartVisitor());
            }
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (!initializer.hasModifierProperty("static")) {
                initializer.accept((PsiElementVisitor)new ThreadStartVisitor());
            }
        }

        private class ThreadStartVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private ThreadStartVisitor() {
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
                super.visitMethodCallExpression(expression2);
                PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"start".equals(methodName)) {
                    return;
                }
                PsiMethod method = expression2.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (!parameterList.isEmpty()) {
                    return;
                }
                PsiClass methodClass = method.getContainingClass();
                if (methodClass == null || !InheritanceUtil.isInheritor((PsiClass)methodClass, (String)"java.lang.Thread")) {
                    return;
                }
                PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression2);
                if (containingClass == null || containingClass.hasModifierProperty("final")) {
                    return;
                }
                ThreadStartInConstructionVisitor.this.registerMethodCallError(expression2, new Object[0]);
            }
        }
    }
}

