/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SynchronizedMethodInspection
extends BaseInspection {
    public boolean m_includeNativeMethods = true;
    public boolean ignoreSynchronizedSuperMethods = true;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        return InspectionGadgetsBundle.message("synchronized.method.problem.descriptor", method.getName());
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        if (method.getBody() == null) {
            return null;
        }
        return new SynchronizedMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizedMethodVisitor();
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("synchronized.method.include.option", new Object[0]), "m_includeNativeMethods");
        panel2.addCheckbox(InspectionGadgetsBundle.message("synchronized.method.ignore.synchronized.super.option", new Object[0]), "ignoreSynchronizedSuperMethods");
        return panel2;
    }

    private class SynchronizedMethodVisitor
    extends BaseInspectionVisitor {
        private SynchronizedMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            if (!SynchronizedMethodInspection.this.m_includeNativeMethods && method.hasModifierProperty("native")) {
                return;
            }
            if (SynchronizedMethodInspection.this.ignoreSynchronizedSuperMethods) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                    if (!superMethod.hasModifierProperty("synchronized")) continue;
                    return;
                }
            }
            this.registerModifierError("synchronized", (PsiModifierListOwner)method, method);
        }
    }

    private static class SynchronizedMethodFix
    extends InspectionGadgetsFix {
        private SynchronizedMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("synchronized.method.move.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            String replacementText;
            PsiElement nameElement = descriptor.getPsiElement();
            PsiModifierList modifierList = (PsiModifierList)nameElement.getParent();
            assert (modifierList != null);
            PsiMethod method = (PsiMethod)modifierList.getParent();
            modifierList.setModifierProperty("synchronized", false);
            assert (method != null);
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) {
                return;
            }
            String text2 = body2.getText();
            if (method.hasModifierProperty("static")) {
                PsiClass containingClass = method.getContainingClass();
                assert (containingClass != null);
                String className2 = containingClass.getName();
                replacementText = "{ synchronized(" + className2 + ".class){" + text2.substring(1) + '}';
            } else {
                replacementText = "{ synchronized(this){" + text2.substring(1) + '}';
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiCodeBlock block = elementFactory.createCodeBlockFromText(replacementText, null);
            body2.replace((PsiElement)block);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformat((PsiElement)method);
        }
    }
}

