/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryConstantArrayCreationExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length != 0 && infos[0] instanceof String) {
            return new UnnecessaryConstantArrayCreationExpressionFix((String)infos[0]);
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConstantArrayCreationExpressionVisitor();
    }

    private static class UnnecessaryConstantArrayCreationExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConstantArrayCreationExpressionVisitor() {
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            super.visitArrayInitializerExpression(expression2);
            PsiElement parent = expression2.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                return;
            }
            PsiElement grandParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
            if (!(grandParent instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)grandParent;
            PsiType expressionType = expression2.getType();
            if (!variable.getType().equals(expressionType)) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement != null && typeElement.isInferredType()) {
                return;
            }
            if (UnnecessaryConstantArrayCreationExpressionVisitor.hasGenericTypeParameters(variable)) {
                return;
            }
            this.registerError(parent, expressionType.getPresentableText());
        }

        private static boolean hasGenericTypeParameters(PsiVariable variable) {
            PsiType[] parameterTypes;
            PsiType type2 = variable.getType();
            PsiType componentType = type2.getDeepComponentType();
            if (!(componentType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)componentType;
            for (PsiType parameterType : parameterTypes = classType.getParameters()) {
                if (parameterType == null) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnnecessaryConstantArrayCreationExpressionFix
    extends InspectionGadgetsFix {
        private final String myType;

        private UnnecessaryConstantArrayCreationExpressionFix(String type2) {
            this.myType = type2;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.family.quickfix", new Object[0]);
        }

        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"new " + this.myType});
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)element;
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer == null) {
                return;
            }
            PsiNewExpression target = newExpression;
            while (target.getParent() instanceof PsiParenthesizedExpression) {
                target = (PsiExpression)target.getParent();
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)target, (PsiElement)arrayInitializer);
        }
    }
}

