/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.style.ConditionalModel;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConditionalExpressionGenerator {
    @NotNull
    private final String myTokenType;
    @NotNull
    private final @NotNull Function<@NotNull CommentTracker, @NotNull String> myGenerator;
    @Nullable
    private final PsiExpression myReplacement;

    private ConditionalExpressionGenerator(@NotNull String type2, @NotNull @NotNull Function<@NotNull CommentTracker, @NotNull String> generator) {
        this.myTokenType = type2;
        this.myGenerator = generator;
        this.myReplacement = null;
    }

    private ConditionalExpressionGenerator(@NotNull String type2, @NotNull PsiExpression replacement) {
        this.myTokenType = type2;
        this.myGenerator = ct -> ct.text((PsiElement)replacement);
        this.myReplacement = replacement;
    }

    @Nullable
    public PsiExpression getReplacement() {
        return this.myReplacement;
    }

    @NotNull
    public String getTokenType() {
        return this.myTokenType;
    }

    @NotNull
    public String generate(CommentTracker ct) {
        return this.myGenerator.apply(ct);
    }

    public static ConditionalExpressionGenerator from(ConditionalModel model) {
        PsiExpression redundantComparisonReplacement;
        PsiExpression condition2 = model.getCondition();
        PsiExpression thenExpression2 = model.getThenExpression();
        PsiExpression elseExpression2 = model.getElseExpression();
        if (PsiType.BOOLEAN.equals((Object)model.getType()) || model.getType().equalsToText("java.lang.Boolean")) {
            Boolean elseValue;
            PsiLiteralExpression thenLiteral = ExpressionUtils.getLiteral(thenExpression2);
            PsiLiteralExpression elseLiteral = ExpressionUtils.getLiteral(elseExpression2);
            Boolean thenValue = thenLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)thenLiteral.getValue(), Boolean.class);
            Boolean bl = elseValue = elseLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)elseLiteral.getValue(), Boolean.class);
            if (thenValue != null && elseValue != null) {
                if (thenValue.equals(elseValue)) {
                    return null;
                }
                if (thenValue.booleanValue()) {
                    return new ConditionalExpressionGenerator("", condition2);
                }
                return new ConditionalExpressionGenerator("", ct -> BoolUtils.getNegatedExpressionText(condition2, ct));
            }
            if ((thenValue != null || elseValue != null) && PsiType.BOOLEAN.equals((Object)model.getType())) {
                return ConditionalExpressionGenerator.getAndOrGenerator(condition2, thenExpression2, elseExpression2, thenValue, elseValue);
            }
            if (BoolUtils.areExpressionsOpposite(thenExpression2, elseExpression2)) {
                return ConditionalExpressionGenerator.getEqualityGenerator(model.getCondition(), thenExpression2);
            }
        }
        if ((redundantComparisonReplacement = ConditionalExpressionGenerator.getRedundantComparisonReplacement(model)) != null) {
            return new ConditionalExpressionGenerator("", redundantComparisonReplacement);
        }
        return new ConditionalExpressionGenerator("?:", ct -> ConditionalExpressionGenerator.generateTernary(ct, condition2, thenExpression2, elseExpression2, model.getType()));
    }

    private static ConditionalExpressionGenerator getAndOrGenerator(PsiExpression condition2, PsiExpression thenExpression2, PsiExpression elseExpression2, Boolean thenValue, Boolean elseValue) {
        if (thenValue != null) {
            if (thenValue.booleanValue()) {
                return new ConditionalExpressionGenerator("||", ct -> ConditionalExpressionGenerator.joinConditions(condition2, elseExpression2, false, ct));
            }
            return new ConditionalExpressionGenerator("&&", ct -> BoolUtils.getNegatedExpressionText(condition2, 13, ct) + " && " + ct.text(elseExpression2, 13));
        }
        if (!elseValue.booleanValue()) {
            return new ConditionalExpressionGenerator("&&", ct -> ConditionalExpressionGenerator.joinConditions(condition2, thenExpression2, true, ct));
        }
        return new ConditionalExpressionGenerator("||", ct -> BoolUtils.getNegatedExpressionText(condition2, 14, ct) + " || " + ct.text(thenExpression2, 14));
    }

    private static PsiExpression getRedundantComparisonReplacement(@NotNull ConditionalModel model) {
        @NotNull PsiExpression thenExpression2 = model.getThenExpression();
        @NotNull PsiExpression elseExpression2 = model.getElseExpression();
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)model.getCondition()), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        IElementType tokenType = binOp.getOperationTokenType();
        boolean equals = tokenType.equals(JavaTokenType.EQEQ);
        if (!equals && !tokenType.equals(JavaTokenType.NE)) {
            return null;
        }
        PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
        PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
        if (!ExpressionUtils.isSafelyRecomputableExpression(left) || !ExpressionUtils.isSafelyRecomputableExpression(right)) {
            return null;
        }
        if (TypeConversionUtil.isFloatOrDoubleType((PsiType)left.getType()) && TypeConversionUtil.isFloatOrDoubleType((PsiType)right.getType())) {
            return null;
        }
        EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
        if (equivalence.expressionsAreEquivalent(left, thenExpression2) && equivalence.expressionsAreEquivalent(right, elseExpression2) || equivalence.expressionsAreEquivalent(right, thenExpression2) && equivalence.expressionsAreEquivalent(left, elseExpression2)) {
            return equals ? elseExpression2 : thenExpression2;
        }
        return null;
    }

    private static ConditionalExpressionGenerator getEqualityGenerator(PsiExpression condition2, PsiExpression expression2) {
        PsiExpression right;
        PsiExpression left;
        boolean equal = true;
        if (BoolUtils.isNegation(condition2)) {
            equal = false;
            left = Objects.requireNonNull(BoolUtils.getNegated(condition2));
        } else {
            left = condition2;
        }
        if (BoolUtils.isNegation(expression2)) {
            equal = !equal;
            right = Objects.requireNonNull(BoolUtils.getNegated(expression2));
        } else {
            right = expression2;
        }
        String token = equal ? "==" : "!=";
        return new ConditionalExpressionGenerator(token, ct -> ct.text(left, 7) + " " + token + " " + ct.text(right, 7));
    }

    private static PsiExpression expandDiamondsWhenNeeded(PsiExpression thenValue, PsiType requiredType) {
        if (thenValue instanceof PsiNewExpression && !PsiDiamondTypeUtil.canChangeContextForDiamond((PsiNewExpression)thenValue, requiredType)) {
            return PsiDiamondTypeUtil.expandTopLevelDiamondsInside(thenValue);
        }
        return thenValue;
    }

    private static String generateTernary(CommentTracker ct, PsiExpression condition2, PsiExpression thenValue, PsiExpression elseValue, PsiType type2) {
        thenValue = ConditionalExpressionGenerator.expandDiamondsWhenNeeded(thenValue, type2);
        elseValue = ConditionalExpressionGenerator.expandDiamondsWhenNeeded(elseValue, type2);
        StringBuilder conditional = new StringBuilder();
        String conditionText = ct.text(condition2, 15);
        if (condition2 instanceof PsiConditionalExpression) {
            conditional.append('(').append(conditionText).append(')');
        } else {
            conditional.append(conditionText);
        }
        conditional.append('?');
        PsiType thenType = thenValue.getType();
        PsiType elseType = elseValue.getType();
        if (thenType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)thenType) && !(elseType instanceof PsiPrimitiveType) && !(type2 instanceof PsiPrimitiveType)) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)thenType;
            conditional.append(primitiveType.getBoxedTypeName());
            conditional.append(".valueOf(").append(ct.text((PsiElement)thenValue)).append("):");
            conditional.append(ct.text(elseValue, 15));
        } else if (elseType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)elseType) && !(thenType instanceof PsiPrimitiveType) && !(type2 instanceof PsiPrimitiveType)) {
            conditional.append(ct.text(thenValue, 15));
            conditional.append(':');
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)elseType;
            conditional.append(primitiveType.getBoxedTypeName());
            conditional.append(".valueOf(").append(ct.text((PsiElement)elseValue)).append(')');
        } else {
            conditional.append(ct.text(thenValue, 15));
            conditional.append(':');
            conditional.append(ct.text(elseValue, 15));
        }
        return conditional.toString();
    }

    @NotNull
    private static String joinConditions(PsiExpression left, PsiExpression right, boolean isAnd, CommentTracker ct) {
        IElementType tokenType;
        String token;
        int precedence;
        if (isAnd) {
            precedence = 13;
            token = " && ";
            tokenType = JavaTokenType.ANDAND;
        } else {
            precedence = 14;
            token = " || ";
            tokenType = JavaTokenType.OROR;
        }
        PsiPolyadicExpression leftPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)left), PsiPolyadicExpression.class);
        PsiPolyadicExpression rightPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)right), PsiPolyadicExpression.class);
        if (rightPolyadic != null && rightPolyadic.getOperationTokenType().equals(tokenType) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ArrayUtil.getFirstElement((Object[])rightPolyadic.getOperands()), left) && !SideEffectChecker.mayHaveSideEffects(left)) {
            return ct.text((PsiElement)rightPolyadic);
        }
        if (leftPolyadic != null && leftPolyadic.getOperationTokenType().equals(tokenType) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ArrayUtil.getLastElement((Object[])leftPolyadic.getOperands()), right) && !SideEffectChecker.mayHaveSideEffects(right)) {
            return ct.text((PsiElement)leftPolyadic);
        }
        return ct.text(left, precedence) + token + ct.text(right, precedence);
    }
}

