/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightVisitorImpl;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.style.Variance;
import com.siyeh.ig.style.VarianceCandidate;
import com.siyeh.ig.style.VarianceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundedWildcardInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(BoundedWildcardInspection.class);
    public boolean REPORT_INVARIANT_CLASSES = true;
    public boolean REPORT_PRIVATE_METHODS = true;
    public boolean REPORT_INSTANCE_METHODS = true;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new JavaElementVisitor(){

            public void visitTypeElement(PsiTypeElement typeElement) {
                VarianceCandidate candidate = VarianceCandidate.findVarianceCandidate(typeElement);
                if (candidate == null) {
                    return;
                }
                PsiTypeParameterListOwner owner2 = candidate.typeParameter.getOwner();
                if (owner2 instanceof PsiClass && !BoundedWildcardInspection.this.REPORT_INVARIANT_CLASSES && VarianceUtil.getClassVariance((PsiClass)owner2, candidate.typeParameter) == Variance.INVARIANT) {
                    return;
                }
                PsiClass containingClass = candidate.method.getContainingClass();
                if (!BoundedWildcardInspection.this.REPORT_PRIVATE_METHODS && (candidate.method.hasModifierProperty("private") || containingClass != null && containingClass.hasModifierProperty("private"))) {
                    return;
                }
                if (!(BoundedWildcardInspection.this.REPORT_INSTANCE_METHODS || candidate.method.hasModifierProperty("static") || candidate.method.isConstructor())) {
                    return;
                }
                Project project = holder.getProject();
                boolean canBeSuper = BoundedWildcardInspection.canChangeTo(project, candidate, false);
                boolean canBeExtends = BoundedWildcardInspection.canChangeTo(project, candidate, true);
                if (canBeExtends == canBeSuper || VarianceUtil.areBoundsSaturated(candidate, canBeExtends)) {
                    return;
                }
                boolean wildCardIsUseless = VarianceUtil.wildCardIsUseless(candidate, canBeExtends);
                ProblemHighlightType type2 = wildCardIsUseless ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String msg = (canBeExtends ? InspectionGadgetsBundle.message("bounded.wildcard.covariant.descriptor", new Object[0]) : InspectionGadgetsBundle.message("bounded.wildcard.contravariant.descriptor", new Object[0])) + (wildCardIsUseless ? " but decided against it" : "");
                if (!wildCardIsUseless || LOG.isDebugEnabled()) {
                    holder.registerProblem((PsiElement)typeElement, msg, type2, new LocalQuickFix[]{new ReplaceWithQuestionTFix(BoundedWildcardInspection.isOverriddenOrOverrides(candidate.method), canBeExtends)});
                }
            }
        };
    }

    @NotNull
    private static PsiClassReferenceType suggestMethodParameterType(@NotNull VarianceCandidate candidate, boolean isExtends) {
        PsiType type2 = candidate.type;
        PsiManager psiManager = candidate.method.getManager();
        PsiElementFactory pf = PsiElementFactory.getInstance((Project)psiManager.getProject());
        PsiTypeElement newInnerTypeElement = pf.createTypeElement((PsiType)(isExtends ? PsiWildcardType.createExtends((PsiManager)psiManager, (PsiType)type2) : PsiWildcardType.createSuper((PsiManager)psiManager, (PsiType)type2)));
        PsiClassReferenceType methodParamType = candidate.methodParameterType;
        PsiClassReferenceType clone = new PsiClassReferenceType((PsiJavaCodeReferenceElement)methodParamType.getReference().copy(), methodParamType.getLanguageLevel());
        PsiAnnotation[] annotations = methodParamType.getApplicableAnnotations();
        PsiJavaCodeReferenceElement cloneReference = clone.getReference();
        for (int i = annotations.length - 1; i >= 0; --i) {
            PsiAnnotation annotation = annotations[i];
            cloneReference.addBefore((PsiElement)annotation, cloneReference.getFirstChild());
        }
        PsiTypeElement innerTypeElement = cloneReference.getParameterList().getTypeParameterElements()[candidate.typeParameterIndex];
        innerTypeElement.replace((PsiElement)newInnerTypeElement);
        return clone;
    }

    private static boolean isOverriddenOrOverrides(@NotNull PsiMethod method) {
        if (method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
            return false;
        }
        if (method.hasModifierProperty("abstract")) {
            return true;
        }
        boolean overrides = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
        return overrides || OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
    }

    private static PsiField findFieldAssignedFromMethodParameter(@NotNull PsiParameter methodParameter, @NotNull PsiMethod method) {
        PsiCodeBlock methodBody2 = method.getBody();
        if (methodBody2 == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        Ref assignedToField = Ref.create();
        ReferencesSearch.search((PsiElement)methodParameter, (SearchScope)new LocalSearchScope((PsiElement)methodBody2)).forEach(ref -> {
            ProgressManager.checkCanceled();
            Pair<PsiField, PsiType> assigned = BoundedWildcardInspection.isAssignedToField(ref, containingClass);
            if (assigned != null) {
                if (!assignedToField.isNull() && !assigned.equals(assignedToField.get())) {
                    assignedToField.set(null);
                    return false;
                }
                assignedToField.set(assigned);
            }
            return true;
        });
        return (PsiField)Pair.getFirst((Pair)((Pair)assignedToField.get()));
    }

    private static boolean canChangeTo(@NotNull Project project, @NotNull VarianceCandidate candidate, boolean isExtends) {
        @NotNull PsiMethod method = candidate.method;
        PsiCodeBlock methodBody2 = method.getBody();
        if (methodBody2 == null) {
            return false;
        }
        PsiClassReferenceType newParameterType = BoundedWildcardInspection.suggestMethodParameterType(candidate, isExtends);
        PsiMethod methodCopy = (PsiMethod)DebugUtil.performPsiModification((String)"Creating method copy", () -> BoundedWildcardInspection.createMethodCopy(project, candidate.method, candidate.methodParameterIndex, newParameterType));
        PsiClass containingClass = candidate.method.getContainingClass();
        PsiField field = BoundedWildcardInspection.findFieldAssignedFromMethodParameter(candidate.methodParameter, method);
        ArrayList<PsiElement> superMethodsCalls = new ArrayList<PsiElement>();
        BoundedWildcardInspection.findSuperMethodCallsInside(methodCopy, candidate.superMethods, superMethodsCalls);
        if (field == null && containingClass.findMethodsByName(candidate.method.getName()).length == 1) {
            return BoundedWildcardInspection.errorChecks((PsiElement)methodCopy.getBody(), superMethodsCalls);
        }
        if (containingClass.getQualifiedName() != null) {
            List methodsToErrorCheck;
            PsiMethod methodCopyInClass = (PsiMethod)DebugUtil.performPsiModification((String)"Creating class copy", () -> BoundedWildcardInspection.createClassCopy(project, field, containingClass, candidate.method, methodCopy, newParameterType));
            if (field != null) {
                PsiClass classCopy = methodCopyInClass.getContainingClass();
                int fieldIndex = ArrayUtil.indexOf((Object[])containingClass.getFields(), (Object)field);
                if (fieldIndex == -1) {
                    return false;
                }
                PsiField fieldCopy = classCopy.getFields()[fieldIndex];
                Collection refs = ReferencesSearch.search((PsiElement)fieldCopy, (SearchScope)new LocalSearchScope((PsiElement)classCopy)).findAll();
                Map<PsiMethod, List<PsiReference>> collect2 = refs.stream().collect(Collectors.groupingBy(ref -> (PsiMethod)ObjectUtils.notNull((Object)PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), PsiMethod.class), (Object)method)));
                methodsToErrorCheck = ContainerUtil.filter(collect2.keySet(), k -> k != method);
            } else {
                methodsToErrorCheck = Collections.singletonList(methodCopyInClass);
            }
            for (PsiMethod psiMethodCopy : methodsToErrorCheck) {
                PsiCodeBlock body2 = psiMethodCopy.getBody();
                if (body2 == null || BoundedWildcardInspection.errorChecks((PsiElement)body2, superMethodsCalls)) continue;
                return false;
            }
            return true;
        }
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiMethod.class);
        if (containingMethod != null) {
            PsiMethod containingMethodCopy = (PsiMethod)DebugUtil.performPsiModification((String)"Creating method copy", () -> BoundedWildcardInspection.createMethodCopy(project, containingMethod, -1, newParameterType));
            int anonClassOffsetInContainingMethod = containingClass.getTextRange().getStartOffset() - containingMethod.getTextRange().getStartOffset();
            PsiElement element = containingMethodCopy.findElementAt(anonClassOffsetInContainingMethod);
            PsiClass containingClassCopy = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, containingClass.getClass(), (boolean)false);
            PsiMethod newMethodCopy = containingClassCopy.getMethods()[ArrayUtil.indexOf((Object[])containingClass.getMethods(), (Object)candidate.method)];
            PsiTypeElement paramTE = Objects.requireNonNull(newMethodCopy.getParameterList().getParameter(candidate.methodParameterIndex)).getTypeElement();
            ReplaceWithQuestionTFix.replaceType(project, paramTE, (PsiType)newParameterType);
            BoundedWildcardInspection.findSuperMethodCallsInside(newMethodCopy, candidate.superMethods, superMethodsCalls);
            return BoundedWildcardInspection.errorChecks((PsiElement)newMethodCopy.getBody(), superMethodsCalls);
        }
        return false;
    }

    private static void findSuperMethodCallsInside(@NotNull PsiMethod method, final @NotNull List<PsiMethod> superMethods, final @NotNull List<? super PsiElement> result) {
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null || superMethods.isEmpty()) {
            return;
        }
        body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiMethod called = expression2.resolveMethod();
                if (superMethods.contains(called)) {
                    result.add(expression2);
                }
                super.visitMethodCallExpression(expression2);
            }
        });
    }

    @NotNull
    private static PsiMethod createMethodCopy(@NotNull Project project, PsiMethod method, int methodParameterIndex, @NotNull PsiClassReferenceType newParameterExtends) {
        JavaDummyHolder dummyHolder = (JavaDummyHolder)DummyHolderFactory.createHolder((PsiManager)PsiManager.getInstance((Project)project), (PsiElement)method);
        PsiMethod methodCopy = (PsiMethod)dummyHolder.add((PsiElement)method);
        dummyHolder.setInjectedDeclarations((processor2, state, lastParent, place) -> processor2.execute((PsiElement)methodCopy, state));
        if (methodParameterIndex != -1) {
            PsiTypeElement paramTE = Objects.requireNonNull(methodCopy.getParameterList().getParameter(methodParameterIndex)).getTypeElement();
            ReplaceWithQuestionTFix.replaceType(project, paramTE, (PsiType)newParameterExtends);
        }
        return methodCopy;
    }

    @NotNull
    private static PsiMethod createClassCopy(@NotNull Project project, @Nullable PsiField field, @NotNull PsiClass containingClass, @NotNull PsiMethod method, @NotNull PsiMethod methodCopy, @NotNull PsiClassReferenceType newParameterExtends) {
        JavaDummyHolder dummyHolder = (JavaDummyHolder)DummyHolderFactory.createHolder((PsiManager)PsiManager.getInstance((Project)project), (PsiElement)containingClass);
        PsiClass classCopy = (PsiClass)dummyHolder.add((PsiElement)containingClass);
        if (field != null) {
            PsiField fieldCopy = classCopy.findFieldByName(field.getName(), false);
            ReplaceWithQuestionTFix.replaceType(project, fieldCopy.getTypeElement(), (PsiType)newParameterExtends);
        }
        int methodIndex = ArrayUtil.indexOf((Object[])containingClass.getMethods(), (Object)method);
        PsiMethod methodInClassCopy = classCopy.getMethods()[methodIndex];
        PsiMethod result = (PsiMethod)methodInClassCopy.replace((PsiElement)methodCopy);
        BoundedWildcardInspection.patchThisExpression(result, containingClass);
        return result;
    }

    private static void patchThisExpression(PsiMethod methodCopy, PsiClass containingClass) {
        final PsiClass classCopy = methodCopy.getContainingClass();
        final ArrayList these = new ArrayList();
        methodCopy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitThisExpression(PsiThisExpression expression2) {
                super.visitThisExpression(expression2);
                if (PsiUtil.resolveClassInType((PsiType)expression2.getType()) == classCopy) {
                    these.add(expression2);
                }
            }
        });
        if (!these.isEmpty()) {
            PsiElementFactory f = PsiElementFactory.getInstance((Project)containingClass.getProject());
            PsiParameter __this__ = f.createParameter("__this__", (PsiType)f.createType(containingClass));
            methodCopy.getParameterList().add((PsiElement)__this__);
            for (PsiThisExpression thisExpr : these) {
                PsiExpression newExpr = f.createExpressionFromText("__this__", (PsiElement)thisExpr);
                thisExpr.replace((PsiElement)newExpr);
            }
        }
    }

    private static boolean errorChecks(@NotNull PsiElement method, final @NotNull List<PsiElement> elementsToIgnore) {
        HighlightVisitor visitorImpl = (HighlightVisitor)ContainerUtil.find((Iterable)HighlightVisitor.EP_HIGHLIGHT_VISITOR.getExtensionList((AreaInstance)method.getProject()), h -> h instanceof HighlightVisitorImpl);
        if (visitorImpl == null) {
            return true;
        }
        final HighlightVisitor visitor2 = visitorImpl.clone();
        final HighlightInfoHolder holder = new HighlightInfoHolder(method.getContainingFile(), new HighlightInfoFilter[0]);
        visitor2.analyze(method.getContainingFile(), false, holder, () -> method.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (elementsToIgnore.contains(element)) {
                    return;
                }
                visitor2.visit(element);
                if (holder.hasErrorResults()) {
                    this.stopWalking();
                }
                super.visitElement(element);
            }
        }));
        return !holder.hasErrorResults();
    }

    private static PsiElement skipParensAndCastsUp(@NotNull PsiElement element) {
        PsiElement prev = element;
        PsiElement parent = element.getParent();
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression && ((PsiTypeCastExpression)parent).getOperand() == prev) {
            prev = parent;
            parent = parent.getParent();
        }
        return parent;
    }

    private static PsiExpression skipParensAndCastsDown(@Nullable PsiExpression element) {
        while (element instanceof PsiParenthesizedExpression || element instanceof PsiTypeCastExpression) {
            if (element instanceof PsiParenthesizedExpression) {
                element = ((PsiParenthesizedExpression)element).getExpression();
            }
            if (!(element instanceof PsiTypeCastExpression)) continue;
            element = ((PsiTypeCastExpression)element).getOperand();
        }
        return element;
    }

    private static Pair<PsiField, PsiType> isAssignedToField(@NotNull PsiReference ref, PsiClass containingClass) {
        PsiElement refElement = ref.getElement();
        PsiElement parent = BoundedWildcardInspection.skipParensAndCastsUp(refElement);
        if (!(parent instanceof PsiAssignmentExpression) || ((PsiAssignmentExpression)parent).getOperationTokenType() != JavaTokenType.EQ) {
            return null;
        }
        PsiExpression r = ((PsiAssignmentExpression)parent).getRExpression();
        if (!PsiTreeUtil.isAncestor((PsiElement)r, (PsiElement)refElement, (boolean)false)) {
            return null;
        }
        PsiExpression l = BoundedWildcardInspection.skipParensAndCastsDown(((PsiAssignmentExpression)parent).getLExpression());
        if (!(l instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression lExpression = (PsiReferenceExpression)l;
        PsiExpression lQualifier = BoundedWildcardInspection.skipParensAndCastsDown(lExpression.getQualifierExpression());
        if (lQualifier != null && !(lQualifier instanceof PsiThisExpression)) {
            return null;
        }
        PsiElement resolved = lExpression.resolve();
        if (!(resolved instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)resolved;
        if (!field.hasModifierProperty("private") && !field.hasModifierProperty("packageLocal")) {
            return null;
        }
        PsiType type2 = r.getType();
        if (type2 == null) {
            return null;
        }
        if (field.getContainingClass() != containingClass) {
            return null;
        }
        return Pair.createNonNull((Object)field, (Object)type2);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("bounded.wildcard.report.invariant.option", new Object[0]), "REPORT_INVARIANT_CLASSES");
        panel2.addCheckbox(InspectionGadgetsBundle.message("bounded.wildcard.report.private.option", new Object[0]), "REPORT_PRIVATE_METHODS");
        panel2.addCheckbox(InspectionGadgetsBundle.message("bounded.wildcard.report.instance.option", new Object[0]), "REPORT_INSTANCE_METHODS");
        return panel2;
    }

    private static class ReplaceWithQuestionTFix
    implements LocalQuickFix {
        private final boolean isOverriddenOrOverrides;
        private final boolean isExtends;

        ReplaceWithQuestionTFix(boolean isOverriddenOrOverrides, boolean isExtends) {
            this.isOverriddenOrOverrides = isOverriddenOrOverrides;
            this.isExtends = isExtends;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"? " + (this.isExtends ? "extends" : "super")});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiField field;
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiTypeElement && element.isValid() && element.getParent() != null && element.isPhysical())) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)element;
            VarianceCandidate candidate = VarianceCandidate.findVarianceCandidate(typeElement);
            if (candidate == null) {
                return;
            }
            PsiMethod method = candidate.method;
            PsiClassReferenceType clone = BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends);
            if (!this.isOverriddenOrOverrides) {
                PsiField field2 = BoundedWildcardInspection.findFieldAssignedFromMethodParameter(candidate.methodParameter, method);
                if (field2 != null) {
                    ReplaceWithQuestionTFix.replaceType(project, field2.getTypeElement(), (PsiType)BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends));
                }
                PsiTypeElement methodParameterTypeElement = candidate.methodParameter.getTypeElement();
                ReplaceWithQuestionTFix.replaceType(project, methodParameterTypeElement, (PsiType)clone);
                return;
            }
            int[] i = new int[]{0};
            List parameterInfos = ContainerUtil.map((Object[])method.getParameterList().getParameters(), p -> {
                int n = i[0];
                i[0] = n + 1;
                return ParameterInfoImpl.create(n).withName(p.getName()).withType(p.getType());
            });
            int index = method.getParameterList().getParameterIndex(candidate.methodParameter);
            if (index == -1) {
                return;
            }
            PsiMethod superMethod = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
            if (superMethod == null) {
                return;
            }
            if (superMethod != method) {
                method = superMethod;
                candidate = candidate.getSuperMethodVarianceCandidate(superMethod);
                clone = BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends);
                i[0] = 0;
                parameterInfos = ContainerUtil.map((Object[])superMethod.getParameterList().getParameters(), p -> {
                    int n = i[0];
                    i[0] = n + 1;
                    return ParameterInfoImpl.create(n).withName(p.getName()).withType(p.getType());
                });
            }
            parameterInfos.set(index, ParameterInfoImpl.create(index).withName(candidate.methodParameter.getName()).withType((PsiType)clone));
            JavaChangeSignatureDialog dialog = JavaChangeSignatureDialog.createAndPreselectNew(project, method, parameterInfos, false, null);
            dialog.setParameterInfos(parameterInfos);
            if (dialog.showAndGet() && (field = BoundedWildcardInspection.findFieldAssignedFromMethodParameter(candidate.methodParameter, method)) != null) {
                ReplaceWithQuestionTFix.replaceType(project, field.getTypeElement(), (PsiType)BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends));
            }
        }

        private static void replaceType(@NotNull Project project, @NotNull PsiTypeElement typeElement, @NotNull PsiType withType) {
            PsiElementFactory pf = PsiElementFactory.getInstance((Project)project);
            PsiTypeElement newTypeElement = pf.createTypeElement(withType);
            if (typeElement.isPhysical()) {
                WriteCommandAction.runWriteCommandAction((Project)project, () -> typeElement.replace((PsiElement)newTypeElement));
            } else {
                typeElement.replace((PsiElement)newTypeElement);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

