/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class CustomClassloaderInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("custom.classloader.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CustomClassloaderVisitor();
    }

    private static class CustomClassloaderVisitor
    extends BaseInspectionVisitor {
        private CustomClassloaderVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.ClassLoader")) {
                return;
            }
            if ("java.lang.ClassLoader".equals(aClass.getQualifiedName())) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

