/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceInspection
extends BaseInspection {
    public boolean insideTryAllowed;
    public boolean anyMethodMayClose = true;

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.defaultWriteSettings(node, "anyMethodMayClose");
        this.writeBooleanOption(node, "anyMethodMayClose", true);
    }

    @NotNull
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("allow.resource.to.be.opened.inside.a.try.block", new Object[0]), "insideTryAllowed");
        panel2.addCheckbox(InspectionGadgetsBundle.message("any.method.may.close.resource.argument", new Object[0]), "anyMethodMayClose");
        return panel2;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        PsiType type2 = expression2.getType();
        assert (type2 != null);
        String text2 = type2.getPresentableText();
        return InspectionGadgetsBundle.message("resource.opened.not.closed.problem.descriptor", text2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ResourceVisitor();
    }

    protected abstract boolean isResourceCreation(PsiExpression var1);

    protected boolean isResourceFactoryClosed(PsiExpression expression2) {
        return false;
    }

    @Nullable
    public static PsiVariable getVariable(@NotNull PsiExpression expression2) {
        PsiElement parent = ResourceInspection.getParent(expression2);
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement referent = referenceExpression.resolve();
            if (!(referent instanceof PsiVariable)) {
                return null;
            }
            return (PsiVariable)referent;
        }
        if (parent instanceof PsiVariable) {
            return (PsiVariable)parent;
        }
        if (parent instanceof PsiConditionalExpression) {
            return ResourceInspection.getVariable((PsiExpression)parent);
        }
        return null;
    }

    private static PsiElement getParent(PsiExpression expression2) {
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
        if (parent == null) {
            return null;
        }
        PsiElement grandParent = parent.getParent();
        PsiType type2 = expression2.getType();
        if (type2 == null) {
            return null;
        }
        while (parent instanceof PsiReferenceExpression && grandParent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            if (!type2.equals(methodCallExpression.getType())) {
                return null;
            }
            parent = ParenthesesUtils.getParentSkipParentheses(grandParent);
            if (parent == null) {
                return null;
            }
            grandParent = parent.getParent();
        }
        return parent;
    }

    private boolean isSafelyClosed(@Nullable PsiVariable variable, PsiElement context) {
        if (variable == null) {
            return false;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class);
        if (statement == null) {
            return false;
        }
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        if (this.insideTryAllowed) {
            PsiTryStatement tryStatement;
            PsiStatement parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiStatement.class);
            while (parentStatement != null && !(parentStatement instanceof PsiTryStatement)) {
                parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, PsiStatement.class);
            }
            if (parentStatement != null && this.isResourceClosedInFinally(tryStatement = (PsiTryStatement)parentStatement, variable)) {
                return true;
            }
        }
        while (nextStatement != null && !ResourceInspection.isSignificant(nextStatement)) {
            nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
        }
        while (nextStatement == null) {
            if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiStatement.class, (boolean)true)) == null) {
                return false;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement) {
                statement = (PsiStatement)parent;
            }
            nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        }
        if (!(nextStatement instanceof PsiTryStatement)) {
            return this.isResourceClose(nextStatement, variable);
        }
        PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
        if (this.isResourceClosedInFinally(tryStatement, variable)) {
            return true;
        }
        return this.isResourceClose(nextStatement, variable);
    }

    private static boolean isSignificant(@NotNull PsiStatement statement) {
        final Ref result = new Ref((Object)Boolean.TRUE);
        statement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                result.set((Object)Boolean.FALSE);
                this.stopWalking();
            }
        });
        return (Boolean)result.get() == false;
    }

    boolean isResourceClosedInFinally(@NotNull PsiTryStatement tryStatement, @NotNull PsiVariable variable) {
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        CloseVisitor visitor2 = new CloseVisitor(variable);
        finallyBlock.accept((PsiElementVisitor)visitor2);
        return visitor2.containsClose();
    }

    private boolean isResourceClose(PsiStatement statement, PsiVariable variable) {
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            return this.isResourceClose(methodCallExpression, variable);
        }
        if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (this.isResourceClose(ControlFlowUtils.getFirstStatementInBlock(tryBlock), variable)) {
                return true;
            }
        } else {
            if (statement instanceof PsiIfStatement) {
                PsiReferenceExpression referenceExpression;
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiExpression condition2 = ifStatement.getCondition();
                if (!(condition2 instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (JavaTokenType.NE != tokenType) {
                    return false;
                }
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    return false;
                }
                if (PsiType.NULL.equals((Object)lhs.getType())) {
                    if (!(rhs instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    referenceExpression = (PsiReferenceExpression)rhs;
                    PsiElement target = referenceExpression.resolve();
                    if (!variable.equals(target)) {
                        return false;
                    }
                } else if (PsiType.NULL.equals((Object)rhs.getType())) {
                    if (!(lhs instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    referenceExpression = (PsiReferenceExpression)lhs;
                    PsiElement target = referenceExpression.resolve();
                    if (!variable.equals(target)) {
                        return false;
                    }
                }
                PsiStatement thenBranch = ifStatement.getThenBranch();
                return this.isResourceClose(thenBranch, variable);
            }
            if (statement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                return this.isResourceClose(ControlFlowUtils.getFirstStatementInBlock(codeBlock), variable);
            }
        }
        return false;
    }

    protected boolean isResourceClose(PsiMethodCallExpression call, PsiVariable resource) {
        return MethodCallUtils.isMethodCallOnVariable(call, resource, "close");
    }

    boolean isResourceEscapingFromMethod(PsiVariable boundVariable, PsiExpression resourceCreationExpression) {
        PsiClass containingClass;
        PsiField field;
        String fieldName;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiMethodCallExpression methodCallExpression;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression2;
        if (resourceCreationExpression instanceof PsiMethodCallExpression && (qualifierExpression2 = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)resourceCreationExpression).getMethodExpression()).getQualifierExpression()) instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiField && ("out".equals(fieldName = (field = (PsiField)target).getName()) || "err".equals(fieldName)) && (containingClass = field.getContainingClass()) != null && "java.lang.System".equals(containingClass.getQualifiedName())) {
            return true;
        }
        PsiElement parent = ExpressionUtils.getPassThroughParent(resourceCreationExpression);
        if (parent instanceof PsiReturnStatement) {
            return true;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            if (PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getRExpression()) != resourceCreationExpression) {
                return true;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression());
            if (lhs instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)lhs).resolve()) instanceof PsiField) {
                return true;
            }
        } else if (parent instanceof PsiExpressionList) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiAnonymousClass) {
                grandParent = grandParent.getParent();
            }
            if (grandParent instanceof PsiCallExpression) {
                return this.anyMethodMayClose || this.isResourceCreation((PsiExpression)grandParent);
            }
        }
        if (boundVariable == null) {
            return false;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)resourceCreationExpression, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (codeBlock == null) {
            return false;
        }
        EscapeVisitor visitor2 = new EscapeVisitor(boundVariable);
        codeBlock.accept((PsiElementVisitor)visitor2);
        return visitor2.isEscaped();
    }

    private class EscapeVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable boundVariable;
        private boolean escaped;

        EscapeVisitor(PsiVariable boundVariable) {
            this.boundVariable = boundVariable;
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.escaped) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            super.visitReturnStatement(statement);
            PsiExpression value2 = PsiUtil.deparenthesizeExpression((PsiExpression)statement.getReturnValue());
            if (!(value2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value2;
            PsiElement target = referenceExpression.resolve();
            if (this.boundVariable.equals(target)) {
                this.escaped = true;
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            PsiExpression rhs = PsiUtil.deparenthesizeExpression((PsiExpression)expression2.getRExpression());
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)rhs;
            PsiElement target = referenceExpression.resolve();
            if (!this.boundVariable.equals(target)) {
                return;
            }
            PsiExpression lhs = PsiUtil.deparenthesizeExpression((PsiExpression)expression2.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression lReferenceExpression = (PsiReferenceExpression)lhs;
            PsiElement lTarget = lReferenceExpression.resolve();
            if (lTarget instanceof PsiField) {
                this.escaped = true;
            }
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            PsiExpression[] expressions2;
            if (!ResourceInspection.this.anyMethodMayClose && !ResourceInspection.this.isResourceCreation((PsiExpression)callExpression)) {
                return;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            for (PsiExpression argument : expressions2 = argumentList.getExpressions()) {
                PsiExpression returnedValue;
                PsiExpression maybeReferenceExpression = PsiUtil.deparenthesizeExpression((PsiExpression)argument);
                if (!(maybeReferenceExpression instanceof PsiReferenceExpression) || !ExpressionUtils.isReferenceTo(maybeReferenceExpression, this.boundVariable)) continue;
                if (callExpression instanceof PsiMethodCallExpression && (returnedValue = JavaMethodContractUtil.findReturnedValue((PsiMethodCallExpression)callExpression)) != null && returnedValue == maybeReferenceExpression) {
                    return;
                }
                this.escaped = true;
                break;
            }
        }

        public boolean isEscaped() {
            return this.escaped;
        }
    }

    private class CloseVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsClose;
        private final PsiVariable resource;
        private final String resourceName;

        private CloseVisitor(PsiVariable resource) {
            this.resource = resource;
            this.resourceName = resource.getName();
        }

        public void visitElement(@NotNull PsiElement element) {
            if (!this.containsClose) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (this.containsClose) {
                return;
            }
            super.visitMethodCallExpression(call);
            if (!ResourceInspection.this.isResourceClose(call, this.resource)) {
                return;
            }
            this.containsClose = true;
        }

        public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
            super.visitReferenceExpression(referenceExpression);
            if (this.containsClose) {
                return;
            }
            String text2 = referenceExpression.getText();
            if (text2 == null || !text2.equals(this.resourceName)) {
                return;
            }
            PsiElement parent = referenceExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiExpressionList argumentList = (PsiExpressionList)parent;
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null || !methodName.contains("close")) {
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (target == null || !target.equals(this.resource)) {
                return;
            }
            this.containsClose = true;
        }

        private boolean containsClose() {
            return this.containsClose;
        }
    }

    private class ResourceVisitor
    extends BaseInspectionVisitor {
        private ResourceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!this.isNotSafelyClosedResource((PsiExpression)expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (!this.isNotSafelyClosedResource((PsiExpression)expression2)) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2);
        }

        private boolean isNotSafelyClosedResource(PsiExpression expression2) {
            if (!ResourceInspection.this.isResourceCreation(expression2)) {
                return false;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(expression2);
            return !(boundVariable instanceof PsiResourceVariable) && !ResourceInspection.this.isSafelyClosed(boundVariable, (PsiElement)expression2) && !ResourceInspection.this.isResourceFactoryClosed(expression2) && !ResourceInspection.this.isResourceEscapingFromMethod(boundVariable, expression2);
        }
    }
}

