/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import com.siyeh.ig.ui.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class IOResourceInspection
extends ResourceInspection {
    protected static final String[] IO_TYPES = new String[]{"java.io.InputStream", "java.io.OutputStream", "java.io.Reader", "java.io.Writer", "java.io.RandomAccessFile", "java.util.zip.ZipFile", "java.io.Closeable"};
    final List<String> ignoredTypes = new ArrayList<String>();
    public String ignoredTypesString = "java.io.ByteArrayOutputStream,java.io.ByteArrayInputStream,java.io.StringBufferInputStream,java.io.CharArrayWriter,java.io.CharArrayReader,java.io.StringWriter,java.io.StringReader";

    public IOResourceInspection() {
        IOResourceInspection.parseString(this.ignoredTypesString, this.ignoredTypes);
    }

    @Override
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        ListTable table = new ListTable(new ListWrappingTableModel(this.ignoredTypes, InspectionGadgetsBundle.message("ignored.io.resource.types", new Object[0])));
        JPanel tablePanel = UiUtils.createAddRemoveTreeClassChooserPanel(table, InspectionGadgetsBundle.message("choose.io.resource.type.to.ignore", new Object[0]), IO_TYPES);
        panel2.add((Component)tablePanel, "Center");
        panel2.add((Component)super.createOptionsPanel(), "South");
        return panel2;
    }

    @NotNull
    public String getID() {
        return "IOResourceOpenedButNotSafelyClosed";
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        IOResourceInspection.parseString(this.ignoredTypesString, this.ignoredTypes);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.ignoredTypesString = IOResourceInspection.formatString(this.ignoredTypes);
        super.writeSettings(element);
    }

    @Override
    public boolean isResourceCreation(PsiExpression expression2) {
        if (expression2 instanceof PsiNewExpression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression2, IO_TYPES) != null && !this.isIgnoredType(expression2);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getResourceAsStream".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.Class", "java.lang.ClassLoader") == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(expression2, "java.io.InputStream");
        }
        return false;
    }

    private boolean isIgnoredType(PsiExpression expression2) {
        return TypeUtils.expressionHasTypeOrSubtype(expression2, this.ignoredTypes);
    }
}

