/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryStringEscapeInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean reportChars = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.string.escape.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inspection.unnecessary.string.escape.report.char.literals.option", new Object[0]), (InspectionProfileEntry)this, "reportChars");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String expressionText = (String)infos[0];
        return new UnnecessaryStringEscapeFix(expressionText);
    }

    static int findUnnecessarilyEscapedChars(String text2, int start) {
        boolean slash = false;
        int doubleQuotes = 0;
        int max = text2.length() - 3;
        for (int i = start; i < max; ++i) {
            char ch = text2.charAt(i);
            if (ch == '\\') {
                slash = !slash;
                continue;
            }
            if (slash) {
                if (ch == 'n' || ch == '\'') {
                    return i - 1;
                }
                if (ch == '\"' && doubleQuotes < 2) {
                    if (i == max - 1) {
                        return -1;
                    }
                    if (i == max - 2) {
                        return i - 1;
                    }
                    if (i < max - 2 && text2.charAt(i + 1) == '\"') {
                        if (doubleQuotes != 1 && text2.charAt(i + 2) != '\"') {
                            return i - 1;
                        }
                    } else {
                        return i - 1;
                    }
                }
                doubleQuotes = 0;
            } else {
                doubleQuotes = ch == '\"' ? ++doubleQuotes : 0;
            }
            slash = false;
        }
        return -1;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantStringEscapeVisitor();
    }

    private class RedundantStringEscapeVisitor
    extends BaseInspectionVisitor {
        private RedundantStringEscapeVisitor() {
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            String text2;
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            HighlightInfo parsingError = HighlightUtil.checkLiteralExpressionParsingError(expression2, PsiUtil.getLanguageLevel((PsiElement)expression2), null);
            if (parsingError != null) {
                return;
            }
            if (type2.equalsToText("java.lang.String")) {
                if (expression2.isTextBlock()) {
                    String text3 = expression2.getText();
                    int start = UnnecessaryStringEscapeInspection.findUnnecessarilyEscapedChars(text3, 4);
                    while (start >= 0) {
                        this.registerErrorAtOffset((PsiElement)expression2, start, 2, text3);
                        start = UnnecessaryStringEscapeInspection.findUnnecessarilyEscapedChars(text3, start + 2);
                    }
                } else {
                    String text4 = expression2.getText();
                    boolean slash = false;
                    int max = text4.length() - 1;
                    for (int i = 1; i < max; ++i) {
                        char c = text4.charAt(i);
                        if (slash) {
                            slash = false;
                            if (c != '\'') continue;
                            this.registerErrorAtOffset((PsiElement)expression2, i - 1, 2, text4);
                            continue;
                        }
                        if (c != '\\') continue;
                        slash = true;
                    }
                }
            } else if (UnnecessaryStringEscapeInspection.this.reportChars && PsiType.CHAR.equals((Object)type2) && "'\\\"'".equals(text2 = expression2.getText())) {
                this.registerErrorAtOffset((PsiElement)expression2, 1, 2, text2);
            }
        }
    }

    private static class UnnecessaryStringEscapeFix
    extends InspectionGadgetsFix {
        private final String myText;

        UnnecessaryStringEscapeFix(String text2) {
            this.myText = text2;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.string.escape.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            PsiType type2 = literalExpression.getType();
            if (type2 == null) {
                return;
            }
            String text2 = literalExpression.getText();
            if (!this.myText.equals(text2)) {
                return;
            }
            if (type2.equalsToText("java.lang.String")) {
                StringBuilder newExpression = new StringBuilder();
                if (literalExpression.isTextBlock()) {
                    int offset = 0;
                    int start = UnnecessaryStringEscapeInspection.findUnnecessarilyEscapedChars(text2, 4);
                    while (start >= 0) {
                        newExpression.append(text2, offset, start);
                        offset = start + 2;
                        String escape = text2.substring(start, offset);
                        if ("\\n".equals(escape)) {
                            int indent = PsiLiteralUtil.getTextBlockIndent((PsiLiteralExpression)literalExpression);
                            if (indent < 0) {
                                return;
                            }
                            newExpression.append('\n').append(StringUtil.repeatSymbol((char)' ', (int)indent));
                        } else {
                            newExpression.append(escape.charAt(1));
                        }
                        start = UnnecessaryStringEscapeInspection.findUnnecessarilyEscapedChars(text2, offset);
                    }
                    newExpression.append(text2.substring(offset));
                } else {
                    boolean escaped = false;
                    int length = text2.length();
                    for (int i = 0; i < length; ++i) {
                        char c = text2.charAt(i);
                        if (escaped) {
                            if (c != '\'') {
                                newExpression.append('\\');
                            }
                            newExpression.append(c);
                            escaped = false;
                            continue;
                        }
                        if (c == '\\') {
                            escaped = true;
                            continue;
                        }
                        newExpression.append(c);
                    }
                }
                PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, newExpression.toString());
            } else if (PsiType.CHAR.equals((Object)type2) && text2.equals("'\\\"'")) {
                PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, "'\"'");
            }
        }
    }
}

