/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class RedundantStringOperationInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final CallMatcher STRING_TO_STRING = CallMatcher.exactInstanceCall("java.lang.String", "toString").parameterCount(0);
    private static final CallMatcher STRING_INTERN = CallMatcher.exactInstanceCall("java.lang.String", "intern").parameterCount(0);
    private static final CallMatcher STRING_LENGTH = CallMatcher.exactInstanceCall("java.lang.String", "length").parameterCount(0);
    private static final CallMatcher STRING_SUBSTRING_ONE_ARG = CallMatcher.exactInstanceCall("java.lang.String", "substring").parameterTypes("int");
    private static final CallMatcher STRING_SUBSTRING_TWO_ARG = CallMatcher.exactInstanceCall("java.lang.String", "substring").parameterTypes("int", "int");
    private static final CallMatcher STRING_SUBSTRING = CallMatcher.anyOf(STRING_SUBSTRING_ONE_ARG, STRING_SUBSTRING_TWO_ARG);
    private static final CallMatcher STRING_BUILDER_APPEND = CallMatcher.instanceCall("java.lang.AbstractStringBuilder", "append").parameterTypes("java.lang.String");
    private static final CallMatcher STRING_BUILDER_TO_STRING = CallMatcher.instanceCall("java.lang.StringBuilder", "toString").parameterCount(0);
    private static final CallMatcher PRINTSTREAM_PRINTLN = CallMatcher.instanceCall("java.io.PrintStream", "println").parameterTypes("java.lang.String");
    private static final CallMatcher METHOD_WITH_REDUNDANT_ZERO_AS_SECOND_PARAMETER = CallMatcher.exactInstanceCall("java.lang.String", "indexOf", "startsWith").parameterCount(2);
    private static final CallMatcher STRING_LAST_INDEX_OF = CallMatcher.exactInstanceCall("java.lang.String", "lastIndexOf").parameterCount(2);
    private static final CallMatcher STRING_IS_EMPTY = CallMatcher.exactInstanceCall("java.lang.String", "isEmpty").parameterCount(0);
    private static final CallMatcher CASE_CHANGE = CallMatcher.exactInstanceCall("java.lang.String", "toUpperCase", "toLowerCase");
    private static final CallMatcher STRING_EQUALS = CallMatcher.exactInstanceCall("java.lang.String", "equals").parameterTypes("java.lang.Object");
    public boolean ignoreStringConstructor = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inspection.redundant.string.option.do.not.report.string.constructors", new Object[0]), (InspectionProfileEntry)this, "ignoreStringConstructor");
    }

    @NotNull
    public String getShortName() {
        return "StringOperationCanBeSimplified";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new RedundantStringOperationVisitor(holder, isOnTheFly, this);
    }

    static /* synthetic */ CallMatcher access$000() {
        return STRING_EQUALS;
    }

    static /* synthetic */ CallMatcher access$100() {
        return STRING_IS_EMPTY;
    }

    static /* synthetic */ CallMatcher access$200() {
        return STRING_LAST_INDEX_OF;
    }

    static /* synthetic */ CallMatcher access$300() {
        return METHOD_WITH_REDUNDANT_ZERO_AS_SECOND_PARAMETER;
    }

    static /* synthetic */ CallMatcher access$400() {
        return PRINTSTREAM_PRINTLN;
    }

    static /* synthetic */ CallMatcher access$500() {
        return STRING_INTERN;
    }

    static /* synthetic */ CallMatcher access$600() {
        return STRING_BUILDER_TO_STRING;
    }

    static /* synthetic */ CallMatcher access$900() {
        return STRING_TO_STRING;
    }

    private static class StringConstructorFix
    extends InspectionGadgetsFix {
        private final String myName;

        private StringConstructorFix(boolean noArguments) {
            this.myName = noArguments ? InspectionGadgetsBundle.message("inspection.redundant.string.replace.with.empty.fix.name", new Object[0]) : InspectionGadgetsBundle.message("inspection.redundant.string.replace.with.arg.fix.name", new Object[0]);
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiNewExpression expression2 = (PsiNewExpression)descriptor.getPsiElement();
            PsiExpressionList argList = expression2.getArgumentList();
            assert (argList != null);
            PsiExpression[] args = argList.getExpressions();
            CommentTracker commentTracker = new CommentTracker();
            String argText = args.length == 1 ? commentTracker.text((PsiElement)args[0]) : "\"\"";
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, argText, commentTracker);
        }
    }

    private static class RemoveRedundantStringCallFix
    implements LocalQuickFix {
        private final FixType myFixType;
        private final String myToRemove;

        RemoveRedundantStringCallFix(String toRemove2, FixType fixType) {
            this.myToRemove = toRemove2;
            this.myFixType = fixType;
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("inspection.redundant.string.remove.fix.name", this.myToRemove);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("inspection.redundant.string.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)descriptor.getStartElement(), (Class[])new Class[]{PsiMethodCallExpression.class});
            if (call == null) {
                return;
            }
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression());
            if (qualifier == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            switch (this.myFixType) {
                case REPLACE_WITH_QUALIFIER: {
                    PsiExpression result = (PsiExpression)ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
                    if (!(result.getParent() instanceof PsiExpressionStatement)) break;
                    RemoveRedundantStringCallFix.extractSideEffects(result, (PsiStatement)((PsiExpressionStatement)result.getParent()));
                    break;
                }
                case REPLACE_WITH_ARGUMENTS: {
                    PsiExpressionList list = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiExpressionList.class);
                    if (list == null) {
                        return;
                    }
                    for (PsiExpression arg : call.getArgumentList().getExpressions()) {
                        list.add((PsiElement)ct.markUnchanged(arg));
                    }
                    ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
                }
            }
        }

        private static void extractSideEffects(PsiExpression result, PsiStatement statement) {
            List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(result);
            if (Objects.equals(Collections.singletonList(result), sideEffects)) {
                return;
            }
            PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, result);
            if (statements.length > 0) {
                PsiStatement lastAdded = BlockUtils.addBefore(statement, statements);
                statement = (PsiStatement)Objects.requireNonNull(PsiTreeUtil.getNextSiblingOfType((PsiElement)lastAdded, PsiStatement.class));
            }
            statement.delete();
        }
    }

    private static class RemoveRedundantSubstringFix
    implements LocalQuickFix {
        @NotNull
        private final String myBindCallName;

        RemoveRedundantSubstringFix(@NotNull String bindCallName) {
            this.myBindCallName = bindCallName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("remove.redundant.substring.fix.text", this.myBindCallName);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("remove.redundant.substring.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression substringCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (substringCall == null) {
                return;
            }
            PsiExpression stringExpr = substringCall.getMethodExpression().getQualifierExpression();
            if (stringExpr == null) {
                return;
            }
            PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)substringCall);
            if (nextCall == null) {
                return;
            }
            PsiExpression[] args = substringCall.getArgumentList().getExpressions();
            if (args.length == 0) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            if (!"endsWith".equals(this.myBindCallName) && !ExpressionUtils.isZero(args[0])) {
                nextCall.getArgumentList().add((PsiElement)ct.markUnchanged(args[0]));
            }
            ExpressionUtils.bindCallTo(nextCall, this.myBindCallName);
            ct.replaceAndRestoreComments((PsiElement)substringCall, (PsiElement)stringExpr);
        }
    }

    private static class RedundantStringOperationVisitor
    extends JavaElementVisitor {
        private final CallMapper<ProblemDescriptor> myProcessors = new CallMapper<Function<PsiMethodCallExpression, ProblemDescriptor>>().register(RedundantStringOperationInspection.access$900(), call -> this.getProblem((PsiMethodCallExpression)call, "inspection.redundant.string.call.message")).register(RedundantStringOperationInspection.access$800(), this::getSubstringProblem).register(RedundantStringOperationInspection.access$700(), this::getAppendProblem).register(RedundantStringOperationInspection.access$600(), this::getRedundantStringBuilderToStringProblem).register(RedundantStringOperationInspection.access$500(), this::getInternProblem).register(RedundantStringOperationInspection.access$400(), call -> this.getRedundantArgumentProblem(RedundantStringOperationVisitor.getSingleEmptyStringArgument((PsiCall)call))).register(RedundantStringOperationInspection.access$300(), this::getRedundantZeroAsSecondParameterProblem).register(RedundantStringOperationInspection.access$200(), this::getLastIndexOfProblem).register(RedundantStringOperationInspection.access$100(), this::getRedundantCaseChangeProblem).register(RedundantStringOperationInspection.access$000(), this::getRedundantSubstringEqualsProblem);
        private final InspectionManager myManager;
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;
        private final RedundantStringOperationInspection myInspection;

        RedundantStringOperationVisitor(ProblemsHolder holder, boolean isOnTheFly, RedundantStringOperationInspection inspection) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
            this.myInspection = inspection;
            this.myManager = this.myHolder.getManager();
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            this.myProcessors.mapAll(call).forEach(arg_0 -> ((ProblemsHolder)this.myHolder).registerProblem(arg_0));
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            PsiJavaCodeReferenceElement classRef = expression2.getClassReference();
            ProblemDescriptor descriptor = null;
            if (ConstructionUtils.isReferenceTo(classRef, "java.lang.StringBuilder", "java.lang.StringBuffer")) {
                descriptor = this.getRedundantArgumentProblem(RedundantStringOperationVisitor.getSingleEmptyStringArgument((PsiCall)expression2));
            } else if (ConstructionUtils.isReferenceTo(classRef, "java.lang.String") && !this.myInspection.ignoreStringConstructor) {
                descriptor = this.getStringConstructorProblem(expression2);
            }
            if (descriptor != null) {
                this.myHolder.registerProblem(descriptor);
            }
        }

        private ProblemDescriptor getStringConstructorProblem(PsiNewExpression expression2) {
            PsiExpression arg;
            PsiExpressionList args = expression2.getArgumentList();
            if (args == null) {
                return null;
            }
            if (args.isEmpty()) {
                LocalQuickFix[] fixes = new LocalQuickFix[]{new StringConstructorFix(true), new SetInspectionOptionFix((LocalInspectionTool)this.myInspection, "ignoreStringConstructor", InspectionGadgetsBundle.message("inspection.redundant.string.option.do.not.report.string.constructors", new Object[0]), true)};
                return this.myManager.createProblemDescriptor((PsiElement)expression2, (TextRange)null, InspectionGadgetsBundle.message("inspection.redundant.string.constructor.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myIsOnTheFly, fixes);
            }
            if (args.getExpressionCount() == 1 && TypeUtils.isJavaLangString((arg = args.getExpressions()[0]).getType()) && (PsiUtil.isLanguageLevel7OrHigher((PsiElement)expression2) || !STRING_SUBSTRING.matches(arg))) {
                TextRange range = new TextRange(0, args.getStartOffsetInParent());
                LocalQuickFix[] fixes = new LocalQuickFix[]{new StringConstructorFix(false), new SetInspectionOptionFix((LocalInspectionTool)this.myInspection, "ignoreStringConstructor", InspectionGadgetsBundle.message("inspection.redundant.string.option.do.not.report.string.constructors", new Object[0]), true)};
                return this.myManager.createProblemDescriptor((PsiElement)expression2, range, InspectionGadgetsBundle.message("inspection.redundant.string.constructor.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.myIsOnTheFly, fixes);
            }
            return null;
        }

        private ProblemDescriptor getRedundantSubstringEqualsProblem(PsiMethodCallExpression call) {
            PsiElement anchor;
            PsiExpression to;
            PsiExpression from;
            boolean lengthMatches;
            PsiElement anchor2;
            PsiExpression[] args;
            PsiExpression equalTo;
            boolean lengthMatches2;
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
            if (qualifierCall == null) {
                return null;
            }
            PsiExpression receiver2 = qualifierCall.getMethodExpression().getQualifierExpression();
            if (receiver2 == null) {
                return null;
            }
            if (STRING_SUBSTRING_TWO_ARG.test(qualifierCall) && (lengthMatches2 = this.lengthMatches(equalTo = call.getArgumentList().getExpressions()[0], (args = qualifierCall.getArgumentList().getExpressions())[0], args[1])) && (anchor2 = qualifierCall.getMethodExpression().getReferenceNameElement()) != null) {
                Object equalsValue;
                if (equalTo instanceof PsiLiteralExpression && (equalsValue = ((PsiLiteralExpression)equalTo).getValue()) instanceof String && StringUtil.length((CharSequence)((String)equalsValue)) == 1) {
                    return this.createSubstringToCharAtProblemDescriptor(call);
                }
                return this.myManager.createProblemDescriptor(anchor2, (TextRange)null, InspectionGadgetsBundle.message("inspection.redundant.string.call.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.myIsOnTheFly, new LocalQuickFix[]{new RemoveRedundantSubstringFix("startsWith")});
            }
            if (STRING_SUBSTRING_ONE_ARG.test(qualifierCall) && (lengthMatches = this.lengthMatches(equalTo = call.getArgumentList().getExpressions()[0], from = qualifierCall.getArgumentList().getExpressions()[0], to = RedundantStringOperationVisitor.getLengthExpression(receiver2, JavaPsiFacade.getElementFactory((Project)this.myHolder.getProject())))) && (anchor = qualifierCall.getMethodExpression().getReferenceNameElement()) != null) {
                return this.myManager.createProblemDescriptor(anchor, (TextRange)null, InspectionGadgetsBundle.message("inspection.redundant.string.call.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.myIsOnTheFly, new LocalQuickFix[]{new RemoveRedundantSubstringFix("endsWith")});
            }
            return null;
        }

        @NotNull
        private ProblemDescriptor createSubstringToCharAtProblemDescriptor(@NotNull PsiMethodCallExpression call) {
            String converted = SubstringEqualsToCharAtEqualsQuickFix.getTargetString(call, PsiElement::getText);
            assert (converted != null) : "Message cannot be null";
            PsiExpression outermostEqualsExpr = RedundantStringOperationVisitor.getOutermostEquals((PsiExpression)call);
            SubstringEqualsToCharAtEqualsQuickFix fix = new SubstringEqualsToCharAtEqualsQuickFix(outermostEqualsExpr.getText(), converted);
            return this.myManager.createProblemDescriptor((PsiElement)outermostEqualsExpr, InspectionGadgetsBundle.message("inspection.x.call.can.be.replaced.with.y", "substring()", "charAt()"), (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myIsOnTheFly);
        }

        private static boolean isNegated(@NotNull PsiExpression start, boolean negated) {
            PsiExpression negation = BoolUtils.findNegation(start);
            if (negation == null) {
                return negated;
            }
            return RedundantStringOperationVisitor.isNegated(negation, !negated);
        }

        private static PsiExpression getOutermostEquals(@NotNull PsiExpression start) {
            PsiExpression negation = BoolUtils.findNegation(start);
            if (negation == null) {
                return start;
            }
            return RedundantStringOperationVisitor.getOutermostEquals(negation);
        }

        private boolean lengthMatches(PsiExpression equalTo, PsiExpression from, PsiExpression to) {
            PsiExpression lengthExpression;
            String str = (String)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(equalTo), String.class);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myHolder.getProject());
            if (str != null && ExpressionUtils.isDifference(from, to, lengthExpression = factory.createExpressionFromText(String.valueOf(str.length()), (PsiElement)equalTo))) {
                return true;
            }
            lengthExpression = RedundantStringOperationVisitor.getLengthExpression(equalTo, factory);
            return ExpressionUtils.isDifference(from, to, lengthExpression);
        }

        private static PsiExpression getLengthExpression(PsiExpression string, PsiElementFactory factory) {
            return factory.createExpressionFromText(ParenthesesUtils.getText(string, 1) + ".length()", (PsiElement)string);
        }

        @Nullable
        private ProblemDescriptor getRedundantCaseChangeProblem(PsiMethodCallExpression call) {
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
            if (CASE_CHANGE.test(qualifierCall)) {
                return this.getProblem(qualifierCall, "inspection.redundant.string.call.message");
            }
            return null;
        }

        @Nullable
        private ProblemDescriptor getAppendProblem(PsiMethodCallExpression call) {
            return RedundantStringOperationVisitor.getSingleEmptyStringArgument((PsiCall)call) != null ? this.getProblem(call, "inspection.redundant.string.call.message") : null;
        }

        @Nullable
        private ProblemDescriptor getRedundantStringBuilderToStringProblem(@NotNull PsiMethodCallExpression call) {
            PsiMethodCallExpression substringCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethodCallExpression.class);
            if (substringCall == null) {
                return null;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)substringCall.getMethodExpression().getQualifierExpression());
            if (qualifier != call || !STRING_SUBSTRING.test(substringCall)) {
                return null;
            }
            return this.getProblem(call, "inspection.redundant.string.call.message");
        }

        @Nullable
        private ProblemDescriptor getInternProblem(PsiMethodCallExpression call) {
            return PsiUtil.isConstantExpression((PsiExpression)call.getMethodExpression().getQualifierExpression()) ? this.getProblem(call, "inspection.redundant.string.intern.on.constant.message") : null;
        }

        @Nullable
        private ProblemDescriptor getLastIndexOfProblem(PsiMethodCallExpression call) {
            PsiBinaryExpression binOp;
            PsiExpression secondArg = call.getArgumentList().getExpressions()[1];
            PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)secondArg);
            if (stripped instanceof PsiBinaryExpression && (binOp = (PsiBinaryExpression)stripped).getOperationTokenType() == JavaTokenType.MINUS && ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand()), 1)) {
                stripped = binOp.getLOperand();
            }
            return RedundantStringOperationVisitor.isLengthOf(stripped, call.getMethodExpression().getQualifierExpression()) ? this.getRedundantArgumentProblem(secondArg) : null;
        }

        @Nullable
        private ProblemDescriptor getRedundantZeroAsSecondParameterProblem(PsiMethodCallExpression call) {
            PsiExpression secondArg = call.getArgumentList().getExpressions()[1];
            if (ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)secondArg), 0)) {
                return this.getRedundantArgumentProblem(secondArg);
            }
            return null;
        }

        @Nullable
        private ProblemDescriptor getRedundantArgumentProblem(@Nullable PsiExpression argument) {
            if (argument == null) {
                return null;
            }
            DeleteElementFix fix = new DeleteElementFix((PsiElement)argument, InspectionGadgetsBundle.message("inspection.redundant.string.remove.argument.fix.name", new Object[0]));
            return this.myManager.createProblemDescriptor((PsiElement)argument, InspectionGadgetsBundle.message("inspection.redundant.string.argument.message", new Object[0]), this.myIsOnTheFly, new LocalQuickFix[]{fix}, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
        }

        @Nullable
        private static PsiExpression getSingleEmptyStringArgument(PsiCall call) {
            PsiExpressionList argList = call.getArgumentList();
            if (argList == null) {
                return null;
            }
            PsiExpression[] args = argList.getExpressions();
            if (args.length != 1) {
                return null;
            }
            return ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), "") ? args[0] : null;
        }

        @Nullable
        private ProblemDescriptor getSubstringProblem(PsiMethodCallExpression call) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression stringExpression = call.getMethodExpression().getQualifierExpression();
            if (args.length == 1) {
                return ExpressionUtils.isZero(args[0]) ? this.getProblem(call, "inspection.redundant.string.call.message") : null;
            }
            if (RedundantStringOperationVisitor.isLengthOf(args[1], stringExpression)) {
                if (ExpressionUtils.isZero(args[0])) {
                    return this.getProblem(call, "inspection.redundant.string.call.message");
                }
                DeleteElementFix fix = new DeleteElementFix((PsiElement)args[1], InspectionGadgetsBundle.message("inspection.redundant.string.remove.argument.fix.name", new Object[0]));
                return this.myManager.createProblemDescriptor((PsiElement)args[1], InspectionGadgetsBundle.message("inspection.redundant.string.call.message", new Object[0]), (LocalQuickFix)fix, ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.myIsOnTheFly);
            }
            boolean betterWithCharAt = RedundantStringOperationVisitor.isBetterWithCharAt(call);
            if (betterWithCharAt) {
                PsiElement substring = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                String converted = String.format("%s.charAt(%s)", Objects.requireNonNull(stringExpression).getText(), args[0].getText());
                SubstringToCharAtQuickFix fix = new SubstringToCharAtQuickFix(call.getText(), converted);
                TextRange textRange = new TextRange(substring.getStartOffsetInParent(), substring.getStartOffsetInParent() + substring.getTextLength());
                return this.myManager.createProblemDescriptor((PsiElement)call, textRange, CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{call.getText(), converted}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myIsOnTheFly, new LocalQuickFix[]{fix});
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
            if (parent instanceof PsiExpressionList && ((PsiExpressionList)parent).getExpressionCount() == 1) {
                PsiMethodCallExpression parentCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
                if (STRING_BUILDER_APPEND.test(parentCall)) {
                    PsiElement nameElement = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                    return this.myManager.createProblemDescriptor(nameElement, InspectionGadgetsBundle.message("inspection.redundant.string.call.message", new Object[0]), (LocalQuickFix)new RemoveRedundantStringCallFix(nameElement.getText(), FixType.REPLACE_WITH_ARGUMENTS), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.myIsOnTheFly);
                }
            }
            return null;
        }

        private static boolean isBetterWithCharAt(@NotNull PsiMethodCallExpression call) {
            PsiElementFactory factory;
            PsiExpression one;
            PsiExpression[] args = call.getArgumentList().getExpressions();
            boolean diffByOne = ExpressionUtils.isDifference(args[0], args[1], one = (factory = JavaPsiFacade.getElementFactory((Project)call.getProject())).createExpressionFromText("1", null));
            if (!diffByOne) {
                return false;
            }
            return !ExpressionUtils.isConversionToStringNecessary((PsiExpression)call, false);
        }

        private static boolean isLengthOf(PsiExpression stringLengthCandidate, PsiExpression stringExpression) {
            PsiMethodCallExpression argCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)stringLengthCandidate), PsiMethodCallExpression.class);
            return STRING_LENGTH.test(argCall) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(stringExpression, argCall.getMethodExpression().getQualifierExpression());
        }

        @NotNull
        private ProblemDescriptor getProblem(PsiMethodCallExpression call, @NotNull @PropertyKey(resourceBundle="messages.InspectionGadgetsBundle") String key2) {
            String name2 = call.getMethodExpression().getReferenceName();
            return this.myManager.createProblemDescriptor((PsiElement)call, RedundantStringOperationVisitor.getRange(call), InspectionGadgetsBundle.message(key2, new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.myIsOnTheFly, new LocalQuickFix[]{new RemoveRedundantStringCallFix(name2, FixType.REPLACE_WITH_QUALIFIER)});
        }

        @NotNull
        private static TextRange getRange(PsiMethodCallExpression call) {
            PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
            if (nameElement != null) {
                TextRange callRange = call.getTextRange();
                return new TextRange(nameElement.getTextRange().getStartOffset(), callRange.getEndOffset()).shiftLeft(callRange.getStartOffset());
            }
            return call.getTextRange();
        }

        private static class SubstringEqualsToCharAtEqualsQuickFix
        implements LocalQuickFix {
            @NotNull
            private final String myText;
            @NotNull
            private final String myConverted;

            SubstringEqualsToCharAtEqualsQuickFix(@NotNull String text2, @NotNull String converted) {
                this.myText = text2;
                this.myConverted = converted;
            }

            public @IntentionName @NotNull String getName() {
                return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.myText, this.myConverted});
            }

            public @IntentionFamilyName @NotNull String getFamilyName() {
                return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"substring()", "charAt()"});
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement element = descriptor.getPsiElement();
                if (element == null) {
                    return;
                }
                PsiMethodCallExpression call = element instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)element : (PsiMethodCallExpression)PsiTreeUtil.findChildOfType((PsiElement)element, PsiMethodCallExpression.class);
                if (call == null) {
                    return;
                }
                CommentTracker ct = new CommentTracker();
                String convertTo = SubstringEqualsToCharAtEqualsQuickFix.getTargetString(call, ct::text);
                if (convertTo == null) {
                    return;
                }
                ct.replaceAndRestoreComments(element, convertTo);
            }

            @Nullable
            private static String getTargetString(@NotNull PsiMethodCallExpression call, @NotNull @NotNull Function<@NotNull PsiElement, @NotNull String> textExtractor) {
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
                if (qualifierCall == null) {
                    return null;
                }
                PsiExpression receiver2 = qualifierCall.getMethodExpression().getQualifierExpression();
                if (receiver2 == null) {
                    return null;
                }
                PsiExpression[] args = qualifierCall.getArgumentList().getExpressions();
                if (args.length != 2) {
                    return null;
                }
                PsiExpression equalTo = call.getArgumentList().getExpressions()[0];
                String eqSign = RedundantStringOperationVisitor.isNegated((PsiExpression)call, false) ? "!=" : "==";
                String equalToValue = PsiLiteralUtil.charLiteralForCharString((String)textExtractor.apply((PsiElement)equalTo));
                return String.format("%s.charAt(%s) %s %s", textExtractor.apply((PsiElement)receiver2), textExtractor.apply((PsiElement)args[0]), eqSign, equalToValue);
            }
        }

        private static class SubstringToCharAtQuickFix
        implements LocalQuickFix {
            @NotNull
            private final String myText;
            @NotNull
            private final String myConverted;

            SubstringToCharAtQuickFix(@NotNull String text2, @NotNull String converted) {
                this.myText = text2;
                this.myConverted = converted;
            }

            public @IntentionName @NotNull String getName() {
                return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.myText, this.myConverted});
            }

            public @IntentionFamilyName @NotNull String getFamilyName() {
                return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"substring()", "charAt()"});
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiMethodCallExpression.class);
                if (call == null) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length != 2) {
                    return;
                }
                ExpressionUtils.bindCallTo(call, "charAt");
                new CommentTracker().deleteAndRestoreComments((PsiElement)args[1]);
            }
        }
    }

    static enum FixType {
        REPLACE_WITH_QUALIFIER,
        REPLACE_WITH_ARGUMENTS;

    }
}

