/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiVariable;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariablePassedAsArgumentExcludedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private final Processor<? super PsiCall> myCallProcessor;
    private final boolean myBuilderPattern;
    private boolean passed;

    VariablePassedAsArgumentExcludedVisitor(@NotNull PsiVariable variable, boolean builderPattern, @NotNull Processor<? super PsiCall> callProcessor) {
        this.variable = variable;
        this.myCallProcessor = callProcessor;
        this.myBuilderPattern = builderPattern;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (this.passed) {
            return;
        }
        super.visitElement(element);
    }

    public void visitCallExpression(PsiCallExpression callExpression) {
        if (this.passed) {
            return;
        }
        super.visitCallExpression(callExpression);
        this.visitCall((PsiCall)callExpression);
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (this.passed) {
            return;
        }
        super.visitEnumConstant(enumConstant);
        this.visitCall((PsiCall)enumConstant);
    }

    private void visitCall(PsiCall call) {
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : argumentList.getExpressions()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable, this.myBuilderPattern) || this.myCallProcessor.process((Object)call)) continue;
            this.passed = true;
            break;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }
}

