/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceOfUtils {
    private InstanceOfUtils() {
    }

    public static PsiInstanceOfExpression getConflictingInstanceof(PsiType castType, PsiReferenceExpression operand2, PsiElement context) {
        if (!(castType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)castType;
        if (((PsiClassType)castType).resolve() instanceof PsiTypeParameter) {
            return null;
        }
        PsiClassType rawType = classType.rawType();
        InstanceofChecker checker = new InstanceofChecker(operand2, (PsiType)rawType, false);
        PsiStatement sibling = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class);
        sibling = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, PsiStatement.class);
        while (sibling != null) {
            PsiMethodCallExpression call;
            PsiExpression condition2;
            if (sibling instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)sibling;
                condition2 = ifStatement.getCondition();
                if (condition2 != null) {
                    if (!ControlFlowUtils.statementMayCompleteNormally(ifStatement.getThenBranch())) {
                        checker.negate = true;
                        checker.checkExpression(condition2);
                        if (checker.hasAgreeingInstanceof()) {
                            return null;
                        }
                    } else if (!ControlFlowUtils.statementMayCompleteNormally(ifStatement.getElseBranch())) {
                        checker.negate = false;
                        checker.checkExpression(condition2);
                        if (checker.hasAgreeingInstanceof()) {
                            return null;
                        }
                    }
                }
            } else if (sibling instanceof PsiAssertStatement) {
                PsiAssertStatement assertStatement = (PsiAssertStatement)sibling;
                condition2 = assertStatement.getAssertCondition();
                checker.negate = false;
                checker.checkExpression(condition2);
                if (checker.hasAgreeingInstanceof()) {
                    return null;
                }
            } else if (sibling instanceof PsiExpressionStatement && InstanceOfUtils.isInstanceOfAssertionCall(checker, call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)sibling).getExpression(), PsiMethodCallExpression.class))) {
                return null;
            }
            sibling = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, PsiStatement.class);
        }
        checker.negate = false;
        PsiElement parent = InstanceOfUtils.findInterestingParent(context);
        while (parent != null) {
            IElementType tokenType;
            IElementType iElementType = tokenType = parent instanceof PsiPolyadicExpression ? ((PsiPolyadicExpression)parent).getOperationTokenType() : null;
            if (JavaTokenType.ANDAND.equals(tokenType) || JavaTokenType.OROR.equals(tokenType)) {
                checker.negate = tokenType.equals(JavaTokenType.OROR);
                for (PsiExpression expression2 : ((PsiPolyadicExpression)parent).getOperands()) {
                    if (PsiTreeUtil.isAncestor((PsiElement)expression2, (PsiElement)context, (boolean)false)) break;
                    expression2.accept((PsiElementVisitor)checker);
                    if (!checker.hasAgreeingInstanceof()) continue;
                    return null;
                }
                checker.negate = false;
            } else {
                parent.accept((PsiElementVisitor)checker);
                if (checker.hasAgreeingInstanceof()) {
                    return null;
                }
            }
            parent = InstanceOfUtils.findInterestingParent(parent);
        }
        if (checker.hasAgreeingInstanceof()) {
            return null;
        }
        return checker.getConflictingInstanceof();
    }

    @Nullable
    private static PsiElement findInterestingParent(PsiElement context) {
        PsiElement parent;
        while ((parent = context.getParent()) != null) {
            IElementType tokenType;
            if (parent instanceof PsiPolyadicExpression && ((tokenType = ((PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
                return parent;
            }
            if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getCondition() != context) {
                return parent;
            }
            if (parent instanceof PsiConditionalLoopStatement && ((PsiConditionalLoopStatement)parent).getCondition() != context) {
                return parent;
            }
            if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != context) {
                return parent;
            }
            context = parent;
        }
        return null;
    }

    private static boolean isInstanceOfAssertionCall(InstanceofChecker checker, PsiMethodCallExpression call) {
        PsiExpression[] args;
        if (call == null) {
            return false;
        }
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call);
        if (contracts2.isEmpty()) {
            return false;
        }
        MethodContract contract = contracts2.get(0);
        if (!contract.getReturnValue().isFail()) {
            return false;
        }
        ContractValue condition2 = (ContractValue)ContainerUtil.getOnlyItem(contract.getConditions());
        if (condition2 == null) {
            return false;
        }
        checker.negate = true;
        OptionalInt argNum = condition2.getArgumentComparedTo(ContractValue.booleanValue(true), true);
        if (!argNum.isPresent()) {
            checker.negate = false;
            argNum = condition2.getArgumentComparedTo(ContractValue.booleanValue(false), true);
        }
        if (!argNum.isPresent()) {
            return false;
        }
        int index = argNum.getAsInt();
        if (index >= (args = call.getArgumentList().getExpressions()).length) {
            return false;
        }
        checker.checkExpression(args[index]);
        return checker.hasAgreeingInstanceof();
    }

    public static boolean hasAgreeingInstanceof(@NotNull PsiTypeCastExpression expression2) {
        PsiType castType = expression2.getType();
        PsiExpression operand2 = expression2.getOperand();
        if (!(operand2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand2;
        InstanceofChecker checker = new InstanceofChecker(referenceExpression, castType, false);
        PsiElement parent = InstanceOfUtils.findInterestingParent((PsiElement)expression2);
        while (parent != null) {
            parent.accept((PsiElementVisitor)checker);
            if (checker.hasAgreeingInstanceof()) {
                return true;
            }
            parent = InstanceOfUtils.findInterestingParent(parent);
        }
        return false;
    }

    @Nullable
    public static PsiInstanceOfExpression findPatternCandidate(PsiTypeCastExpression cast) {
        PsiIdentifier identifier = null;
        PsiElement context = PsiUtil.skipParenthesizedExprUp((PsiElement)cast.getParent());
        if (context instanceof PsiLocalVariable) {
            identifier = ((PsiLocalVariable)context).getNameIdentifier();
            context = context.getParent();
        } else {
            while (true) {
                boolean whenTrue;
                PsiInstanceOfExpression instanceOf;
                PsiExpression condition2;
                PsiInstanceOfExpression instanceOf2;
                IElementType tokenType;
                if (context instanceof PsiPolyadicExpression && ((tokenType = ((PsiPolyadicExpression)context).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR)) && (instanceOf2 = InstanceOfUtils.findInstanceOf((PsiExpression)context, cast, tokenType.equals(JavaTokenType.ANDAND))) != null) {
                    return instanceOf2;
                }
                if (context instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor((PsiElement)(condition2 = ((PsiConditionalExpression)context).getCondition()), (PsiElement)cast, (boolean)true) && (instanceOf = InstanceOfUtils.findInstanceOf(condition2, cast, whenTrue = PsiTreeUtil.isAncestor((PsiElement)((PsiConditionalExpression)context).getThenExpression(), (PsiElement)cast, (boolean)false))) != null) {
                    return instanceOf;
                }
                if ((!(context instanceof PsiExpression) || context instanceof PsiLambdaExpression) && !(context instanceof PsiExpressionList) && !(context instanceof PsiLocalVariable)) break;
                context = context.getParent();
            }
            if (!(context instanceof PsiStatement)) {
                return null;
            }
        }
        PsiElement parent = context.getParent();
        if (parent instanceof PsiCodeBlock) {
            for (PsiElement stmt = context.getPrevSibling(); stmt != null; stmt = stmt.getPrevSibling()) {
                PsiInstanceOfExpression instanceOf;
                PsiConditionalLoopStatement loop;
                if (stmt instanceof PsiIfStatement) {
                    PsiInstanceOfExpression instanceOf3;
                    boolean elseCompletes;
                    PsiIfStatement ifStatement = (PsiIfStatement)stmt;
                    PsiStatement thenBranch = ifStatement.getThenBranch();
                    PsiStatement elseBranch = ifStatement.getElseBranch();
                    boolean thenCompletes = InstanceOfUtils.canCompleteNormally(parent, thenBranch);
                    if (thenCompletes != (elseCompletes = InstanceOfUtils.canCompleteNormally(parent, elseBranch)) && (instanceOf3 = InstanceOfUtils.findInstanceOf(ifStatement.getCondition(), cast, thenCompletes)) != null) {
                        return instanceOf3;
                    }
                }
                if ((stmt instanceof PsiWhileStatement || stmt instanceof PsiDoWhileStatement || stmt instanceof PsiForStatement) && PsiTreeUtil.processElements((PsiElement)(loop = (PsiConditionalLoopStatement)stmt), e -> !(e instanceof PsiBreakStatement) || ((PsiBreakStatement)e).findExitedStatement() != loop) && (instanceOf = InstanceOfUtils.findInstanceOf(loop.getCondition(), cast, false)) != null) {
                    return instanceOf;
                }
                if (InstanceOfUtils.isConflictingNameDeclaredInside(identifier, stmt)) {
                    return null;
                }
                if (stmt instanceof PsiSwitchLabelStatementBase) break;
            }
            if (parent.getParent() instanceof PsiBlockStatement) {
                context = parent.getParent();
                parent = context.getParent();
            }
        }
        return InstanceOfUtils.processParent(cast, context, parent);
    }

    private static PsiInstanceOfExpression processParent(PsiTypeCastExpression cast, PsiElement context, PsiElement parent) {
        if (parent instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            if (ifStatement.getThenBranch() == context) {
                return InstanceOfUtils.findInstanceOf(ifStatement.getCondition(), cast, true);
            }
            if (ifStatement.getElseBranch() == context) {
                return InstanceOfUtils.findInstanceOf(ifStatement.getCondition(), cast, false);
            }
        }
        if (parent instanceof PsiForStatement || parent instanceof PsiWhileStatement) {
            return InstanceOfUtils.findInstanceOf(((PsiConditionalLoopStatement)parent).getCondition(), cast, true);
        }
        return null;
    }

    private static boolean isConflictingNameDeclaredInside(@Nullable PsiIdentifier identifier, @NotNull PsiElement statement) {
        if (identifier == null) {
            return false;
        }
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            boolean hasConflict = false;
            final /* synthetic */ PsiIdentifier val$identifier;

            Visitor(PsiIdentifier psiIdentifier) {
                this.val$identifier = psiIdentifier;
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitVariable(PsiVariable variable) {
                String name2 = variable.getName();
                if (name2 != null && this.val$identifier.textMatches((CharSequence)name2)) {
                    this.hasConflict = true;
                    this.stopWalking();
                }
                super.visitVariable(variable);
            }
        }
        Visitor visitor2 = new Visitor(identifier);
        statement.accept((PsiElementVisitor)visitor2);
        return visitor2.hasConflict;
    }

    private static boolean canCompleteNormally(@NotNull PsiElement parent, @Nullable PsiStatement statement) {
        ControlFlow flow;
        if (statement == null) {
            return true;
        }
        try {
            flow = ControlFlowFactory.getInstance(statement.getProject()).getControlFlow(parent, new LocalsControlFlowPolicy(parent), false, false);
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        int startOffset = flow.getStartOffset((PsiElement)statement);
        int endOffset = flow.getEndOffset((PsiElement)statement);
        return startOffset != -1 && endOffset != -1 && ControlFlowUtil.canCompleteNormally(flow, startOffset, endOffset);
    }

    @Contract(value="null, _, _ -> null")
    private static PsiInstanceOfExpression findInstanceOf(@Nullable PsiExpression condition2, @NotNull PsiTypeCastExpression cast, boolean whenTrue) {
        PsiExpression castOperand;
        PsiType castType;
        PsiType type2;
        PsiTypeTestPattern typeTestPattern;
        PsiPatternVariable variable;
        PsiInstanceOfExpression instanceOf;
        PsiPattern pattern;
        PsiPolyadicExpression polyadic;
        IElementType tokenType;
        if (condition2 == null) {
            return null;
        }
        if (condition2 instanceof PsiParenthesizedExpression) {
            return InstanceOfUtils.findInstanceOf(((PsiParenthesizedExpression)condition2).getExpression(), cast, whenTrue);
        }
        if (BoolUtils.isNegation(condition2)) {
            return InstanceOfUtils.findInstanceOf(BoolUtils.getNegated(condition2), cast, !whenTrue);
        }
        if (condition2 instanceof PsiPolyadicExpression && ((tokenType = (polyadic = (PsiPolyadicExpression)condition2).getOperationTokenType()) == JavaTokenType.ANDAND && whenTrue || tokenType == JavaTokenType.OROR && !whenTrue)) {
            for (PsiExpression operand2 : polyadic.getOperands()) {
                if (PsiTreeUtil.isAncestor((PsiElement)operand2, (PsiElement)cast, (boolean)false)) {
                    return null;
                }
                PsiInstanceOfExpression result = InstanceOfUtils.findInstanceOf(operand2, cast, whenTrue);
                if (result == null) continue;
                return result;
            }
        }
        if (condition2 instanceof PsiInstanceOfExpression && whenTrue && (pattern = (instanceOf = (PsiInstanceOfExpression)condition2).getPattern()) instanceof PsiTypeTestPattern && (variable = (typeTestPattern = (PsiTypeTestPattern)pattern).getPatternVariable()) == null && InstanceOfUtils.typeCompatible(type2 = typeTestPattern.getCheckType().getType(), castType = Objects.requireNonNull(cast.getCastType()).getType(), castOperand = Objects.requireNonNull(cast.getOperand())) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)instanceOf.getOperand(), (PsiElement)castOperand)) {
            return instanceOf;
        }
        return null;
    }

    private static boolean typeCompatible(@NotNull PsiType instanceOfType, @NotNull PsiType castType, @NotNull PsiExpression castOperand) {
        PsiClassType rawType;
        if (instanceOfType.equals(castType)) {
            return true;
        }
        if (castType instanceof PsiClassType && instanceOfType.equals(rawType = ((PsiClassType)castType).rawType())) {
            PsiType type2 = castOperand.getType();
            return type2 != null && !JavaGenericsUtil.isUncheckedCast((PsiType)castType, (PsiType)type2);
        }
        return false;
    }

    private static class InstanceofChecker
    extends JavaElementVisitor {
        private final PsiReferenceExpression referenceExpression;
        private final PsiType castType;
        private final boolean strict;
        private boolean negate = false;
        private PsiInstanceOfExpression conflictingInstanceof = null;
        private boolean agreeingInstanceof = false;

        InstanceofChecker(PsiReferenceExpression referenceExpression, PsiType castType, boolean strict) {
            this.referenceExpression = referenceExpression;
            this.castType = castType;
            this.strict = strict;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitExpression((PsiExpression)expression2);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            IElementType tokenType = expression2.getOperationTokenType();
            if (tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) {
                for (PsiExpression operand2 : expression2.getOperands()) {
                    this.checkExpression(operand2);
                    if (!this.agreeingInstanceof) continue;
                    return;
                }
                if (!this.negate && this.conflictingInstanceof != null) {
                    this.agreeingInstanceof = false;
                }
            }
        }

        public void visitForStatement(PsiForStatement statement) {
            this.processConditionalLoop((PsiConditionalLoopStatement)statement);
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            this.processConditionalLoop((PsiConditionalLoopStatement)statement);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            this.processConditionalLoop((PsiConditionalLoopStatement)statement);
        }

        private void processConditionalLoop(PsiConditionalLoopStatement loop) {
            PsiStatement body2 = loop.getBody();
            if (!PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)this.referenceExpression, (boolean)true)) {
                return;
            }
            if (this.isReassignedInside(body2)) {
                return;
            }
            this.checkExpression(loop.getCondition());
        }

        public void visitIfStatement(PsiIfStatement ifStatement) {
            PsiStatement elseBranch = ifStatement.getElseBranch();
            this.negate = PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)this.referenceExpression, (boolean)true);
            if (this.isReassignedInside(this.negate ? elseBranch : ifStatement.getThenBranch())) {
                return;
            }
            this.checkExpression(ifStatement.getCondition());
        }

        private boolean isReassignedInside(PsiStatement branch) {
            return branch instanceof PsiBlockStatement && VariableAccessUtils.variableIsAssignedBeforeReference(this.referenceExpression, (PsiElement)branch);
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            PsiExpression elseExpression2 = expression2.getElseExpression();
            this.negate = PsiTreeUtil.isAncestor((PsiElement)elseExpression2, (PsiElement)this.referenceExpression, (boolean)true);
            this.checkExpression(expression2.getCondition());
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
            if (this.negate) {
                return;
            }
            if (this.isAgreeing(expression2)) {
                this.agreeingInstanceof = true;
                this.conflictingInstanceof = null;
            } else if (this.isConflicting(expression2) && this.conflictingInstanceof == null) {
                this.conflictingInstanceof = expression2;
            }
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            PsiExpression operand2 = expression2.getExpression();
            if (operand2 != null) {
                operand2.accept((PsiElementVisitor)this);
            }
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 != null && expression2.getOperationTokenType().equals(JavaTokenType.EXCL)) {
                this.negate = !this.negate;
                operand2.accept((PsiElementVisitor)this);
                this.negate = !this.negate;
            }
        }

        private void checkExpression(PsiExpression expression2) {
            if (expression2 != null) {
                expression2.accept((PsiElementVisitor)this);
            }
        }

        private boolean isConflicting(PsiInstanceOfExpression expression2) {
            PsiExpression conditionOperand = expression2.getOperand();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.referenceExpression, conditionOperand)) {
                return false;
            }
            PsiTypeElement typeElement = expression2.getCheckType();
            if (typeElement == null) {
                return false;
            }
            PsiType type2 = typeElement.getType();
            if (this.strict) {
                return !this.castType.equals(type2);
            }
            return !this.castType.isAssignableFrom(type2);
        }

        private boolean isAgreeing(PsiInstanceOfExpression expression2) {
            PsiExpression conditionOperand = expression2.getOperand();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.referenceExpression, conditionOperand)) {
                return false;
            }
            PsiTypeElement typeElement = expression2.getCheckType();
            if (typeElement == null) {
                return false;
            }
            PsiType type2 = typeElement.getType();
            if (this.strict) {
                return this.castType.equals(type2);
            }
            return this.castType.isAssignableFrom(type2);
        }

        public boolean hasAgreeingInstanceof() {
            return this.agreeingInstanceof;
        }

        public PsiInstanceOfExpression getConflictingInstanceof() {
            return this.conflictingInstanceof;
        }
    }
}

