/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.inheritance.ImplicitSubclassProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean existsMutualSubclass(PsiClass class1, PsiClass class2, boolean avoidExpensiveProcessing) {
        if (class1 instanceof PsiTypeParameter) {
            PsiClass[] superClasses;
            for (PsiClass superClass : superClasses = class1.getSupers()) {
                if (InheritanceUtil.existsMutualSubclass(superClass, class2, avoidExpensiveProcessing)) continue;
                return false;
            }
            return true;
        }
        if (class2 instanceof PsiTypeParameter) {
            return InheritanceUtil.existsMutualSubclass(class2, class1, avoidExpensiveProcessing);
        }
        if ("java.lang.Object".equals(class1.getQualifiedName())) {
            return true;
        }
        if ("java.lang.Object".equals(class2.getQualifiedName())) {
            return true;
        }
        if (class1.isInheritor(class2, true) || class2.isInheritor(class1, true) || Objects.equals(class1, class2)) {
            return true;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)class1.getProject());
        String class1Name = class1.getName();
        String class2Name = class2.getName();
        if (class1Name == null || class2Name == null) {
            return false;
        }
        if (class1.hasModifierProperty("final") || class2.hasModifierProperty("final")) {
            return false;
        }
        if (LambdaUtil.isFunctionalClass((PsiClass)class1) || class1Name.length() < class2Name.length() || InheritanceUtil.isJavaClass(class2) && !InheritanceUtil.isJavaClass(class1)) {
            return InheritanceUtil.doSearch(class2, class1, avoidExpensiveProcessing, (SearchScope)scope);
        }
        return InheritanceUtil.doSearch(class1, class2, avoidExpensiveProcessing, (SearchScope)scope);
    }

    private static boolean isJavaClass(PsiClass class1) {
        return class1 instanceof PsiClassImpl || class1 instanceof ClsClassImpl;
    }

    public static boolean doSearch(PsiClass class1, final PsiClass class2, final boolean avoidExpensiveProcessing, SearchScope scope) {
        Query search = ClassInheritorsSearch.search((PsiClass)class1, (SearchScope)scope, (boolean)true);
        final boolean[] result = new boolean[1];
        search.forEach((Processor)new Processor<PsiClass>(){
            final AtomicInteger count = new AtomicInteger(0);

            public boolean process(PsiClass inheritor) {
                if (inheritor.equals(class2) || inheritor.isInheritor(class2, true) || avoidExpensiveProcessing && this.count.incrementAndGet() > 20) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    public static boolean hasImplementation(@NotNull PsiClass aClass) {
        for (ImplicitSubclassProvider provider : (ImplicitSubclassProvider[])ImplicitSubclassProvider.EP_NAME.getExtensions()) {
            ImplicitSubclassProvider.SubclassingInfo info;
            if (!provider.isApplicableTo(aClass) || (info = provider.getSubclassingInfo(aClass)) == null || info.isAbstract()) continue;
            return true;
        }
        return ClassInheritorsSearch.search((PsiClass)aClass).anyMatch(inheritor -> !inheritor.isInterface() && !inheritor.isAnnotationType() && !inheritor.hasModifierProperty("abstract")) || aClass.isInterface() && FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() != null;
    }

    public static boolean hasOneInheritor(PsiClass aClass) {
        CountingProcessor processor2 = new CountingProcessor(2);
        ProgressManager.getInstance().runProcess(() -> ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)aClass.getUseScope(), (boolean)false).forEach((Processor)processor2), null);
        return processor2.getCount() == 1;
    }

    private static class CountingProcessor
    implements Processor<PsiClass> {
        private final AtomicInteger myCount = new AtomicInteger(0);
        private final int myLimit;

        CountingProcessor(int limit) {
            this.myLimit = limit;
        }

        public int getCount() {
            return this.myCount.get();
        }

        public boolean process(PsiClass aClass) {
            return this.myCount.incrementAndGet() < this.myLimit;
        }
    }
}

