/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedContainer {
    @NotNull
    private final PsiExpression myQualifier;

    protected IndexedContainer(@NotNull PsiExpression qualifier) {
        this.myQualifier = qualifier;
    }

    public abstract boolean isGetMethodReference(PsiMethodReferenceExpression var1);

    public abstract PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression var1);

    public abstract PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression var1);

    @NotNull
    public PsiExpression getQualifier() {
        return this.myQualifier;
    }

    public boolean isQualifierEquivalent(@Nullable PsiExpression candidate) {
        return (candidate = PsiUtil.skipParenthesizedExprDown((PsiExpression)candidate)) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myQualifier, (PsiElement)candidate);
    }

    public abstract PsiType getElementType();

    @Nullable
    public static IndexedContainer fromLengthExpression(@Nullable PsiExpression expression2) {
        PsiExpression qualifier;
        PsiMethodCallExpression call;
        PsiExpression arrayExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getArrayFromLengthExpression(expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)));
        if (arrayExpression != null) {
            return new ArrayIndexedContainer(arrayExpression);
        }
        if (expression2 instanceof PsiMethodCallExpression && ListIndexedContainer.isSizeCall(call = (PsiMethodCallExpression)expression2) && (qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getEffectiveQualifier(call.getMethodExpression()))) != null) {
            return new ListIndexedContainer(qualifier);
        }
        return null;
    }

    static class ListIndexedContainer
    extends IndexedContainer {
        ListIndexedContainer(@NotNull PsiExpression qualifier) {
            super(qualifier);
        }

        @Override
        public boolean isGetMethodReference(PsiMethodReferenceExpression methodReference) {
            if (!"get".equals(methodReference.getReferenceName())) {
                return false;
            }
            if (!this.isQualifierEquivalent(ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)methodReference))) {
                return false;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodReference.resolve(), PsiMethod.class);
            return method != null && MethodUtils.methodMatches(method, "java.util.List", null, "get", new PsiType[]{PsiType.INT});
        }

        @Override
        public PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression indexExpression) {
            PsiElement gParent;
            PsiElement parent;
            if (indexExpression != null && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)indexExpression.getParent())) instanceof PsiExpressionList && (gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent())) instanceof PsiMethodCallExpression && PsiTreeUtil.isAncestor((PsiElement)this.extractIndexFromGetExpression((PsiExpression)gParent), (PsiElement)indexExpression, (boolean)false)) {
                return (PsiExpression)gParent;
            }
            return null;
        }

        @Override
        public PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression expression2) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiMethodCallExpression.class);
            if (call == null) {
                return null;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 1 && ListIndexedContainer.isGetCall(call) && this.isQualifierEquivalent(ExpressionUtils.getEffectiveQualifier(call.getMethodExpression()))) {
                return args[0];
            }
            return null;
        }

        @Override
        public PsiType getElementType() {
            PsiType type2 = PsiUtil.substituteTypeParameter((PsiType)this.getQualifier().getType(), (String)"java.util.List", (int)0, (boolean)false);
            return GenericsUtil.getVariableTypeByExpressionType((PsiType)type2);
        }

        static boolean isGetCall(PsiMethodCallExpression call) {
            return MethodCallUtils.isCallToMethod(call, "java.util.List", null, "get", new PsiType[]{PsiType.INT});
        }

        static boolean isSizeCall(PsiMethodCallExpression call) {
            return MethodCallUtils.isCallToMethod(call, "java.util.List", (PsiType)PsiType.INT, "size", new PsiType[0]);
        }
    }

    static class ArrayIndexedContainer
    extends IndexedContainer {
        ArrayIndexedContainer(@NotNull PsiExpression qualifier) {
            super(qualifier);
        }

        @Override
        public boolean isGetMethodReference(PsiMethodReferenceExpression methodReference) {
            return false;
        }

        @Override
        public PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression indexExpression) {
            PsiElement parent;
            if (indexExpression != null && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)indexExpression.getParent())) instanceof PsiExpression && PsiTreeUtil.isAncestor((PsiElement)this.extractIndexFromGetExpression((PsiExpression)parent), (PsiElement)indexExpression, (boolean)false)) {
                return (PsiExpression)parent;
            }
            return null;
        }

        @Override
        public PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression expression2) {
            PsiArrayAccessExpression arrayAccess;
            if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiArrayAccessExpression && this.isQualifierEquivalent((arrayAccess = (PsiArrayAccessExpression)expression2).getArrayExpression())) {
                return arrayAccess.getIndexExpression();
            }
            return null;
        }

        @Override
        public PsiType getElementType() {
            PsiType type2 = this.getQualifier().getType();
            return type2 instanceof PsiArrayType ? ((PsiArrayType)type2).getComponentType() : null;
        }
    }
}

