/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTemplateStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean isElseIf(PsiIfStatement ifStatement) {
        PsiElement parent = ifStatement.getParent();
        if (parent instanceof PsiCodeBlock && ((PsiCodeBlock)parent).getStatementCount() == 1 && parent.getParent() instanceof PsiBlockStatement) {
            parent = parent.getParent().getParent();
        }
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement parentStatement = (PsiIfStatement)parent;
        PsiStatement elseBranch = parentStatement.getElseBranch();
        return ifStatement.equals(elseBranch);
    }

    public static boolean statementMayCompleteNormally(@Nullable PsiStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiYieldStatement || statement instanceof PsiReturnStatement || statement instanceof PsiThrowStatement) {
            return false;
        }
        if (statement instanceof PsiExpressionListStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiAssertStatement || statement instanceof PsiDeclarationStatement || statement instanceof PsiSwitchLabelStatement || statement instanceof PsiForeachStatement) {
            return true;
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return true;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return true;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return true;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return true;
            }
            String className2 = aClass.getQualifiedName();
            return !"java.lang.System".equals(className2);
        }
        if (statement instanceof PsiForStatement) {
            return ControlFlowUtils.forStatementMayCompleteNormally((PsiForStatement)statement);
        }
        if (statement instanceof PsiWhileStatement) {
            return ControlFlowUtils.whileStatementMayCompleteNormally((PsiWhileStatement)statement);
        }
        if (statement instanceof PsiDoWhileStatement) {
            return ControlFlowUtils.doWhileStatementMayCompleteNormally((PsiDoWhileStatement)statement);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body2 = ((PsiSynchronizedStatement)statement).getBody();
            return ControlFlowUtils.codeBlockMayCompleteNormally(body2);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement).getCodeBlock();
            return ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
        }
        if (statement instanceof PsiLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((PsiLabeledStatement)statement);
        }
        if (statement instanceof PsiIfStatement) {
            return ControlFlowUtils.ifStatementMayCompleteNormally((PsiIfStatement)statement);
        }
        if (statement instanceof PsiTryStatement) {
            return ControlFlowUtils.tryStatementMayCompleteNormally((PsiTryStatement)statement);
        }
        if (statement instanceof PsiSwitchStatement) {
            return ControlFlowUtils.switchStatementMayCompleteNormally((PsiSwitchStatement)statement);
        }
        if (statement instanceof PsiSwitchLabeledRuleStatement) {
            PsiStatement body3 = ((PsiSwitchLabeledRuleStatement)statement).getBody();
            return body3 != null && ControlFlowUtils.statementMayCompleteNormally(body3);
        }
        if (statement instanceof PsiTemplateStatement || statement instanceof PsiClassLevelDeclarationStatement) {
            return true;
        }
        assert (false) : "unknown statement type: " + statement.getClass();
        return true;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isEndlessLoop(@Nullable PsiConditionalLoopStatement loopStatement) {
        if (loopStatement == null) {
            return false;
        }
        if (loopStatement instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)loopStatement;
            PsiExpression condition2 = forStatement.getCondition();
            if (condition2 != null && !BoolUtils.isTrue(condition2)) {
                return false;
            }
            return !(forStatement.getInitialization() != null && !(forStatement.getInitialization() instanceof PsiEmptyStatement) || forStatement.getUpdate() != null && !(forStatement.getUpdate() instanceof PsiEmptyStatement));
        }
        return BoolUtils.isTrue(loopStatement.getCondition());
    }

    private static boolean doWhileStatementMayCompleteNormally(@NotNull PsiDoWhileStatement loopStatement) {
        PsiExpression condition2 = loopStatement.getCondition();
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        PsiStatement body2 = loopStatement.getBody();
        return ControlFlowUtils.statementMayCompleteNormally(body2) && value2 != Boolean.TRUE || ControlFlowUtils.statementContainsBreakToStatementOrAncestor((PsiStatement)loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement);
    }

    private static boolean whileStatementMayCompleteNormally(@NotNull PsiWhileStatement loopStatement) {
        PsiExpression condition2 = loopStatement.getCondition();
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        return value2 != Boolean.TRUE || ControlFlowUtils.statementContainsBreakToStatementOrAncestor((PsiStatement)loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement);
    }

    private static boolean forStatementMayCompleteNormally(@NotNull PsiForStatement loopStatement) {
        if (ControlFlowUtils.statementContainsBreakToStatementOrAncestor((PsiStatement)loopStatement)) {
            return true;
        }
        if (ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement)) {
            return true;
        }
        PsiExpression condition2 = loopStatement.getCondition();
        if (condition2 == null) {
            return false;
        }
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        return Boolean.TRUE != value2;
    }

    private static boolean switchStatementMayCompleteNormally(@NotNull PsiSwitchStatement switchStatement) {
        if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)switchStatement)) {
            return true;
        }
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return true;
        }
        PsiStatement[] statements = body2.getStatements();
        if (statements.length == 0) {
            return true;
        }
        int numCases = 0;
        boolean hasDefaultCase = false;
        for (PsiStatement statement : statements) {
            PsiBreakStatement breakStatement;
            if (statement instanceof PsiSwitchLabelStatement) {
                ++numCases;
                PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)statement;
                if (switchLabelStatement.isDefaultCase()) {
                    hasDefaultCase = true;
                }
            }
            if (!(statement instanceof PsiBreakStatement) || (breakStatement = (PsiBreakStatement)statement).getLabelIdentifier() != null) continue;
            return true;
        }
        boolean isEnum = ControlFlowUtils.isEnumSwitch(switchStatement);
        if (!hasDefaultCase && !isEnum) {
            return true;
        }
        if (!hasDefaultCase) {
            PsiExpression expression2 = switchStatement.getExpression();
            if (expression2 == null) {
                return true;
            }
            PsiClassType type2 = (PsiClassType)expression2.getType();
            if (type2 == null) {
                return true;
            }
            PsiClass aClass = type2.resolve();
            if (aClass == null) {
                return true;
            }
            if (!ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)aClass, numCases, PsiEnumConstant.class)) {
                return true;
            }
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean isEnumSwitch(PsiSwitchStatement statement) {
        PsiExpression expression2 = statement.getExpression();
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        if (type2 == null) {
            return false;
        }
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type2).resolve();
        return aClass != null && aClass.isEnum();
    }

    private static boolean tryStatementMayCompleteNormally(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock[] catchBlocks;
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && !ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.codeBlockMayCompleteNormally(tryBlock)) {
            return true;
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (!ControlFlowUtils.codeBlockMayCompleteNormally(catchBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayCompleteNormally(@NotNull PsiIfStatement ifStatement) {
        PsiStatement branch2;
        PsiStatement branch1;
        PsiExpression condition2 = ifStatement.getCondition();
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (value2 == Boolean.TRUE) {
            return ControlFlowUtils.statementMayCompleteNormally(thenBranch);
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (value2 == Boolean.FALSE) {
            return ControlFlowUtils.statementMayCompleteNormally(elseBranch);
        }
        if ((thenBranch == null ? 0 : thenBranch.getTextLength()) < (elseBranch == null ? 0 : elseBranch.getTextLength())) {
            branch1 = thenBranch;
            branch2 = elseBranch;
        } else {
            branch2 = thenBranch;
            branch1 = elseBranch;
        }
        return ControlFlowUtils.statementMayCompleteNormally(branch1) || ControlFlowUtils.statementMayCompleteNormally(branch2);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull PsiLabeledStatement labeledStatement) {
        PsiStatement statement = labeledStatement.getStatement();
        if (statement == null) {
            return false;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement) || ControlFlowUtils.statementContainsBreakToStatementOrAncestor(statement);
    }

    public static boolean codeBlockMayCompleteNormally(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return true;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementContainsBreakToStatementOrAncestor(@NotNull PsiStatement statement) {
        BreakFinder breakFinder = new BreakFinder(statement, true);
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static boolean statementIsBreakTarget(@NotNull PsiStatement statement) {
        BreakFinder breakFinder = new BreakFinder(statement, false);
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static boolean statementContainsContinueToAncestor(@NotNull PsiStatement statement) {
        PsiElement parent = statement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            statement = (PsiStatement)parent;
            parent = parent.getParent();
        }
        ContinueToAncestorFinder continueToAncestorFinder = new ContinueToAncestorFinder(statement);
        statement.accept((PsiElementVisitor)continueToAncestorFinder);
        return continueToAncestorFinder.continueToAncestorFound();
    }

    public static boolean containsReturn(@NotNull PsiElement element) {
        ReturnFinder returnFinder = new ReturnFinder();
        element.accept((PsiElementVisitor)returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull PsiStatement statement) {
        ContinueFinder continueFinder = new ContinueFinder(statement);
        statement.accept((PsiElementVisitor)continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean containsSystemExit(@NotNull PsiElement element) {
        SystemExitFinder systemExitFinder = new SystemExitFinder();
        element.accept((PsiElementVisitor)systemExitFinder);
        return systemExitFinder.exitFound();
    }

    public static boolean elementContainsCallToMethod(PsiElement context, String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        MethodCallFinder methodCallFinder = new MethodCallFinder(containingClassName, returnType, methodName, parameterTypes);
        context.accept((PsiElementVisitor)methodCallFinder);
        return methodCallFinder.containsCallToMethod();
    }

    public static boolean isInLoop(@NotNull PsiElement element) {
        PsiLoopStatement loopStatement = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        if (loopStatement == null) {
            return false;
        }
        PsiStatement body2 = loopStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)element, (boolean)true);
    }

    public static boolean isInFinallyBlock(@NotNull PsiElement element) {
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock != null && PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                PsiMethod elementMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiMethod.class);
                PsiMethod finallyMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)finallyBlock, PsiMethod.class);
                return elementMethod != null && elementMethod.equals(finallyMethod);
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static boolean isInCatchBlock(@NotNull PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiCatchSection.class, (boolean)true, (Class[])new Class[]{PsiClass.class}) != null;
    }

    public static boolean isInExitStatement(@NotNull PsiExpression expression2) {
        return ControlFlowUtils.isInReturnStatementArgument(expression2) || ControlFlowUtils.isInThrowStatementArgument(expression2);
    }

    private static boolean isInReturnStatementArgument(@NotNull PsiExpression expression2) {
        return PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiReturnStatement.class) != null;
    }

    public static boolean isInThrowStatementArgument(@NotNull PsiExpression expression2) {
        return PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiThrowStatement.class) != null;
    }

    @Contract(value="null -> null; !null -> !null")
    public static PsiStatement stripBraces(@Nullable PsiStatement statement) {
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)statement;
            PsiStatement onlyStatement = ControlFlowUtils.getOnlyStatementInBlock(block.getCodeBlock());
            return onlyStatement != null ? onlyStatement : block;
        }
        return statement;
    }

    public static PsiStatement @NotNull [] unwrapBlock(@Nullable PsiStatement statement) {
        PsiStatement[] psiStatementArray;
        PsiBlockStatement block = (PsiBlockStatement)ObjectUtils.tryCast((Object)statement, PsiBlockStatement.class);
        if (block != null) {
            return block.getCodeBlock().getStatements();
        }
        if (statement == null) {
            psiStatementArray = PsiStatement.EMPTY_ARRAY;
        } else {
            PsiStatement[] psiStatementArray2 = new PsiStatement[1];
            psiStatementArray = psiStatementArray2;
            psiStatementArray2[0] = statement;
        }
        return psiStatementArray;
    }

    public static boolean statementCompletesWithStatement(@NotNull PsiStatement containingStatement, @NotNull PsiStatement statement) {
        PsiStatement statementToCheck = statement;
        while (!containingStatement.equals(statementToCheck)) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck);
            if (container == null || container instanceof PsiLoopStatement) {
                return false;
            }
            if (container instanceof PsiCodeBlock && !ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                return false;
            }
            statementToCheck = container;
            if (!(statementToCheck instanceof PsiSwitchLabeledRuleStatement)) continue;
            statementToCheck = PsiTreeUtil.getParentOfType((PsiElement)statementToCheck, PsiStatement.class);
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull PsiCodeBlock body2, @NotNull PsiStatement statement) {
        PsiStatement statementToCheck = statement;
        PsiElement container;
        while ((container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck)) != null && !(container instanceof PsiLoopStatement)) {
            if (container instanceof PsiCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body2)) {
                    return true;
                }
                statementToCheck = PsiTreeUtil.getParentOfType((PsiElement)container, PsiStatement.class);
                continue;
            }
            statementToCheck = container;
            if (!(statementToCheck instanceof PsiSwitchLabeledRuleStatement)) continue;
            statementToCheck = PsiTreeUtil.getParentOfType((PsiElement)statementToCheck, PsiStatement.class);
        }
        return false;
    }

    @Nullable
    @Contract(value="null -> null")
    private static PsiElement getContainingStatementOrBlock(@Nullable PsiElement statement) {
        return PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class});
    }

    private static boolean statementIsLastInBlock(@NotNull PsiCodeBlock block, @NotNull PsiStatement statement) {
        for (PsiElement child = block.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PsiStatement)) continue;
            PsiStatement childStatement = (PsiStatement)child;
            if (statement.equals(childStatement)) {
                return true;
            }
            if (statement instanceof PsiEmptyStatement) continue;
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiStatement getFirstStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return (PsiStatement)PsiTreeUtil.getChildOfType((PsiElement)codeBlock, PsiStatement.class);
    }

    @Nullable
    public static PsiStatement getLastStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        if (codeBlock == null) {
            return null;
        }
        for (PsiElement child = codeBlock.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PsiStatement)) continue;
            return (PsiStatement)child;
        }
        return null;
    }

    @Nullable
    public static PsiStatement getOnlyStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return ControlFlowUtils.getOnlyChildOfType((PsiElement)codeBlock, PsiStatement.class);
    }

    static <T extends PsiElement> T getOnlyChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (element == null) {
            return null;
        }
        PsiElement result = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            if (result == null) {
                result = child;
                continue;
            }
            return null;
        }
        return (T)result;
    }

    public static boolean hasStatementCount(@Nullable PsiCodeBlock codeBlock, int count) {
        return ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)codeBlock, count, PsiStatement.class);
    }

    public static <T extends PsiElement> boolean hasChildrenOfTypeCount(@Nullable PsiElement element, int count, @NotNull Class<T> aClass) {
        if (element == null) {
            return false;
        }
        int i = 0;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child) || ++i <= count) continue;
            return false;
        }
        return i == count;
    }

    public static <T extends PsiElement> boolean isNestedElement(@NotNull T element, @NotNull Class<? extends T> aClass) {
        return PsiTreeUtil.getParentOfType(element, aClass, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}) != null;
    }

    public static boolean isEmptyCodeBlock(PsiCodeBlock codeBlock) {
        return ControlFlowUtils.hasStatementCount(codeBlock, 0);
    }

    public static boolean methodAlwaysThrowsException(@NotNull PsiMethod method) {
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return true;
        }
        return !ControlFlowUtils.containsReturn((PsiElement)body2) && !ControlFlowUtils.codeBlockMayCompleteNormally(body2);
    }

    public static boolean lambdaExpressionAlwaysThrowsException(PsiLambdaExpression expression2) {
        PsiElement body2 = expression2.getBody();
        if (body2 instanceof PsiExpression) {
            return false;
        }
        if (!(body2 instanceof PsiCodeBlock)) {
            return true;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)body2;
        return !ControlFlowUtils.containsReturn((PsiElement)codeBlock) && !ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
    }

    @Contract(value="null -> false")
    public static boolean statementContainsNakedBreak(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        NakedBreakFinder breakFinder = new NakedBreakFinder();
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    @Contract(value="null -> false")
    public static boolean statementContainsNakedContinue(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        NakedContinueFinder breakFinder = new NakedContinueFinder();
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.continueFound();
    }

    @Contract(value="null, _ -> false")
    public static boolean statementBreaksLoop(PsiStatement statement, PsiLoopStatement loop) {
        if (statement instanceof PsiBreakStatement) {
            return ((PsiBreakStatement)statement).findExitedStatement() == loop;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiElement nextElement;
            PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
            PsiLoopStatement cur = loop;
            PsiElement parent = cur.getParent();
            while (true) {
                if (parent instanceof PsiLabeledStatement) {
                    cur = parent;
                } else if (parent instanceof PsiCodeBlock) {
                    PsiCodeBlock block = (PsiCodeBlock)parent;
                    PsiStatement[] statements = block.getStatements();
                    if (!(block.getParent() instanceof PsiBlockStatement) || statements.length <= 0 || statements[statements.length - 1] != cur) break;
                    cur = block.getParent();
                } else {
                    if (!(parent instanceof PsiIfStatement) || cur != ((PsiIfStatement)parent).getThenBranch() && cur != ((PsiIfStatement)parent).getElseBranch()) break;
                    cur = parent;
                }
                parent = cur.getParent();
            }
            if ((nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)cur)) instanceof PsiReturnStatement) {
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(returnValue, ((PsiReturnStatement)nextElement).getReturnValue());
            }
            if (returnValue == null && cur.getParent() instanceof PsiCodeBlock && cur.getParent().getParent() instanceof PsiMethod && nextElement instanceof PsiJavaToken && ((PsiJavaToken)nextElement).getTokenType().equals(JavaTokenType.RBRACE)) {
                return true;
            }
        }
        return false;
    }

    private static StreamEx<PsiExpression> conditions(PsiElement element) {
        return StreamEx.iterate((Object)element, e -> e != null && !(e instanceof PsiLambdaExpression) && !(e instanceof PsiMethod), PsiElement::getParent).pairMap((child, parent) -> parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getThenBranch() == child ? parent : null).select(PsiIfStatement.class).map(PsiIfStatement::getCondition).flatMap(cond -> cond instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)cond).getOperationTokenType().equals(JavaTokenType.ANDAND) ? StreamEx.of((Object[])((PsiPolyadicExpression)cond).getOperands()) : StreamEx.of((Object)cond));
    }

    public static boolean isExecutedOnceInLoop(PsiStatement statement, PsiLoopStatement loop) {
        if (ControlFlowUtils.flowBreaksLoop(statement, loop)) {
            return true;
        }
        if (loop instanceof PsiForStatement) {
            boolean hasLoopVarCheck;
            PsiLocalVariable variable;
            PsiDeclarationStatement initialization = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)((PsiForStatement)loop).getInitialization(), PsiDeclarationStatement.class);
            PsiStatement update2 = ((PsiForStatement)loop).getUpdate();
            if (initialization != null && update2 != null && (variable = (PsiLocalVariable)StreamEx.of((Object[])initialization.getDeclaredElements()).select(PsiLocalVariable.class).findFirst(var -> VariableAccessUtils.variableIsIncremented((PsiVariable)var, update2) || VariableAccessUtils.variableIsDecremented((PsiVariable)var, update2)).orElse(null)) != null && (hasLoopVarCheck = ((StreamEx)ControlFlowUtils.conditions((PsiElement)statement).select(PsiBinaryExpression.class).filter(binOp -> binOp.getOperationTokenType().equals(JavaTokenType.EQEQ))).anyMatch(binOp -> ExpressionUtils.getOtherOperand(binOp, (PsiVariable)variable) != null))) {
                return ReferencesSearch.search((PsiElement)variable).allMatch(ref -> {
                    PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)ref.getElement(), PsiExpression.class);
                    return expression2 == null || PsiTreeUtil.isAncestor((PsiElement)update2, (PsiElement)expression2, (boolean)false) || !PsiUtil.isAccessedForWriting((PsiExpression)expression2);
                });
            }
        }
        return false;
    }

    public static boolean isVariableReassigned(PsiStatement statement, PsiVariable variable) {
        PsiStatement sibling = ControlFlowUtils.nextExecutedStatement(statement);
        while (sibling != null) {
            PsiExpression rValue = ExpressionUtils.getAssignmentTo((PsiElement)sibling, variable);
            if (rValue != null && !VariableAccessUtils.variableIsUsed(variable, (PsiElement)rValue)) {
                return true;
            }
            if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)sibling)) {
                return false;
            }
            sibling = ControlFlowUtils.nextExecutedStatement(sibling);
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean flowBreaksLoop(PsiStatement statement, PsiLoopStatement loop) {
        if (statement == null || statement == loop) {
            return false;
        }
        PsiStatement sibling = statement;
        while (sibling != null) {
            if (sibling instanceof PsiContinueStatement) {
                PsiStatement continueTarget = ((PsiContinueStatement)sibling).findContinuedStatement();
                return PsiTreeUtil.isAncestor((PsiElement)continueTarget, (PsiElement)loop, (boolean)true);
            }
            if (sibling instanceof PsiThrowStatement || sibling instanceof PsiReturnStatement) {
                return true;
            }
            if (sibling instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)sibling;
                PsiStatement exitedStatement = breakStatement.findExitedStatement();
                if (exitedStatement == loop) {
                    return true;
                }
                return ControlFlowUtils.flowBreaksLoop(ControlFlowUtils.nextExecutedStatement(exitedStatement), loop);
            }
            if ((sibling instanceof PsiIfStatement || sibling instanceof PsiSwitchStatement) && !PsiTreeUtil.collectElementsOfType((PsiElement)sibling, (Class[])new Class[]{PsiContinueStatement.class}).isEmpty()) {
                return false;
            }
            if (sibling instanceof PsiLoopStatement && PsiTreeUtil.collectElements((PsiElement)sibling, e -> e instanceof PsiContinueStatement && ((PsiContinueStatement)e).getLabelIdentifier() != null).length > 0) {
                return false;
            }
            sibling = ControlFlowUtils.nextExecutedStatement(sibling);
        }
        return false;
    }

    @Nullable
    private static PsiStatement firstStatement(@Nullable PsiStatement statement) {
        PsiStatement[] statements;
        while (statement instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)statement).getCodeBlock().getStatements()).length != 0) {
            statement = statements[0];
        }
        return statement;
    }

    @Nullable
    private static PsiStatement nextExecutedStatement(PsiStatement statement) {
        PsiStatement next = ControlFlowUtils.firstStatement((PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class));
        if (next == null) {
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiBlockStatement || gParent instanceof PsiSwitchStatement) {
                    return ControlFlowUtils.nextExecutedStatement((PsiStatement)gParent);
                }
            } else if (parent instanceof PsiLabeledStatement || parent instanceof PsiIfStatement || parent instanceof PsiSwitchLabelStatement || parent instanceof PsiSwitchStatement) {
                return ControlFlowUtils.nextExecutedStatement((PsiStatement)parent);
            }
        }
        return next;
    }

    public static boolean isVariableReferencedBeforeStatementEntry(@NotNull ControlFlow flow, int start, PsiStatement statement, @NotNull PsiVariable variable, @NotNull Set<Integer> excluded) {
        int statementStart = flow.getStartOffset((PsiElement)statement);
        int statementEnd = flow.getEndOffset((PsiElement)statement);
        List<ControlFlowUtil.ControlFlowEdge> edges = ControlFlowUtil.getEdges(flow, start);
        Collections.reverse(edges);
        BitSet referenced = new BitSet();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (ControlFlowUtil.ControlFlowEdge edge : edges) {
                int from = edge.myFrom;
                int to = edge.myTo;
                if (referenced.get(from)) {
                    if (to == statementStart && (from < statementStart || from >= statementEnd)) {
                        return true;
                    }
                    if (referenced.get(to)) continue;
                    referenced.set(to);
                    changed = true;
                    continue;
                }
                if (!ControlFlowUtil.isVariableAccess(flow, from, variable) || excluded.contains(from)) continue;
                referenced.set(from);
                referenced.set(to);
                if (to == statementStart) {
                    return true;
                }
                changed = true;
            }
        }
        return false;
    }

    @NotNull
    public static InitializerUsageStatus getInitializerUsageStatus(PsiVariable var, PsiStatement statement) {
        ControlFlow controlFlow;
        if (!(var instanceof PsiLocalVariable) || var.getInitializer() == null) {
            return InitializerUsageStatus.UNKNOWN;
        }
        if (ControlFlowUtils.isDeclarationJustBefore(var, statement)) {
            return InitializerUsageStatus.DECLARED_JUST_BEFORE;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)var, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class}) != PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class})) {
            return InitializerUsageStatus.UNKNOWN;
        }
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)var, null);
        if (block == null) {
            return InitializerUsageStatus.UNKNOWN;
        }
        try {
            controlFlow = ControlFlowFactory.getInstance(statement.getProject()).getControlFlow(block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException ignored) {
            return InitializerUsageStatus.UNKNOWN;
        }
        int start = controlFlow.getEndOffset((PsiElement)var.getInitializer()) + 1;
        int stop = controlFlow.getStartOffset((PsiElement)statement);
        if (ControlFlowUtils.isVariableReferencedBeforeStatementEntry(controlFlow, start, statement, var, Collections.emptySet())) {
            return InitializerUsageStatus.UNKNOWN;
        }
        if (!ControlFlowUtil.isValueUsedWithoutVisitingStop(controlFlow, start, stop, var)) {
            return InitializerUsageStatus.AT_WANTED_PLACE_ONLY;
        }
        return var.hasModifierProperty("final") ? InitializerUsageStatus.UNKNOWN : InitializerUsageStatus.AT_WANTED_PLACE;
    }

    private static boolean isDeclarationJustBefore(PsiVariable var, PsiStatement nextStatement) {
        Object[] elements;
        PsiElement declaration2 = var.getParent();
        PsiElement nextStatementParent = nextStatement.getParent();
        if (nextStatementParent instanceof PsiLabeledStatement) {
            nextStatement = (PsiStatement)nextStatementParent;
        }
        return declaration2 instanceof PsiDeclarationStatement && ArrayUtil.getLastElement((Object[])(elements = ((PsiDeclarationStatement)declaration2).getDeclaredElements())) == var && nextStatement.equals(PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)declaration2));
    }

    @Contract(value="null -> false")
    public static boolean statementIsEmpty(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        if (statement instanceof PsiEmptyStatement) {
            return true;
        }
        if (statement instanceof PsiBlockStatement) {
            PsiStatement[] codeBlockStatements;
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            for (PsiStatement codeBlockStatement : codeBlockStatements = codeBlock.getStatements()) {
                if (ControlFlowUtils.statementIsEmpty(codeBlockStatement)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiReturnStatement getNextReturnStatement(PsiStatement statement) {
        PsiElement nextStatement;
        while (!((nextStatement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement)) instanceof PsiReturnStatement)) {
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiStatement[] statements = ((PsiCodeBlock)parent).getStatements();
                if (statements.length == 0 || statements[statements.length - 1] != statement) {
                    return null;
                }
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiIfStatement) && !(parent instanceof PsiBlockStatement)) {
                return null;
            }
            statement = (PsiStatement)parent;
        }
        return (PsiReturnStatement)nextStatement;
    }

    public static boolean isReachable(@NotNull PsiStatement statement) {
        ControlFlow flow;
        PsiStatement block = statement;
        do {
            if ((block = PsiTreeUtil.getParentOfType((PsiElement)block, PsiCodeBlock.class)) != null) continue;
            return true;
        } while (block.getParent() instanceof PsiSwitchStatement);
        try {
            flow = ControlFlowFactory.getInstance(statement.getProject()).getControlFlow((PsiElement)block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return ControlFlowUtil.isInstructionReachable(flow, flow.getStartOffset((PsiElement)statement), 0);
    }

    public static boolean isEmpty(PsiElement element, boolean commentIsContent, boolean emptyBlocks) {
        if (!commentIsContent && element instanceof PsiComment) {
            return true;
        }
        if (element instanceof PsiEmptyStatement) {
            return !commentIsContent || PsiTreeUtil.getChildOfType((PsiElement)element, PsiComment.class) == null && !(PsiTreeUtil.skipWhitespacesBackward((PsiElement)element) instanceof PsiComment);
        }
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (element instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)element;
            return ControlFlowUtils.isEmpty((PsiElement)block.getCodeBlock(), commentIsContent, emptyBlocks);
        }
        if (emptyBlocks && element instanceof PsiCodeBlock) {
            PsiCodeBlock codeBlock = (PsiCodeBlock)element;
            PsiElement[] children = codeBlock.getChildren();
            if (children.length == 2) {
                return true;
            }
            for (int i = 1; i < children.length - 1; ++i) {
                PsiElement child = children[i];
                if (ControlFlowUtils.isEmpty(child, commentIsContent, true)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void ensureElseBranch(PsiIfStatement ifStatement) {
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            if (!(elseBranch instanceof PsiBlockStatement)) {
                BlockUtils.expandSingleStatementToBlockStatement(elseBranch);
            }
        } else {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiBlockStatement emptyBlock = BlockUtils.createBlockStatement(ifStatement.getProject());
            if (thenBranch == null) {
                ifStatement.setThenBranch((PsiStatement)emptyBlock);
            } else if (!(thenBranch instanceof PsiBlockStatement)) {
                BlockUtils.expandSingleStatementToBlockStatement(thenBranch);
            }
            ifStatement.setElseBranch((PsiStatement)emptyBlock);
        }
    }

    private static class ContinueToAncestorFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiStatement statement;
        private boolean found;

        private ContinueToAncestorFinder(PsiStatement statement) {
            this.statement = statement;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitContinueStatement(PsiContinueStatement continueStatement) {
            if (this.found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            PsiStatement continuedStatement = continueStatement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)this.statement, (boolean)true)) {
                this.found = true;
            }
        }

        private boolean continueToAncestorFound() {
            return this.found;
        }
    }

    private static class MethodCallFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final String containingClassName;
        private final PsiType returnType;
        private final String methodName;
        private final PsiType[] parameterTypeNames;
        private boolean containsCallToMethod;

        private MethodCallFinder(String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypeNames) {
            this.containingClassName = containingClassName;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterTypeNames = parameterTypeNames;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.isCallToMethod(expression2, this.containingClassName, this.returnType, this.methodName, this.parameterTypeNames)) {
                return;
            }
            this.containsCallToMethod = true;
        }

        private boolean containsCallToMethod() {
            return this.containsCallToMethod;
        }
    }

    private static class ContinueFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private ContinueFinder(@NotNull PsiStatement target) {
            this.m_target = target;
        }

        private boolean continueFound() {
            return this.m_found;
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(statement);
            PsiStatement continuedStatement = statement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition2 = statement.getCondition();
            Object value2 = ExpressionUtils.computeConstantExpression(condition2);
            if (Boolean.FALSE != value2 && (thenBranch = statement.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value2 && (elseBranch = statement.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }
    }

    private static class BreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;
        private final boolean myAncestor;

        BreakFinder(@NotNull PsiStatement target, boolean ancestor) {
            this.m_target = target;
            this.myAncestor = ancestor;
        }

        boolean breakFound() {
            return this.m_found;
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(statement);
            PsiStatement exitedStatement = statement.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (this.myAncestor) {
                if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                    this.m_found = true;
                }
            } else if (exitedStatement == this.m_target) {
                this.m_found = true;
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition2 = statement.getCondition();
            Object value2 = ExpressionUtils.computeConstantExpression(condition2);
            if (Boolean.FALSE != value2 && (thenBranch = statement.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value2 && (elseBranch = statement.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }
    }

    private static class ReturnFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myFound;

        private ReturnFinder() {
        }

        private boolean returnFound() {
            return this.myFound;
        }

        public void visitClass(@NotNull PsiClass psiClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            this.myFound = true;
            this.stopWalking();
        }
    }

    private static class SystemExitFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private SystemExitFinder() {
        }

        private boolean exitFound() {
            return this.m_found;
        }

        public void visitClass(@NotNull PsiClass aClass) {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (this.m_found) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className2 = aClass.getQualifiedName();
            if (!"java.lang.System".equals(className2) && !"java.lang.Runtime".equals(className2)) {
                return;
            }
            this.m_found = true;
        }
    }

    private static class NakedContinueFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private NakedContinueFinder() {
        }

        private boolean continueFound() {
            return this.m_found;
        }

        public void visitExpression(PsiExpression expression2) {
        }

        public void visitContinueStatement(PsiContinueStatement statement) {
            if (statement.getLabelIdentifier() != null) {
                return;
            }
            this.m_found = true;
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        }

        public void visitForStatement(PsiForStatement statement) {
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
        }
    }

    private static class NakedBreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private NakedBreakFinder() {
        }

        private boolean breakFound() {
            return this.m_found;
        }

        public void visitExpression(PsiExpression expression2) {
        }

        public void visitBreakStatement(PsiBreakStatement statement) {
            if (statement.getLabelIdentifier() != null) {
                return;
            }
            this.m_found = true;
            this.stopWalking();
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        }

        public void visitForStatement(PsiForStatement statement) {
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
        }

        public void visitSwitchStatement(PsiSwitchStatement statement) {
        }
    }

    public static enum InitializerUsageStatus {
        DECLARED_JUST_BEFORE,
        AT_WANTED_PLACE_ONLY,
        AT_WANTED_PLACE,
        UNKNOWN;

    }
}

