/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneUtils {
    private CloneUtils() {
    }

    public static boolean isCloneable(@Nullable PsiClass aClass) {
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Cloneable");
    }

    public static boolean isDirectlyCloneable(@NotNull PsiClass aClass) {
        PsiClass[] interfaces;
        for (PsiClass anInterface : interfaces = aClass.getInterfaces()) {
            String qualifiedName;
            if (anInterface == null || !"java.lang.Cloneable".equals(qualifiedName = anInterface.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClone(@Nullable PsiMethod method) {
        PsiClassType javaLangObject;
        if (method == null) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)method)) {
            javaLangObject = TypeUtils.getObjectType((PsiElement)method);
        } else {
            if (method.getReturnType() instanceof PsiPrimitiveType) {
                return false;
            }
            javaLangObject = null;
        }
        return MethodUtils.methodMatches(method, null, (PsiType)javaLangObject, "clone", PsiType.EMPTY_ARRAY);
    }
}

