/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class StringBufferToStringInConcatenationInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String className2 = (String)infos[0];
        return InspectionGadgetsBundle.message("string.buffer.to.string.in.concatenation.problem.descriptor", className2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferToStringVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new StringBufferToStringFix();
    }

    private static class StringBufferToStringVisitor
    extends BaseInspectionVisitor {
        private StringBufferToStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!ExpressionUtils.isStringConcatenationOperand((PsiExpression)expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"toString".equals(referenceName)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (!parameterList.isEmpty()) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className2 = aClass.getQualifiedName();
            if (!"java.lang.StringBuffer".equals(className2) && !"java.lang.StringBuilder".equals(className2)) {
                return;
            }
            this.registerMethodCallError(expression2, aClass.getName());
        }
    }

    private static class StringBufferToStringFix
    extends InspectionGadgetsFix {
        private StringBufferToStringFix() {
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.remove", (Object[])new Object[]{"toString()"});
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodNameToken = descriptor.getPsiElement();
            PsiElement methodCallExpression = methodNameToken.getParent();
            assert (methodCallExpression != null);
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)methodCallExpression.getParent();
            assert (methodCall != null);
            PsiReferenceExpression expression2 = methodCall.getMethodExpression();
            PsiExpression qualifier = expression2.getQualifierExpression();
            assert (qualifier != null);
            CommentTracker commentTracker = new CommentTracker();
            String newExpression = commentTracker.text((PsiElement)qualifier);
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, newExpression, commentTracker);
        }
    }
}

