/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.io.PrintStream;
import java.util.Locale;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedundantStringFormatCallInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new RemoveRedundantStringFormatVisitor(holder, isOnTheFly, HighlightingFeature.TEXT_BLOCKS.isAvailable((PsiElement)holder.getFile()));
    }

    private static final class RemoveRedundantStringFormatVisitor
    extends JavaElementVisitor {
        private static final CallMatcher PRINTSTREAM_PRINTF = CallMatcher.instanceCall(PrintStream.class.getName(), "printf").parameterTypes(String.class.getName(), "java.lang.Object...");
        private static final CallMatcher PRINTSTREAM_PRINT = CallMatcher.instanceCall(PrintStream.class.getName(), "print").parameterTypes(String.class.getName());
        private static final CallMatcher PRINTSTREAM_PRINTLN = CallMatcher.instanceCall(PrintStream.class.getName(), "println").parameterTypes(String.class.getName());
        private static final CallMatcher STRING_FORMAT = CallMatcher.staticCall(String.class.getName(), "format");
        private static final CallMatcher STRING_FORMATTED = CallMatcher.instanceCall(String.class.getName(), "formatted").parameterTypes("java.lang.Object...");
        @NotNull
        private final CallMapper<ProblemDescriptor> myProcessors;
        @NotNull
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;
        @NotNull
        private final InspectionManager myManager;

        private RemoveRedundantStringFormatVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, boolean withTextBlocks) {
            this.myHolder = holder;
            this.myManager = this.myHolder.getManager();
            this.myIsOnTheFly = isOnTheFly;
            this.myProcessors = new CallMapper<Function<PsiMethodCallExpression, ProblemDescriptor>>().register(PRINTSTREAM_PRINTF, this::getRedundantPrintfProblem).register(STRING_FORMAT, this::getRedundantStringFormatProblem);
            if (withTextBlocks) {
                this.myProcessors.register(STRING_FORMATTED, (ProblemDescriptor)((Function<PsiMethodCallExpression, ProblemDescriptor>)this::getRedundantFormattedProblem));
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            ProblemDescriptor descriptor = this.myProcessors.mapFirst(call);
            if (descriptor != null) {
                this.myHolder.registerProblem(descriptor);
            }
        }

        @Nullable
        private ProblemDescriptor getRedundantPrintfProblem(@NotNull PsiMethodCallExpression call) {
            PsiExpressionList args = call.getArgumentList();
            if (args.getExpressionCount() != 1) {
                return null;
            }
            PsiElement methodNameReference = call.getMethodExpression().getReferenceNameElement();
            if (methodNameReference == null) {
                return null;
            }
            PsiExpression formatValue = args.getExpressions()[0];
            if (RemoveRedundantStringFormatVisitor.containsNewlineToken(formatValue)) {
                return null;
            }
            return this.myManager.createProblemDescriptor(methodNameReference, InspectionGadgetsBundle.message("redundant.call.problem.descriptor", new Object[0]), (LocalQuickFix)new ReplaceWithPrintFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myIsOnTheFly);
        }

        @Nullable
        private ProblemDescriptor getRedundantStringFormatProblem(@NotNull PsiMethodCallExpression call) {
            PsiElement methodNameReference = call.getMethodExpression().getReferenceNameElement();
            if (methodNameReference == null) {
                return null;
            }
            if (RemoveRedundantStringFormatVisitor.isStringFormatCallRedundant(call)) {
                return this.myManager.createProblemDescriptor(methodNameReference, InspectionGadgetsBundle.message("redundant.call.problem.descriptor", new Object[0]), (LocalQuickFix)new RemoveRedundantStringFormatFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myIsOnTheFly);
            }
            PsiMethodCallExpression printlnCall = RemoveRedundantStringFormatVisitor.getDirectParentMethod((PsiElement)call);
            boolean isPrintlnCall = PRINTSTREAM_PRINTLN.test(printlnCall);
            if (!isPrintlnCall && !PRINTSTREAM_PRINT.test(printlnCall)) {
                return null;
            }
            return this.myManager.createProblemDescriptor(methodNameReference, InspectionGadgetsBundle.message("redundant.call.problem.descriptor", new Object[0]), (LocalQuickFix)new ReplaceStringFormatWithPrintfFix(isPrintlnCall), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myIsOnTheFly);
        }

        @Nullable
        private ProblemDescriptor getRedundantFormattedProblem(@NotNull PsiMethodCallExpression call) {
            PsiElement methodNameReference = call.getMethodExpression().getReferenceNameElement();
            if (methodNameReference == null) {
                return null;
            }
            if (call.getArgumentList().getExpressionCount() == 0) {
                return this.myManager.createProblemDescriptor(methodNameReference, InspectionGadgetsBundle.message("redundant.call.problem.descriptor", new Object[0]), (LocalQuickFix)new RemoveRedundantStringFormattedFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myIsOnTheFly);
            }
            PsiMethodCallExpression printlnCall = RemoveRedundantStringFormatVisitor.getDirectParentMethod((PsiElement)call);
            boolean isPrintlnCall = PRINTSTREAM_PRINTLN.test(printlnCall);
            if (!isPrintlnCall && !PRINTSTREAM_PRINT.test(printlnCall)) {
                return null;
            }
            return this.myManager.createProblemDescriptor(methodNameReference, InspectionGadgetsBundle.message("redundant.call.problem.descriptor", new Object[0]), (LocalQuickFix)new ReplaceStringFormattedWithPrintfFix(isPrintlnCall), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myIsOnTheFly);
        }

        @Contract(pure=true)
        private static boolean isStringFormatCallRedundant(@NotNull PsiMethodCallExpression call) {
            PsiExpressionList params = call.getArgumentList();
            if (params.getExpressionCount() == 1) {
                return !RemoveRedundantStringFormatVisitor.containsNewlineToken(params.getExpressions()[0]);
            }
            if (params.getExpressionCount() == 2) {
                PsiExpression firstArg = params.getExpressions()[0];
                if (firstArg.getType() == null || !firstArg.getType().equalsToText(Locale.class.getName())) {
                    return false;
                }
                return !RemoveRedundantStringFormatVisitor.containsNewlineToken(params.getExpressions()[1]);
            }
            return false;
        }

        @Contract(value="null -> false")
        private static boolean containsNewlineToken(@Nullable PsiExpression expr2) {
            if (expr2 == null) {
                return false;
            }
            PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expr2);
            if (expression2 instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
                String expressionText = literalExpression.getText();
                return expressionText.contains("%n");
            }
            if (expression2 instanceof PsiPolyadicExpression) {
                PsiExpression[] operands2;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                if (!tokenType.equals(JavaTokenType.PLUS)) {
                    return false;
                }
                for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                    if (!RemoveRedundantStringFormatVisitor.containsNewlineToken(operand2)) continue;
                    return true;
                }
            }
            return false;
        }

        @Nullable
        private static PsiMethodCallExpression getDirectParentMethod(@Nullable PsiElement methodName) {
            if (methodName == null || methodName.getParent() == null) {
                return null;
            }
            if (!(methodName.getParent().getParent() instanceof PsiMethodCallExpression)) {
                return null;
            }
            return (PsiMethodCallExpression)methodName.getParent().getParent();
        }

        private static void addNewlineToFormatValue(@NotNull PsiExpressionList stringFormatArgs) {
            if (stringFormatArgs.getExpressionCount() == 0) {
                return;
            }
            PsiExpression formatValueArg = RemoveRedundantStringFormatVisitor.getArgWithFormatValue(stringFormatArgs);
            if (formatValueArg != null) {
                RemoveRedundantStringFormatVisitor.appendWithNewlineToken(formatValueArg);
            }
        }

        @Nullable
        @Contract(pure=true)
        private static PsiExpression getArgWithFormatValue(@NotNull PsiExpressionList stringFormatArgs) {
            PsiExpression firstFormatArg = stringFormatArgs.getExpressions()[0];
            if (firstFormatArg == null) {
                return null;
            }
            PsiType firstType = firstFormatArg.getType();
            if (firstType == null) {
                return null;
            }
            if (firstType.equalsToText(Locale.class.getName())) {
                if (stringFormatArgs.getExpressionCount() <= 1) {
                    return null;
                }
                PsiExpression secondFormatArg = stringFormatArgs.getExpressions()[1];
                if (secondFormatArg == null) {
                    return null;
                }
                PsiType secondType = secondFormatArg.getType();
                if (secondType == null || !secondType.equalsToText(String.class.getName())) {
                    return null;
                }
                return secondFormatArg;
            }
            if (firstType.equalsToText(String.class.getName())) {
                return firstFormatArg;
            }
            return null;
        }

        private static void appendWithNewlineToken(@NotNull PsiExpression expr2) {
            PsiExpression formatArg = PsiUtil.skipParenthesizedExprDown((PsiExpression)expr2);
            if (formatArg == null) {
                return;
            }
            String newLineToken = "%n";
            if (formatArg instanceof PsiLiteralExpression) {
                PsiLiteralExpression replacement = RemoveRedundantStringFormatVisitor.joinWithNewlineToken((PsiLiteralExpression)formatArg);
                formatArg.replace((PsiElement)replacement);
            } else if (formatArg instanceof PsiPolyadicExpression) {
                PsiElement lastChild = RemoveRedundantStringFormatVisitor.skipParenIfPossible(formatArg.getLastChild());
                if (lastChild instanceof PsiLiteralExpression) {
                    PsiLiteralExpression replacement = RemoveRedundantStringFormatVisitor.joinWithNewlineToken((PsiLiteralExpression)lastChild);
                    lastChild.replace((PsiElement)replacement);
                } else {
                    CommentTracker ct = new CommentTracker();
                    String text2 = String.format("%s + \"%s\"", ct.text((PsiElement)formatArg), "%n");
                    ct.replaceAndRestoreComments((PsiElement)formatArg, text2);
                }
            } else {
                CommentTracker ct = new CommentTracker();
                String text3 = String.format("(%s) + \"%s\"", ct.text((PsiElement)formatArg), "%n");
                ct.replaceAndRestoreComments((PsiElement)formatArg, text3);
            }
        }

        @Nullable
        private static PsiElement skipParenIfPossible(@NotNull PsiElement element) {
            if (!(element instanceof PsiExpression)) {
                return element;
            }
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)element));
        }

        @Contract(value="null -> null; !null -> !null", pure=true)
        private static PsiLiteralExpression joinWithNewlineToken(@Nullable PsiLiteralExpression expression2) {
            if (expression2 == null) {
                return null;
            }
            Object value2 = expression2.getValue();
            if (value2 == null) {
                return expression2;
            }
            StringBuilder newExpression = new StringBuilder();
            String leftText = value2.toString();
            if (expression2.isTextBlock()) {
                String indent = StringUtil.repeat((String)" ", (int)PsiLiteralUtil.getTextBlockIndent((PsiLiteralExpression)expression2));
                newExpression.append("\"\"\"").append('\n').append(indent);
                newExpression.append(leftText.replaceAll("\n", "\n" + indent));
                newExpression.append("%n");
                newExpression.append("\"\"\"");
            } else {
                newExpression.append('\"');
                newExpression.append(StringUtil.escapeStringCharacters((String)leftText));
                newExpression.append("%n");
                newExpression.append('\"');
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
            return (PsiLiteralExpression)factory.createExpressionFromText(newExpression.toString(), null);
        }

        private static void removeRedundantStringFormatCall(@NotNull PsiMethodCallExpression stringFormat) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)stringFormat.getParent());
            if (parent instanceof PsiExpressionList && ((PsiExpressionList)parent).getExpressionCount() == 1 && parent.getParent() instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression printCall = (PsiMethodCallExpression)parent.getParent();
                PsiExpression[] args = stringFormat.getArgumentList().getExpressions();
                if (args.length > 1) {
                    new CommentTracker().deleteAndRestoreComments((PsiElement)args[0]);
                }
                new CommentTracker().replaceAndRestoreComments((PsiElement)printCall.getArgumentList(), (PsiElement)stringFormat.getArgumentList());
            } else {
                CommentTracker ct = new CommentTracker();
                PsiExpression[] args = stringFormat.getArgumentList().getExpressions();
                PsiExpression element = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[args.length - 1]);
                if (element == null) {
                    return;
                }
                String expression2 = ct.text((PsiElement)element);
                ct.replaceAndRestoreComments((PsiElement)stringFormat, expression2);
            }
        }

        private static final class ReplaceStringFormattedWithPrintfFix
        implements LocalQuickFix {
            private static final Logger LOGGER = Logger.getInstance(ReplaceStringFormattedWithPrintfFix.class);
            private final boolean myIsPrintlnCall;

            private ReplaceStringFormattedWithPrintfFix(boolean isPrintlnCall) {
                this.myIsPrintlnCall = isPrintlnCall;
            }

            public @IntentionFamilyName @NotNull String getFamilyName() {
                return InspectionGadgetsBundle.message("redundant.string.formatted.call.quickfix", new Object[0]);
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiMethodCallExpression stringFormattedCall = RemoveRedundantStringFormatVisitor.getDirectParentMethod(descriptor.getPsiElement());
                if (stringFormattedCall == null) {
                    return;
                }
                PsiMethodCallExpression printlnCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)stringFormattedCall, PsiMethodCallExpression.class);
                if (printlnCall == null) {
                    return;
                }
                PsiExpression textBlock = stringFormattedCall.getMethodExpression().getQualifierExpression();
                if (textBlock == null) {
                    return;
                }
                PsiExpressionList formattedArgs = stringFormattedCall.getArgumentList();
                PsiExpression firstArg = formattedArgs.getExpressions()[0];
                CommentTracker ct = new CommentTracker();
                PsiElement element = formattedArgs.addBefore((PsiElement)ct.markUnchanged(textBlock), (PsiElement)firstArg);
                if (!(element instanceof PsiExpression)) {
                    LOGGER.error(String.format("The '%s' element after insertion is not instance of PsiExpression", element.getText()));
                    return;
                }
                if (this.myIsPrintlnCall) {
                    RemoveRedundantStringFormatVisitor.appendWithNewlineToken((PsiExpression)element);
                }
                ct.replaceAndRestoreComments((PsiElement)printlnCall.getArgumentList(), (PsiElement)formattedArgs);
                ExpressionUtils.bindCallTo(printlnCall, "printf");
            }
        }

        private static final class RemoveRedundantStringFormattedFix
        implements LocalQuickFix {
            private RemoveRedundantStringFormattedFix() {
            }

            public @IntentionFamilyName @NotNull String getFamilyName() {
                return InspectionGadgetsBundle.message("redundant.string.formatted.call.quickfix", new Object[0]);
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiMethodCallExpression stringFormattedCall = RemoveRedundantStringFormatVisitor.getDirectParentMethod(descriptor.getPsiElement());
                if (stringFormattedCall == null) {
                    return;
                }
                PsiExpression expression2 = stringFormattedCall.getMethodExpression().getQualifierExpression();
                if (expression2 != null) {
                    new CommentTracker().replaceAndRestoreComments((PsiElement)stringFormattedCall, (PsiElement)expression2);
                }
            }
        }

        private static final class ReplaceStringFormatWithPrintfFix
        implements LocalQuickFix {
            private final boolean myIsPrintlnCall;

            private ReplaceStringFormatWithPrintfFix(boolean isPrintlnCall) {
                this.myIsPrintlnCall = isPrintlnCall;
            }

            public @IntentionFamilyName @NotNull String getFamilyName() {
                return InspectionGadgetsBundle.message("redundant.string.format.call.quickfix", new Object[0]);
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiMethodCallExpression stringFormatCall = RemoveRedundantStringFormatVisitor.getDirectParentMethod(descriptor.getPsiElement());
                if (stringFormatCall == null) {
                    return;
                }
                PsiMethodCallExpression printlnCall = RemoveRedundantStringFormatVisitor.getDirectParentMethod((PsiElement)stringFormatCall);
                if (printlnCall == null) {
                    return;
                }
                PsiExpressionList stringFormatArgs = stringFormatCall.getArgumentList();
                if (this.myIsPrintlnCall) {
                    RemoveRedundantStringFormatVisitor.addNewlineToFormatValue(stringFormatArgs);
                }
                ExpressionUtils.bindCallTo(printlnCall, "printf");
                PsiExpressionList printlnArgs = printlnCall.getArgumentList();
                new CommentTracker().replaceAndRestoreComments((PsiElement)printlnArgs, (PsiElement)stringFormatArgs);
            }
        }

        private static final class RemoveRedundantStringFormatFix
        implements LocalQuickFix {
            private RemoveRedundantStringFormatFix() {
            }

            public @IntentionFamilyName @NotNull String getFamilyName() {
                return InspectionGadgetsBundle.message("redundant.string.format.call.quickfix", new Object[0]);
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiMethodCallExpression stringFormat = RemoveRedundantStringFormatVisitor.getDirectParentMethod(descriptor.getPsiElement());
                if (stringFormat != null) {
                    RemoveRedundantStringFormatVisitor.removeRedundantStringFormatCall(stringFormat);
                }
            }
        }

        private static final class ReplaceWithPrintFix
        implements LocalQuickFix {
            private ReplaceWithPrintFix() {
            }

            public @IntentionFamilyName @NotNull String getFamilyName() {
                return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"printf()", "print()"});
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiMethodCallExpression printStreamPrintfCall = RemoveRedundantStringFormatVisitor.getDirectParentMethod(descriptor.getPsiElement());
                if (printStreamPrintfCall == null) {
                    return;
                }
                ExpressionUtils.bindCallTo(printStreamPrintfCall, "print");
                PsiExpressionList argumentList = printStreamPrintfCall.getArgumentList();
                PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)argumentList.getExpressions()[0]);
                if (arg instanceof PsiMethodCallExpression && STRING_FORMAT.matches(arg) && RemoveRedundantStringFormatVisitor.isStringFormatCallRedundant((PsiMethodCallExpression)arg)) {
                    RemoveRedundantStringFormatVisitor.removeRedundantStringFormatCall((PsiMethodCallExpression)arg);
                }
            }
        }
    }
}

