/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomDoubleForRandomIntegerInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "UsingRandomNextDoubleForRandomInteger";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("random.double.for.random.integer.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RandomDoubleForRandomIntegerFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RandomDoubleForRandomIntegerVisitor();
    }

    @Nullable
    static PsiExpression getContainingExpression(PsiExpression expression2) {
        PsiElement ancestor = expression2.getParent();
        while (ancestor != null) {
            if (!(ancestor instanceof PsiExpression)) {
                return null;
            }
            if (!(ancestor instanceof PsiParenthesizedExpression)) {
                return (PsiExpression)ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    private static class RandomDoubleForRandomIntegerVisitor
    extends BaseInspectionVisitor {
        private RandomDoubleForRandomIntegerVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String nextDouble = "nextDouble";
            if (!"nextDouble".equals(methodName)) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className2 = containingClass.getQualifiedName();
            if (!"java.util.Random".equals(className2)) {
                return;
            }
            PsiExpression possibleMultiplierExpression = RandomDoubleForRandomIntegerInspection.getContainingExpression((PsiExpression)call);
            if (!RandomDoubleForRandomIntegerVisitor.isMultiplier(possibleMultiplierExpression)) {
                return;
            }
            PsiExpression possibleIntCastExpression = RandomDoubleForRandomIntegerInspection.getContainingExpression(possibleMultiplierExpression);
            if (!RandomDoubleForRandomIntegerVisitor.isIntCast(possibleIntCastExpression)) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static boolean isMultiplier(PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            if (!(expression2 instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            return JavaTokenType.ASTERISK.equals(tokenType);
        }

        private static boolean isIntCast(PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            if (!(expression2 instanceof PsiTypeCastExpression)) {
                return false;
            }
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)expression2;
            PsiType type2 = castExpression.getType();
            return PsiType.INT.equals((Object)type2);
        }
    }

    private static class RandomDoubleForRandomIntegerFix
    extends InspectionGadgetsFix {
        private RandomDoubleForRandomIntegerFix() {
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"nextInt()"});
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression multiplierExpression;
            PsiIdentifier name2 = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression2 = (PsiReferenceExpression)name2.getParent();
            if (expression2 == null) {
                return;
            }
            PsiExpression call = (PsiExpression)expression2.getParent();
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiBinaryExpression multiplication = (PsiBinaryExpression)RandomDoubleForRandomIntegerInspection.getContainingExpression(call);
            if (multiplication == null) {
                return;
            }
            PsiExpression cast = RandomDoubleForRandomIntegerInspection.getContainingExpression((PsiExpression)multiplication);
            if (cast == null) {
                return;
            }
            PsiExpression lhs = multiplication.getLOperand();
            PsiExpression strippedLhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)lhs);
            PsiExpression psiExpression = multiplierExpression = call.equals(strippedLhs) ? multiplication.getROperand() : lhs;
            assert (multiplierExpression != null);
            CommentTracker commentTracker = new CommentTracker();
            String multiplierText = commentTracker.text((PsiElement)multiplierExpression);
            PsiReplacementUtil.replaceExpression(cast, commentTracker.text((PsiElement)qualifier) + ".nextInt((int) " + multiplierText + ')', commentTracker);
        }
    }
}

