/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.performance.CanBeStaticVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.NotNull;

public class FieldMayBeStaticInspection
extends BaseInspection {
    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldMayBeStaticVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("field.may.be.static.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("static");
    }

    private static class FieldMayBeStaticVisitor
    extends BaseInspectionVisitor {
        private FieldMayBeStaticVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field.hasModifierProperty("static")) {
                return;
            }
            if (!field.hasModifierProperty("final")) {
                return;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(initializer)) {
                return;
            }
            PsiType type2 = field.getType();
            if (!ClassUtils.isImmutable(type2)) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass != null && !containingClass.hasModifierProperty("static") && containingClass.getContainingClass() != null && !PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
                return;
            }
            if (containingClass instanceof PsiAnonymousClass && !PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
                return;
            }
            if (!FieldMayBeStaticVisitor.canBeStatic(initializer)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static boolean canBeStatic(PsiExpression initializer) {
            CanBeStaticVisitor canBeStaticVisitor = new CanBeStaticVisitor();
            initializer.accept((PsiElementVisitor)canBeStaticVisitor);
            return canBeStaticVisitor.canBeStatic();
        }
    }
}

