/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArraysAsListWithZeroOrOneArgumentInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean isEmpty = (Boolean)infos[0];
        if (isEmpty.booleanValue()) {
            return InspectionGadgetsBundle.message("arrays.as.list.with.zero.arguments.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("arrays.as.list.with.one.argument.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean isEmpty = (Boolean)infos[0];
        return new ArraysAsListWithOneArgumentFix(isEmpty);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayAsListWithOneArgumentVisitor();
    }

    private static class ArrayAsListWithOneArgumentVisitor
    extends BaseInspectionVisitor {
        private ArrayAsListWithOneArgumentVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"asList".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 1) {
                return;
            }
            boolean empty = false;
            if (arguments.length == 0) {
                empty = true;
            } else {
                PsiExpression argument = arguments[0];
                if (!MethodCallUtils.isVarArgCall((PsiCall)expression2)) {
                    if (!ConstructionUtils.isEmptyArrayInitializer(argument)) {
                        return;
                    }
                    empty = true;
                }
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className2 = containingClass.getQualifiedName();
            if (!"java.util.Arrays".equals(className2)) {
                return;
            }
            this.registerMethodCallError(expression2, empty);
        }
    }

    private static class ArraysAsListWithOneArgumentFix
    extends InspectionGadgetsFix {
        private final boolean myEmpty;

        private ArraysAsListWithOneArgumentFix(boolean isEmpty) {
            this.myEmpty = isEmpty;
        }

        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myEmpty ? "Collections.emptyList()" : "Collections.singletonList()"});
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            String parameterText;
            PsiElement element = descriptor.getPsiElement().getParent().getParent();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiReferenceParameterList parameterList = methodExpression.getParameterList();
            CommentTracker commentTracker = new CommentTracker();
            String string = parameterText = parameterList != null ? commentTracker.text((PsiElement)parameterList) : "";
            if (this.myEmpty) {
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, "java.util.Collections." + parameterText + "emptyList()", commentTracker);
            } else {
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, "java.util.Collections." + parameterText + "singletonList" + commentTracker.text((PsiElement)argumentList), commentTracker);
            }
        }
    }
}

