/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageWithTooManyClassesInspection
extends BaseGlobalInspection {
    public int limit = 10;

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        List children = refEntity.getChildren();
        if (children.size() <= this.limit) {
            return null;
        }
        int numClasses = (int)children.stream().filter(c -> c instanceof RefClass).count();
        if (numClasses <= this.limit) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("package.with.too.many.classes.problem.descriptor", refEntity.getQualifiedName(), numClasses, this.limit);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("package.with.too.many.classes.max.option", new Object[0]), (InspectionProfileEntry)this, "limit");
    }
}

