/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessArithmeticExpressionInspection
extends BaseInspection {
    private static final Set<IElementType> arithmeticTokens = new THashSet(9);
    public boolean m_ignoreExpressionsContainingConstants = true;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", this.calculateReplacementExpression((PsiPolyadicExpression)infos[0], null));
    }

    @NonNls
    String calculateReplacementExpression(PsiPolyadicExpression expression2, @Nullable CommentTracker ct) {
        PsiExpression[] operands2 = expression2.getOperands();
        IElementType tokenType = expression2.getOperationTokenType();
        PsiType type2 = expression2.getType();
        List<PsiExpression> expressions2 = this.collectSalientOperands(operands2, tokenType, type2);
        PsiJavaToken token = expression2.getTokenBeforeOperand(operands2[1]);
        assert (token != null);
        String prefix = "";
        if (this.isZero(expressions2.get(0)) && expressions2.size() > 1 && JavaTokenType.MINUS == token.getTokenType()) {
            expressions2.remove(0);
            prefix = "- ";
        }
        String delimiter = " " + token.getText() + " ";
        String result = prefix + expressions2.stream().map(e -> ct == null ? e.getText() : ct.textWithComments((PsiElement)e)).collect(Collectors.joining(delimiter));
        boolean castToLongNeeded = ct != null && TypeConversionUtil.isLongType((PsiType)type2) && expressions2.stream().noneMatch(x -> TypeConversionUtil.isLongType((PsiType)x.getType()));
        return castToLongNeeded ? "(long)" + result : result;
    }

    @NotNull
    List<PsiExpression> collectSalientOperands(PsiExpression[] operands2, IElementType tokenType, PsiType type2) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)operands2[0].getProject());
        SmartList expressions2 = new SmartList();
        for (PsiExpression operand2 : operands2) {
            if (tokenType.equals(JavaTokenType.PLUS) && this.isZero(operand2) || tokenType.equals(JavaTokenType.MINUS) && this.isZero(operand2) && !expressions2.isEmpty() || tokenType.equals(JavaTokenType.ASTERISK) && this.isOne(operand2) || tokenType.equals(JavaTokenType.DIV) && this.isOne(operand2) && !expressions2.isEmpty()) continue;
            if (tokenType.equals(JavaTokenType.MINUS) && !expressions2.isEmpty() && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)expressions2.get(0), operand2)) {
                expressions2.remove(0);
                expressions2.add(0, factory.createExpressionFromText(PsiType.LONG.equals((Object)type2) ? "0L" : "0", (PsiElement)operand2));
                continue;
            }
            if (tokenType.equals(JavaTokenType.DIV) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ContainerUtil.getLastItem((List)expressions2), operand2)) {
                expressions2.remove(expressions2.size() - 1);
                expressions2.add(factory.createExpressionFromText(PsiType.LONG.equals((Object)type2) ? "1L" : "1", (PsiElement)operand2));
                continue;
            }
            if (tokenType.equals(JavaTokenType.ASTERISK) && this.isZero(operand2) || tokenType.equals(JavaTokenType.PERC) && (this.isOne(operand2) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ContainerUtil.getLastItem((List)expressions2), operand2))) {
                expressions2.clear();
                expressions2.add(factory.createExpressionFromText(PsiType.LONG.equals((Object)type2) ? "0L" : "0", (PsiElement)operand2));
                return expressions2;
            }
            expressions2.add(operand2);
        }
        if (expressions2.isEmpty()) {
            String value2 = tokenType.equals(JavaTokenType.ASTERISK) ? "1" : "0";
            expressions2.add(factory.createExpressionFromText(PsiType.LONG.equals((Object)type2) ? value2 + "L" : value2, (PsiElement)operands2[0]));
        }
        return expressions2;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessArithmeticFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessArithmeticVisitor();
    }

    boolean isZero(PsiExpression expression2) {
        if (this.m_ignoreExpressionsContainingConstants && PsiUtil.deparenthesizeExpression((PsiExpression)expression2) instanceof PsiReferenceExpression) {
            return false;
        }
        return ExpressionUtils.isZero(expression2);
    }

    boolean isOne(PsiExpression expression2) {
        if (this.m_ignoreExpressionsContainingConstants && PsiUtil.deparenthesizeExpression((PsiExpression)expression2) instanceof PsiReferenceExpression) {
            return false;
        }
        return ExpressionUtils.isOne(expression2);
    }

    static {
        arithmeticTokens.add(JavaTokenType.PLUS);
        arithmeticTokens.add(JavaTokenType.MINUS);
        arithmeticTokens.add(JavaTokenType.ASTERISK);
        arithmeticTokens.add(JavaTokenType.DIV);
        arithmeticTokens.add(JavaTokenType.PERC);
        arithmeticTokens.add(JavaTokenType.GT);
        arithmeticTokens.add(JavaTokenType.LT);
        arithmeticTokens.add(JavaTokenType.LE);
        arithmeticTokens.add(JavaTokenType.GE);
    }

    private class PointlessArithmeticVisitor
    extends BaseInspectionVisitor {
        private PointlessArithmeticVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            PsiType expressionType = expression2.getType();
            if (expressionType == null || PsiType.DOUBLE.equals((Object)expressionType) || PsiType.FLOAT.equals((Object)expressionType)) {
                return;
            }
            if (!arithmeticTokens.contains(expression2.getOperationTokenType())) {
                return;
            }
            if (ExpressionUtils.hasStringType((PsiExpression)expression2) || PsiUtilCore.hasErrorElementChild((PsiElement)expression2)) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            IElementType tokenType = expression2.getOperationTokenType();
            boolean isPointless = tokenType.equals(JavaTokenType.PLUS) ? this.additionExpressionIsPointless(operands2) : (tokenType.equals(JavaTokenType.MINUS) ? this.subtractionExpressionIsPointless(operands2) : (tokenType.equals(JavaTokenType.ASTERISK) ? this.multiplyExpressionIsPointless(operands2) : (tokenType.equals(JavaTokenType.DIV) || tokenType.equals(JavaTokenType.PERC) ? this.divideExpressionIsPointless(operands2) : false)));
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private boolean subtractionExpressionIsPointless(PsiExpression[] expressions2) {
            PsiExpression firstExpression = expressions2[0];
            if (PointlessArithmeticExpressionInspection.this.isZero(firstExpression)) {
                return true;
            }
            for (int i = 1; i < expressions2.length; ++i) {
                PsiExpression expression2 = expressions2[i];
                if (!PointlessArithmeticExpressionInspection.this.isZero(expression2) && !this.areExpressionsIdenticalWithoutSideEffects(firstExpression, expression2)) continue;
                return true;
            }
            return false;
        }

        private boolean additionExpressionIsPointless(PsiExpression[] expressions2) {
            for (PsiExpression expression2 : expressions2) {
                if (!PointlessArithmeticExpressionInspection.this.isZero(expression2)) continue;
                return true;
            }
            return false;
        }

        private boolean multiplyExpressionIsPointless(PsiExpression[] expressions2) {
            for (PsiExpression expression2 : expressions2) {
                if (!PointlessArithmeticExpressionInspection.this.isZero(expression2) && !PointlessArithmeticExpressionInspection.this.isOne(expression2)) continue;
                return true;
            }
            return false;
        }

        private boolean divideExpressionIsPointless(PsiExpression[] expressions2) {
            PsiExpression previousExpression = null;
            for (int i = 0; i < expressions2.length; ++i) {
                PsiExpression expression2 = expressions2[i];
                if (previousExpression != null && (PointlessArithmeticExpressionInspection.this.isOne(expression2) || i == 1 && this.areExpressionsIdenticalWithoutSideEffects(previousExpression, expression2) && !PointlessArithmeticExpressionInspection.this.isZero(expression2))) {
                    return true;
                }
                previousExpression = expression2;
            }
            return false;
        }

        private boolean areExpressionsIdenticalWithoutSideEffects(PsiExpression expression1, PsiExpression expression2) {
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(expression1, expression2) && !SideEffectChecker.mayHaveSideEffects(expression1);
        }
    }

    private class PointlessArithmeticFix
    extends InspectionGadgetsFix {
        private PointlessArithmeticFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element;
            CommentTracker tracker = new CommentTracker();
            tracker.replaceExpressionAndRestoreComments((PsiExpression)expression2, PointlessArithmeticExpressionInspection.this.calculateReplacementExpression(expression2, tracker));
        }
    }
}

