/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitNumericConversionInspection
extends BaseInspection {
    public boolean ignoreWideningConversions = false;
    public boolean ignoreCharConversions = false;
    public boolean ignoreConstantConversions = false;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.widening.conversion.option", new Object[0]), "ignoreWideningConversions");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.char.conversion.option", new Object[0]), "ignoreCharConversions");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.constant.conversion.option", new Object[0]), "ignoreConstantConversions");
        return optionsPanel;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[1];
        PsiType expectedType = (PsiType)infos[2];
        return InspectionGadgetsBundle.message(infos[0] instanceof PsiAssignmentExpression ? "implicit.numeric.conversion.assignment.problem.descriptor" : "implicit.numeric.conversion.problem.descriptor", type2.getPresentableText(), expectedType.getPresentableText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitNumericConversionVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ImplicitNumericConversionFix((PsiExpression)infos[0], (PsiType)infos[2]);
    }

    private static boolean isCharConversion(PsiType expressionType, PsiType convertedType) {
        return PsiType.CHAR.equals((Object)expressionType) && !PsiType.FLOAT.equals((Object)convertedType) && !PsiType.DOUBLE.equals((Object)convertedType) || PsiType.CHAR.equals((Object)convertedType) && !PsiType.FLOAT.equals((Object)expressionType) && !PsiType.DOUBLE.equals((Object)expressionType);
    }

    private class ImplicitNumericConversionVisitor
    extends BaseInspectionVisitor {
        private ImplicitNumericConversionVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            super.visitUnaryExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
            super.visitArrayAccessExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            super.visitParenthesizedExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        private void checkExpression(PsiExpression expression2) {
            PsiAssignmentExpression assignmentExpression;
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiParenthesizedExpression) {
                return;
            }
            if (parent instanceof PsiAssignmentExpression && (assignmentExpression = (PsiAssignmentExpression)parent).getOperationTokenType() != JavaTokenType.EQ) {
                PsiExpression rhs;
                if (assignmentExpression.getLExpression() == expression2 && (rhs = assignmentExpression.getRExpression()) != null) {
                    PsiType expressionType = expression2.getType();
                    if (!ClassUtils.isPrimitiveNumericType(expressionType)) {
                        return;
                    }
                    PsiType rhsType = rhs.getType();
                    if (!ClassUtils.isPrimitiveNumericType(rhsType)) {
                        return;
                    }
                    PsiType promotedType = TypeConversionUtil.binaryNumericPromotion((PsiType)expressionType, (PsiType)rhsType);
                    if (this.checkTypes((PsiExpression)assignmentExpression, promotedType, expressionType)) {
                        return;
                    }
                    if (ImplicitNumericConversionInspection.this.ignoreWideningConversions) {
                        return;
                    }
                    this.checkTypes(rhs, rhsType, promotedType);
                }
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreWideningConversions) {
                return;
            }
            PsiType expressionType = expression2.getType();
            if (!ClassUtils.isPrimitiveNumericType(expressionType)) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression2, true);
            if (!ClassUtils.isPrimitiveNumericType(expectedType)) {
                return;
            }
            this.checkTypes(expression2, expressionType, expectedType);
        }

        private boolean checkTypes(PsiExpression expression2, PsiType expressionType, PsiType convertedType) {
            if (expressionType.equals(convertedType)) {
                return false;
            }
            if (ImplicitNumericConversionInspection.this.ignoreConstantConversions) {
                PsiExpression rootExpression = expression2;
                while (rootExpression instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)rootExpression;
                    rootExpression = parenthesizedExpression.getExpression();
                }
                if (rootExpression instanceof PsiLiteralExpression || PsiUtil.isConstantExpression((PsiExpression)rootExpression)) {
                    return false;
                }
            }
            if (ImplicitNumericConversionInspection.this.ignoreCharConversions && ImplicitNumericConversionInspection.isCharConversion(expressionType, convertedType)) {
                return false;
            }
            this.registerError((PsiElement)(expression2 instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)expression2).getLExpression() : expression2), expression2, expressionType, convertedType);
            return true;
        }
    }

    private class ImplicitNumericConversionFix
    extends InspectionGadgetsFix {
        private final String m_name;

        ImplicitNumericConversionFix(PsiExpression expression2, PsiType expectedType) {
            String convertedExpression = this.convertExpression(expression2, expectedType);
            this.m_name = convertedExpression != null ? CommonQuickFixBundle.message((String)"fix.convert.to.x", (Object[])new Object[]{convertedExpression}) : InspectionGadgetsBundle.message("implicit.numeric.conversion.make.explicit.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("implicit.numeric.conversion.make.explicit.quickfix", new Object[0]);
        }

        @NotNull
        public String getName() {
            return this.m_name;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression expression2 = (PsiExpression)descriptor.getPsiElement();
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression2, true);
            if (expectedType == null) {
                return;
            }
            String convertedExpression = this.convertExpression(expression2, expectedType);
            if (convertedExpression != null) {
                PsiReplacementUtil.replaceExpression(expression2, convertedExpression);
            } else {
                PsiAssignmentExpression assignmentExpression;
                PsiJavaToken sign;
                PsiElement parent = expression2.getParent();
                if (parent instanceof PsiAssignmentExpression && !JavaTokenType.EQ.equals((sign = (assignmentExpression = (PsiAssignmentExpression)parent).getOperationSign()).getTokenType())) {
                    this.replaceCompoundAssignment(assignmentExpression);
                    return;
                }
                CommentTracker commentTracker = new CommentTracker();
                String castExpression = '(' + expectedType.getCanonicalText() + ')' + commentTracker.text(expression2, 4);
                PsiReplacementUtil.replaceExpression(expression2, castExpression, commentTracker);
            }
        }

        private void replaceCompoundAssignment(PsiAssignmentExpression assignmentExpression) {
            boolean cast;
            PsiJavaToken sign = assignmentExpression.getOperationSign();
            if (JavaTokenType.EQ.equals(sign.getTokenType())) {
                throw new IllegalArgumentException();
            }
            CommentTracker commentTracker = new CommentTracker();
            PsiExpression lhs = assignmentExpression.getLExpression();
            String lhsText = commentTracker.text((PsiElement)lhs);
            StringBuilder builder = new StringBuilder();
            builder.append(lhsText).append('=');
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return;
            }
            PsiType promotedType = TypeConversionUtil.binaryNumericPromotion((PsiType)assignmentExpression.getType(), (PsiType)rhsType);
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return;
            }
            boolean bl = cast = !promotedType.equals(lhsType);
            if (cast) {
                builder.append('(').append(lhsType.getCanonicalText()).append(")(");
                if (!(ImplicitNumericConversionInspection.this.ignoreWideningConversions || ImplicitNumericConversionInspection.this.ignoreCharConversions && ImplicitNumericConversionInspection.isCharConversion(lhsType, promotedType))) {
                    builder.append("(").append(promotedType.getCanonicalText()).append(')');
                }
            }
            builder.append(lhsText);
            builder.append(sign.getText().charAt(0));
            if (!(ImplicitNumericConversionInspection.this.ignoreWideningConversions || promotedType.equals(rhsType) || ImplicitNumericConversionInspection.this.ignoreCharConversions && ImplicitNumericConversionInspection.isCharConversion(rhsType, promotedType))) {
                builder.append('(').append(promotedType.getCanonicalText()).append(')');
            }
            builder.append(commentTracker.text((PsiElement)rhs));
            if (cast) {
                builder.append(')');
            }
            String newExpressionText = builder.toString();
            PsiReplacementUtil.replaceExpression((PsiExpression)assignmentExpression, newExpressionText, commentTracker);
        }

        @Nullable
        @NonNls
        private String convertExpression(PsiExpression expression2, PsiType expectedType) {
            if (!((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiLiteralExpression) && !this.isNegatedLiteral(expression2)) {
                return null;
            }
            PsiType expressionType = expression2.getType();
            if (expressionType == null) {
                return null;
            }
            String text2 = expression2.getText();
            if (expressionType.equals(PsiType.INT) && expectedType.equals(PsiType.LONG)) {
                return text2 + 'L';
            }
            if (expressionType.equals(PsiType.INT) && expectedType.equals(PsiType.FLOAT)) {
                if (!this.isDecimalLiteral(text2)) {
                    return null;
                }
                return text2 + ".0F";
            }
            if (expressionType.equals(PsiType.INT) && expectedType.equals(PsiType.DOUBLE)) {
                if (!this.isDecimalLiteral(text2)) {
                    return null;
                }
                return text2 + ".0";
            }
            if (expressionType.equals(PsiType.LONG) && expectedType.equals(PsiType.FLOAT)) {
                if (!this.isDecimalLiteral(text2)) {
                    return null;
                }
                return text2.substring(0, text2.length() - 1) + ".0F";
            }
            if (expressionType.equals(PsiType.LONG) && expectedType.equals(PsiType.DOUBLE)) {
                if (!this.isDecimalLiteral(text2)) {
                    return null;
                }
                return text2.substring(0, text2.length() - 1) + ".0";
            }
            if (expressionType.equals(PsiType.DOUBLE) && expectedType.equals(PsiType.FLOAT)) {
                int length = text2.length();
                if (text2.charAt(length - 1) == 'd' || text2.charAt(length - 1) == 'D') {
                    return text2.substring(0, length - 1) + 'F';
                }
                return text2 + 'F';
            }
            if (expressionType.equals(PsiType.FLOAT) && expectedType.equals(PsiType.DOUBLE)) {
                int length = text2.length();
                return text2.substring(0, length - 1);
            }
            return null;
        }

        private boolean isDecimalLiteral(String text2) {
            return text2.length() > 0 && text2.charAt(0) != '0';
        }

        private boolean isNegatedLiteral(PsiExpression expression2) {
            if (!(expression2 instanceof PsiPrefixExpression)) {
                return false;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.MINUS.equals(tokenType)) {
                return false;
            }
            PsiExpression operand2 = prefixExpression.getOperand();
            return operand2 instanceof PsiLiteralExpression;
        }
    }
}

