/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CharUsedInArithmeticContextInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("char.used.in.arithmetic.context.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        PsiExpression binaryExpression;
        PsiType type2;
        ArrayList<InspectionGadgetsFix> result = new ArrayList<InspectionGadgetsFix>();
        PsiElement expression2 = (PsiElement)infos[0];
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (parent instanceof PsiExpression && (type2 = (binaryExpression = (PsiExpression)parent).getType()) instanceof PsiPrimitiveType && !type2.equals(PsiType.CHAR)) {
            String typeText = type2.getCanonicalText();
            result.add(new CharUsedInArithmeticContentCastFix(typeText));
        }
        if (!(expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiParenthesizedExpression && PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)expression2)) instanceof PsiLiteralExpression)) {
            return result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        }
        while (parent instanceof PsiPolyadicExpression) {
            if (ExpressionUtils.hasStringType((PsiExpression)parent)) {
                result.add(new CharUsedInArithmeticContentFix());
                break;
            }
            parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        }
        return result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CharUsedInArithmeticContextVisitor();
    }

    private static class CharUsedInArithmeticContextVisitor
    extends BaseInspectionVisitor {
        private CharUsedInArithmeticContextVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (ComparisonUtils.isComparisonOperation(tokenType)) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            PsiType leftType = operands2[0].getType();
            for (int i = 1; i < operands2.length; ++i) {
                PsiExpression operand2 = operands2[i];
                PsiType rightType = operand2.getType();
                PsiType expressionType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)leftType, (PsiType)rightType, (IElementType)tokenType, (boolean)true);
                if (TypeUtils.isJavaLangString(expressionType)) {
                    return;
                }
                if (PsiType.CHAR.equals((Object)rightType)) {
                    this.registerError((PsiElement)operand2, operand2);
                }
                if (PsiType.CHAR.equals((Object)leftType) && i == 1) {
                    this.registerError((PsiElement)operands2[0], operands2[0]);
                }
                leftType = rightType;
            }
        }
    }

    private static class CharUsedInArithmeticContentCastFix
    extends InspectionGadgetsFix {
        private final String typeText;

        CharUsedInArithmeticContentCastFix(String typeText) {
            this.typeText = typeText;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("char.used.in.arithmetic.context.cast.quickfix", this.typeText);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("char.used.in.arithmetic.content.cast.fix.family.name", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression2 = (PsiExpression)element;
            CommentTracker commentTracker = new CommentTracker();
            String expressionText = commentTracker.text((PsiElement)expression2);
            PsiReplacementUtil.replaceExpression(expression2, '(' + this.typeText + ')' + expressionText, commentTracker);
        }
    }

    private static class CharUsedInArithmeticContentFix
    extends InspectionGadgetsFix {
        private CharUsedInArithmeticContentFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("char.used.in.arithmetic.context.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            Object literal = literalExpression.getValue();
            if (!(literal instanceof Character)) {
                return;
            }
            String escaped = StringUtil.escapeStringCharacters((String)literal.toString());
            PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, '\"' + escaped + '\"');
        }
    }
}

