/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class BigDecimalMethodWithoutRoundingCalledInspection
extends BaseInspection {
    static final CallMatcher JAVA_MATH_BIG_DECIMAL = CallMatcher.instanceCall("java.math.BigDecimal", "setScale", "divide").parameterCount(1);

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("big.decimal.method.without.rounding.called.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BigDecimalMethodWithoutRoundingCalledVisitor();
    }

    private static class BigDecimalMethodWithoutRoundingCalledVisitor
    extends BaseInspectionVisitor {
        private BigDecimalMethodWithoutRoundingCalledVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (JAVA_MATH_BIG_DECIMAL.test(expression2)) {
                this.registerMethodCallError(expression2, new Object[0]);
            }
        }
    }
}

