/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class BigDecimalEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("big.decimal.equals.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new BigDecimalEqualsFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BigDecimalEqualsVisitor();
    }

    private static class BigDecimalEqualsVisitor
    extends BaseInspectionVisitor {
        private BigDecimalEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            EqualityCheck check = EqualityCheck.from((PsiExpression)expression2);
            if (check == null) {
                return;
            }
            PsiExpression left = check.getLeft();
            PsiExpression right = check.getRight();
            if (!ExpressionUtils.hasType(left, "java.math.BigDecimal")) {
                return;
            }
            if (!ExpressionUtils.hasType(right, "java.math.BigDecimal")) {
                return;
            }
            if (ExpressionUtils.isVoidContext((PsiExpression)expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }

    private static class BigDecimalEqualsFix
    extends InspectionGadgetsFix {
        private BigDecimalEqualsFix() {
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"compareTo()==0"});
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class);
            EqualityCheck check = EqualityCheck.from((PsiExpression)call);
            if (check == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String qualifierText = commentTracker.text(check.getLeft(), 1);
            String argText = commentTracker.text((PsiElement)check.getRight());
            String replacement = qualifierText + ".compareTo(" + argText + ")==0";
            if (!check.isLeftDereferenced() && NullabilityUtil.getExpressionNullability(check.getLeft(), true) != Nullability.NOT_NULL) {
                replacement = commentTracker.text(check.getLeft(), 9) + "!=null && " + replacement;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)call, replacement, commentTracker);
        }
    }
}

