/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.AbstractNamingConventionInspection;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class NewMethodNamingConventionInspection
extends AbstractNamingConventionInspection<PsiMethod> {
    public static final ExtensionPointName<NamingConvention<PsiMethod>> EP_NAME = ExtensionPointName.create((String)"com.intellij.naming.convention.method");

    public NewMethodNamingConventionInspection() {
        super((Iterable)EP_NAME.getExtensionList(), "InstanceMethodNamingConvention");
        this.registerConventionsListener(EP_NAME);
    }

    protected LocalQuickFix createRenameFix() {
        return new RenameFix();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!(holder.getFile() instanceof PsiClassOwner)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                if (method.isConstructor()) {
                    return;
                }
                if (!isOnTheFly && MethodUtils.hasSuper(method)) {
                    return;
                }
                if (LibraryUtil.isOverrideOfLibraryMethod(method)) {
                    return;
                }
                String name2 = method.getName();
                NewMethodNamingConventionInspection.this.checkName((PsiNameIdentifierOwner)method, name2, holder);
            }
        };
    }
}

