/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.AbstractNamingConventionInspection;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class NewClassNamingConventionInspection
extends AbstractNamingConventionInspection<PsiClass> {
    public static final ExtensionPointName<NamingConvention<PsiClass>> EP_NAME = ExtensionPointName.create((String)"com.intellij.naming.convention.class");

    public NewClassNamingConventionInspection() {
        super((Iterable)EP_NAME.getExtensionList(), "ClassNamingConvention");
        this.registerConventionsListener(EP_NAME);
    }

    protected LocalQuickFix createRenameFix() {
        return new RenameFix();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!(holder.getFile() instanceof PsiClassOwner)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                String name2 = aClass.getName();
                if (name2 == null) {
                    return;
                }
                NewClassNamingConventionInspection.this.checkName((PsiNameIdentifierOwner)aClass, name2, holder);
            }
        };
    }
}

