/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NCSSVisitor;
import org.jetbrains.annotations.NotNull;

public class NonCommentSourceStatementsInspection
extends MethodMetricInspection {
    private static final int DEFAULT_LIMIT = 30;

    @NotNull
    public String getID() {
        return "OverlyLongMethod";
    }

    @Override
    protected int getDefaultLimit() {
        return 30;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("non.comment.source.statements.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer statementCount = (Integer)infos[0];
        return InspectionGadgetsBundle.message("non.comment.source.statements.problem.descriptor", statementCount);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonCommentSourceStatementsMethodVisitor();
    }

    private class NonCommentSourceStatementsMethodVisitor
    extends BaseInspectionVisitor {
        private NonCommentSourceStatementsMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method.getNameIdentifier() == null) {
                return;
            }
            NCSSVisitor visitor2 = new NCSSVisitor();
            method.accept((PsiElementVisitor)visitor2);
            int count = visitor2.getStatementCount();
            if (count <= NonCommentSourceStatementsInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, count);
        }
    }
}

