/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.LoopCountVisitor;
import org.jetbrains.annotations.NotNull;

public class MethodWithMultipleLoopsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer negationCount = (Integer)infos[0];
        return InspectionGadgetsBundle.message("method.with.multiple.loops.problem.descriptor", negationCount);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodWithMultipleLoopsVisitor();
    }

    private static class MethodWithMultipleLoopsVisitor
    extends BaseInspectionVisitor {
        private MethodWithMultipleLoopsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method.getNameIdentifier() == null) {
                return;
            }
            LoopCountVisitor visitor2 = new LoopCountVisitor();
            method.accept((PsiElementVisitor)visitor2);
            int negationCount = visitor2.getCount();
            if (negationCount <= 1) {
                return;
            }
            this.registerMethodError(method, negationCount);
        }
    }
}

