/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class StringBufferFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        String typeName = type2.getPresentableText();
        return InspectionGadgetsBundle.message("stringbuffer.field.problem.descriptor", typeName);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferFieldVisitor();
    }

    private static class StringBufferFieldVisitor
    extends BaseInspectionVisitor {
        private StringBufferFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            PsiType type2 = field.getType();
            if (!type2.equalsToText("java.lang.StringBuffer") && !type2.equalsToText("java.lang.StringBuilder")) {
                return;
            }
            this.registerFieldError(field, type2);
        }
    }
}

