/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceEmptyArrayToConstantFix
extends InspectionGadgetsFix {
    private final String myText;
    private final String myName;

    public ReplaceEmptyArrayToConstantFix(PsiClass aClass, PsiField field) {
        this.myText = aClass.getQualifiedName() + "." + field.getName();
        this.myName = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{aClass.getName() + "." + field.getName()});
    }

    @Nls
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("constant.for.zero.length.array.quickfix.family", new Object[0]);
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiExpression newExp = JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(this.myText, descriptor.getPsiElement());
        PsiElement element = descriptor.getPsiElement().replace((PsiElement)newExp);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element);
    }
}

