/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SerializationFilterBase;
import com.intellij.util.xmlb.XmlSerializer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.ui.UiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggerInitializedWithForeignClassInspection
extends BaseInspection {
    @NonNls
    private static final String DEFAULT_FACTORY_CLASS_NAMES = "org.apache.log4j.Logger,org.slf4j.LoggerFactory,org.apache.commons.logging.LogFactory,java.util.logging.Logger,org.apache.logging.log4j.LogManager";
    @NonNls
    private static final String DEFAULT_FACTORY_METHOD_NAMES = "getLogger,getLogger,getLog,getLogger,getLogger";
    protected final List<String> loggerFactoryClassNames = new ArrayList<String>();
    protected final List<String> loggerFactoryMethodNames = new ArrayList<String>();
    public String loggerClassName = "org.apache.log4j.Logger,org.slf4j.LoggerFactory,org.apache.commons.logging.LogFactory,java.util.logging.Logger,org.apache.logging.log4j.LogManager";
    public String loggerFactoryMethodName = "getLogger,getLogger,getLog,getLogger,getLogger";

    public LoggerInitializedWithForeignClassInspection() {
        LoggerInitializedWithForeignClassInspection.parseString(this.loggerClassName, this.loggerFactoryClassNames);
        LoggerInitializedWithForeignClassInspection.parseString(this.loggerFactoryMethodName, this.loggerFactoryMethodNames);
    }

    public JComponent createOptionsPanel() {
        ListTable table = new ListTable(new ListWrappingTableModel(Arrays.asList(this.loggerFactoryClassNames, this.loggerFactoryMethodNames), new String[]{InspectionGadgetsBundle.message("logger.factory.class.name", new Object[0]), InspectionGadgetsBundle.message("logger.factory.method.name", new Object[0])}));
        return UiUtils.createAddRemoveTreeClassChooserPanel(table, "Choose logger factory class", new String[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LoggerInitializedWithForeignClassFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoggerInitializedWithForeignClassVisitor();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        LoggerInitializedWithForeignClassInspection.parseString(this.loggerClassName, this.loggerFactoryClassNames);
        LoggerInitializedWithForeignClassInspection.parseString(this.loggerFactoryMethodName, this.loggerFactoryMethodNames);
        if (this.loggerFactoryClassNames.size() != this.loggerFactoryMethodNames.size() || this.loggerFactoryClassNames.isEmpty()) {
            LoggerInitializedWithForeignClassInspection.parseString(DEFAULT_FACTORY_CLASS_NAMES, this.loggerFactoryClassNames);
            LoggerInitializedWithForeignClassInspection.parseString(DEFAULT_FACTORY_METHOD_NAMES, this.loggerFactoryMethodNames);
        }
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.loggerClassName = LoggerInitializedWithForeignClassInspection.formatString(this.loggerFactoryClassNames);
        this.loggerFactoryMethodName = LoggerInitializedWithForeignClassInspection.formatString(this.loggerFactoryMethodNames);
        if (this.loggerFactoryMethodName.equals(DEFAULT_FACTORY_METHOD_NAMES) && this.loggerClassName.equals(DEFAULT_FACTORY_CLASS_NAMES)) {
            this.loggerFactoryMethodName = "getLogger,getLogger,getLog,getLogger";
        }
        XmlSerializer.serializeInto((Object)((Object)this), (Element)element, (SerializationFilter)new SerializationFilterBase(){

            protected boolean accepts(@NotNull Accessor accessor, @NotNull Object bean, @Nullable Object beanValue) {
                if ("loggerClassName".equals(accessor.getName()) && LoggerInitializedWithForeignClassInspection.DEFAULT_FACTORY_CLASS_NAMES.equals(beanValue)) {
                    return false;
                }
                return !"loggerFactoryMethodNames".equals(accessor.getName()) || !LoggerInitializedWithForeignClassInspection.DEFAULT_FACTORY_METHOD_NAMES.equals(beanValue);
            }
        });
    }

    private class LoggerInitializedWithForeignClassVisitor
    extends BaseInspectionVisitor {
        private LoggerInitializedWithForeignClassVisitor() {
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
            super.visitClassObjectAccessExpression(expression2);
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
                if (!expression2.equals(referenceExpression.getQualifierExpression())) {
                    return;
                }
                String name2 = referenceExpression.getReferenceName();
                if (!"getName".equals(name2)) {
                    return;
                }
                PsiElement grandParent = referenceExpression.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                PsiExpressionList list = methodCallExpression.getArgumentList();
                if (!list.isEmpty()) {
                    return;
                }
                parent = methodCallExpression.getParent();
            }
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions2 = argumentList.getExpressions();
            if (expressions2.length != 1) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression2);
            while (containingClass instanceof PsiAnonymousClass) {
                containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
            }
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getName();
            if (containingClassName == null) {
                return;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className2 = aClass.getQualifiedName();
            int index = LoggerInitializedWithForeignClassInspection.this.loggerFactoryClassNames.indexOf(className2);
            if (index < 0) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            String loggerFactoryMethodName = LoggerInitializedWithForeignClassInspection.this.loggerFactoryMethodNames.get(index);
            if (!loggerFactoryMethodName.equals(referenceName)) {
                return;
            }
            PsiTypeElement operand2 = expression2.getOperand();
            PsiClass initializerClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)operand2.getType());
            if (initializerClass == null) {
                return;
            }
            if (containingClass.equals(initializerClass)) {
                return;
            }
            this.registerError((PsiElement)expression2, containingClassName);
        }
    }

    private static class LoggerInitializedWithForeignClassFix
    extends InspectionGadgetsFix {
        private final String newClassName;

        private LoggerInitializedWithForeignClassFix(String newClassName) {
            this.newClassName = newClassName;
        }

        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.newClassName + ".class"});
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.fix.family.name", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)element;
            PsiReplacementUtil.replaceExpression((PsiExpression)classObjectAccessExpression, this.newClassName + ".class", new CommentTracker());
        }
    }
}

