/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoBoxingInspection
extends BaseInspection {
    public boolean ignoreAddedToCollection = false;
    @NonNls
    static final Map<String, String> s_boxingClasses = new HashMap<String, String>(8);

    public String getAlternativeID() {
        return "boxing";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("auto.boxing.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("auto.boxing.ignore.added.to.collection.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAddedToCollection");
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AutoBoxingVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length == 0) {
            return null;
        }
        return new AutoBoxingFix();
    }

    static {
        s_boxingClasses.put("byte", "java.lang.Byte");
        s_boxingClasses.put("short", "java.lang.Short");
        s_boxingClasses.put("int", "java.lang.Integer");
        s_boxingClasses.put("long", "java.lang.Long");
        s_boxingClasses.put("float", "java.lang.Float");
        s_boxingClasses.put("double", "java.lang.Double");
        s_boxingClasses.put("boolean", "java.lang.Boolean");
        s_boxingClasses.put("char", "java.lang.Character");
    }

    private class AutoBoxingVisitor
    extends BaseInspectionVisitor {
        private AutoBoxingVisitor() {
        }

        public void visitSwitchExpression(PsiSwitchExpression expression2) {
            super.visitSwitchExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
            super.visitArrayAccessExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
            super.visitInstanceOfExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            super.visitParenthesizedExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            super.visitUnaryExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            if (expression2 instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)expression2;
                if (methodReferenceExpression.isConstructor()) {
                    return;
                }
                PsiElement referenceNameElement2 = methodReferenceExpression.getReferenceNameElement();
                if (referenceNameElement2 == null) {
                    return;
                }
                PsiElement target = methodReferenceExpression.resolve();
                if (!(target instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)target;
                PsiType returnType = method.getReturnType();
                if (returnType == null || returnType.equals(PsiType.VOID) || !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)returnType)) {
                    return;
                }
                PsiPrimitiveType primitiveType = (PsiPrimitiveType)returnType;
                PsiClassType boxedType = primitiveType.getBoxedType((PsiElement)expression2);
                if (boxedType == null) {
                    return;
                }
                PsiType functionalInterfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)methodReferenceExpression);
                if (functionalInterfaceReturnType == null || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)functionalInterfaceReturnType) || !functionalInterfaceReturnType.isAssignableFrom((PsiType)boxedType)) {
                    return;
                }
                this.registerError(referenceNameElement2, new Object[0]);
            } else {
                this.checkExpression((PsiExpression)expression2);
            }
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        private void checkExpression(@NotNull PsiExpression expression2) {
            if (!ExpressionUtils.isAutoBoxed(expression2)) {
                return;
            }
            if (AutoBoxingInspection.this.ignoreAddedToCollection && this.isAddedToCollection(expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private boolean isAddedToCollection(PsiExpression expression2) {
            PsiElement parent = expression2.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiElement grandParent = expressionList.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("put".equals(methodName) || "set".equals(methodName) || "add".equals(methodName))) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Collection", "java.util.Map") != null;
        }
    }

    private static class AutoBoxingFix
    extends InspectionGadgetsFix {
        private AutoBoxingFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("auto.boxing.make.boxing.explicit.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            String newExpression;
            String classToConstruct;
            PsiExpression expression2 = (PsiExpression)descriptor.getPsiElement();
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression2, false, true);
            if (expectedType == null) {
                return;
            }
            String expectedTypeText = expectedType.getCanonicalText();
            if (s_boxingClasses.containsValue(expectedTypeText)) {
                classToConstruct = expectedTypeText;
            } else {
                PsiType type2 = expression2.getType();
                if (type2 == null) {
                    return;
                }
                String expressionTypeText = type2.getCanonicalText();
                classToConstruct = s_boxingClasses.get(expressionTypeText);
            }
            if (AutoBoxingFix.shortcutReplace(expression2, classToConstruct)) {
                return;
            }
            PsiExpression strippedExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
            if (strippedExpression == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String expressionText = strippedExpression.getText();
            if ("true".equals(expressionText)) {
                newExpression = "java.lang.Boolean.TRUE";
            } else if ("false".equals(expressionText)) {
                newExpression = "java.lang.Boolean.FALSE";
            } else {
                commentTracker.markUnchanged(strippedExpression);
                newExpression = classToConstruct + ".valueOf(" + expressionText + ')';
            }
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
                PsiReplacementUtil.replaceExpression((PsiExpression)typeCastExpression, newExpression, commentTracker);
            } else {
                PsiReplacementUtil.replaceExpression(expression2, newExpression, commentTracker);
            }
        }

        private static boolean shortcutReplace(PsiExpression expression2, String classToConstruct) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 == null) {
                return false;
            }
            if (classToConstruct.equals("java.lang.Integer")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Integer", (PsiType)PsiType.INT, "intValue", new PsiType[0])) {
                    expression2.replace((PsiElement)qualifierExpression2);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Short")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Short", (PsiType)PsiType.SHORT, "shortValue", new PsiType[0])) {
                    expression2.replace((PsiElement)qualifierExpression2);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Byte")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Byte", (PsiType)PsiType.BYTE, "byteValue", new PsiType[0])) {
                    expression2.replace((PsiElement)qualifierExpression2);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Character")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Character", (PsiType)PsiType.CHAR, "charValue", new PsiType[0])) {
                    expression2.replace((PsiElement)qualifierExpression2);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Long")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Long", (PsiType)PsiType.LONG, "longValue", new PsiType[0])) {
                    expression2.replace((PsiElement)qualifierExpression2);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Float")) {
                if (MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Float", (PsiType)PsiType.FLOAT, "floatValue", new PsiType[0])) {
                    expression2.replace((PsiElement)qualifierExpression2);
                    return true;
                }
            } else if (classToConstruct.equals("java.lang.Double") && MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Double", (PsiType)PsiType.DOUBLE, "doubleValue", new PsiType[0])) {
                expression2.replace((PsiElement)qualifierExpression2);
                return true;
            }
            return false;
        }
    }
}

